/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.core.client.render.animation.Animation;

public class CapabilityAnimation {
    private static final Set<Class<? extends Entity>> ANIMATE = Sets.newHashSet();
    private static final ResourceLocation ANIM = new ResourceLocation("thutcore:animations");
    @CapabilityInject(value=IAnimationHolder.class)
    public static final Capability<IAnimationHolder> CAPABILITY = null;

    @SubscribeEvent
    public static void attachCap(AttachCapabilitiesEvent<Entity> event) {
        if (ANIMATE.contains(((Entity)event.getObject()).getClass())) {
            event.addCapability(ANIM, (ICapabilityProvider)new DefaultImpl());
        }
    }

    public static void registerAnimateClass(Class<? extends Entity> clazz) {
        ANIMATE.add(clazz);
    }

    public static void setup() {
        CapabilityManager.INSTANCE.register(IAnimationHolder.class, (Capability.IStorage)new Storage(), DefaultImpl::new);
        MinecraftForge.EVENT_BUS.register(CapabilityAnimation.class);
    }

    private static class Storage
    implements Capability.IStorage<IAnimationHolder> {
        private Storage() {
        }

        public void readNBT(Capability<IAnimationHolder> capability, IAnimationHolder instance, Direction side, INBT nbt) {
        }

        public INBT writeNBT(Capability<IAnimationHolder> capability, IAnimationHolder instance, Direction side) {
            return null;
        }
    }

    public static interface IAnimationHolder {
        public void clean();

        public String getPendingAnimations();

        public List<Animation> getPlaying();

        public void setPendingAnimations(List<Animation> var1, String var2);

        public void setStep(Animation var1, float var2);

        public String getAnimation(Entity var1);
    }

    public static class DefaultImpl
    implements IAnimationHolder,
    ICapabilityProvider {
        private static final List<Animation> EMPTY = Collections.emptyList();
        private final LazyOptional<IAnimationHolder> holder = LazyOptional.of(() -> this);
        Map<String, List<Animation>> anims = Maps.newHashMap();
        List<Animation> playingList = EMPTY;
        List<Animation> non_static = Lists.newArrayList();
        String pending = "";
        String playing = "";

        @Override
        public void clean() {
            this.pending = "";
            this.playing = "";
            this.playingList = EMPTY;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CAPABILITY.orEmpty(cap, this.holder);
        }

        @Override
        public String getPendingAnimations() {
            return this.pending;
        }

        @Override
        public List<Animation> getPlaying() {
            if (this.non_static.isEmpty() && !this.pending.isEmpty()) {
                this.playingList = this.anims.getOrDefault(this.pending, EMPTY);
                this.playing = this.pending;
                this.non_static.clear();
                for (Animation a : this.playingList) {
                    if (a.getLength() <= 0) continue;
                    this.non_static.add(a);
                }
            }
            return this.playingList;
        }

        @Override
        public void setPendingAnimations(List<Animation> list, String name) {
            this.anims.put(name, Lists.newArrayList(list));
            this.getPlaying();
            this.pending = name;
        }

        @Override
        public void setStep(Animation animation, float step) {
            int l = animation.getLength();
            if (l != 0 && step > (float)l && !this.pending.equals(this.playing)) {
                this.non_static.remove(animation);
            }
        }

        @Override
        public String getAnimation(Entity entityIn) {
            return this.playing;
        }
    }
}

