/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation.prefab;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.AnimationComponent;
import thut.core.client.render.animation.AnimationRegistry;
import thut.core.client.render.animation.AnimationXML;
import thut.core.common.ThutCore;

public class SnakeMovement
extends Animation {
    public SnakeMovement() {
        this.loops = true;
        this.name = "walking";
    }

    public SnakeMovement init(ArrayList<String> parts, int duration, float maxAngle, int axis) {
        duration += duration % 4;
        float angle = maxAngle;
        int num = parts.size();
        int mod = num > 6 ? 3 : 2;
        for (int i = 0; i < parts.size(); ++i) {
            String ident = "";
            String s = parts.get(i);
            angle = (float)(Math.sin((double)i * Math.PI / (double)(2 * mod) - 1.5707963267948966) * (double)maxAngle);
            AnimationComponent component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = "1";
            component1.identifier = "1";
            component1.startKey = 0;
            component1.rotChange[axis] = angle;
            AnimationComponent component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = "2";
            component2.identifier = "2";
            component2.startKey = duration / 4;
            component2.rotChange[axis] = -2.0f * angle;
            AnimationComponent component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = "3";
            component3.identifier = "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[axis] = angle;
            ArrayList set = Lists.newArrayList();
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        return this;
    }

    @Override
    public Animation init(AnimationXML.Phase map, AnimationRegistry.IPartRenamer renamer) {
        ArrayList<String> parts = new ArrayList<String>();
        int duration = 40;
        int axis = 1;
        float maxAngle = 10.0f;
        String[] partsArr = this.get(map, "parts").split(":");
        if (renamer != null) {
            renamer.convertToIdents(partsArr);
        }
        for (String s : partsArr) {
            if (s == null) continue;
            parts.add(ThutCore.trim(s));
        }
        if (!this.get(map, "angle").isEmpty()) {
            maxAngle = Float.parseFloat(this.get(map, "angle"));
        }
        if (!this.get(map, "axis").isEmpty()) {
            axis = Integer.parseInt(this.get(map, "axis"));
        }
        if (!this.get(map, "length").isEmpty()) {
            duration = Integer.parseInt(this.get(map, "length"));
        }
        if (!this.get(map, "duration").isEmpty()) {
            duration = Integer.parseInt(this.get(map, "duration"));
        }
        this.init(parts, duration, maxAngle, axis);
        return this;
    }
}

