/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.ResourceLocation;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.AnimationXML;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.model.IModelCustom;
import thut.core.client.render.model.parts.Material;
import thut.core.client.render.texturing.IPartTexturer;

public interface IExtendedModelPart
extends IModelCustom {
    public static void sort(List<String> order, Map<String, IExtendedModelPart> parts) {
        order.clear();
        order.addAll(parts.keySet());
        order.sort((s1, s2) -> {
            IExtendedModelPart o1 = (IExtendedModelPart)parts.get(s1);
            IExtendedModelPart o2 = (IExtendedModelPart)parts.get(s2);
            boolean transp1 = false;
            boolean transp2 = false;
            for (Material m : o1.getMaterials()) {
                transp1 = m.transluscent || m.alpha < 1.0f;
                if (!transp1) continue;
                break;
            }
            for (Material m : o2.getMaterials()) {
                transp2 = m.transluscent || m.alpha < 1.0f;
                if (!transp2) continue;
                break;
            }
            if (transp1 != transp2) {
                return transp1 ? 1 : -1;
            }
            return s1.compareTo((String)s2);
        });
    }

    public void addChild(IExtendedModelPart var1);

    public List<Material> getMaterials();

    public void applyTexture(IRenderTypeBuffer var1, ResourceLocation var2, IPartTexturer var3);

    default public void addMaterial(Material material) {
        this.getMaterials().add(material);
    }

    default public void rotateForChild(MatrixStack mat) {
    }

    default public void unRotateForChild(MatrixStack mat) {
    }

    default public void preProcess() {
        for (IExtendedModelPart o : this.getSubParts().values()) {
            o.preProcess();
        }
    }

    default public void sort(List<String> order) {
        IExtendedModelPart.sort(order, this.getSubParts());
    }

    public Vector4 getDefaultRotations();

    public Vector3 getDefaultTranslations();

    public String getName();

    public IExtendedModelPart getParent();

    public int[] getRGBABrO();

    public <T extends IExtendedModelPart> HashMap<String, T> getSubParts();

    public String getType();

    default public void removeChild(String name) {
        this.getSubParts().remove(name);
    }

    public void resetToInit();

    default public void setHidden(boolean hidden) {
    }

    default public void updateMaterial(AnimationXML.Mat mat, Material material) {
    }

    public void setAnimationHolder(CapabilityAnimation.IAnimationHolder var1);

    public CapabilityAnimation.IAnimationHolder getAnimationHolder();

    public void setParent(IExtendedModelPart var1);

    public void setPostRotations(Vector4 var1);

    public void setPostTranslations(Vector3 var1);

    public void setPreRotations(Vector4 var1);

    public void setPreScale(Vector3 var1);

    public void setPreTranslations(Vector3 var1);

    public void setRGBABrO(int var1, int var2, int var3, int var4, int var5, int var6);
}

