/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import thut.api.ModelHolder;
import thut.core.client.render.mca.McaModel;
import thut.core.client.render.model.IModel;
import thut.core.client.render.obj.ObjModel;
import thut.core.client.render.x3d.X3dModel;
import thut.core.common.ThutCore;

public class ModelFactory {
    private static final Map<String, IFactory<?>> modelFactories = Maps.newHashMap();
    public static final List<String> knownExtension = Lists.newArrayList();

    public static IModel create(ResourceLocation location, ModelHolder model) {
        String ext;
        String path = location.func_110623_a();
        String string = ext = path.contains(".") ? path.substring(path.lastIndexOf(".") + 1, path.length()) : "";
        if (ext.isEmpty()) {
            IModel ret = null;
            for (String ext1 : knownExtension) {
                IFactory<?> factory = modelFactories.get(ext1);
                ResourceLocation model1 = new ResourceLocation(location.func_110624_b(), path + "." + ext1);
                ThutCore.LOGGER.debug("Checking " + model1);
                ret = factory.create(model1);
                ext = ext1;
                if (ret == null || !ret.isValid()) continue;
                break;
            }
            if (ret == null) {
                ret = new X3dModel();
            }
            if (!ret.isValid()) {
                ThutCore.LOGGER.error("No Model found for " + location);
            } else {
                ThutCore.LOGGER.debug("Successfully loaded model for " + location);
                model.extension = ext;
            }
            return ret;
        }
        IFactory<?> factory = modelFactories.get(ext);
        model.extension = ext;
        return factory.create(location);
    }

    public static IModel create(ModelHolder model) {
        IModel made = ModelFactory.create(model.model, model);
        if (!made.isValid()) {
            for (ResourceLocation loc : model.backupModels) {
                made = ModelFactory.create(loc, model);
                if (made.isValid()) continue;
                return made;
            }
        }
        return made;
    }

    public static Set<String> getValidExtensions() {
        return modelFactories.keySet();
    }

    public static void registerIModel(String extension, IFactory<?> clazz) {
        modelFactories.put(extension, clazz);
        if (!knownExtension.contains(extension)) {
            knownExtension.add(extension);
        }
    }

    static {
        ModelFactory.registerIModel("x3d", X3dModel::new);
        ModelFactory.registerIModel("mca", McaModel::new);
        ModelFactory.registerIModel("obj", ObjModel::new);
    }

    public static interface IFactory<T extends IModel> {
        public T create(ResourceLocation var1);
    }
}

