/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model.parts;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.ResourceLocation;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.AnimationXML;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.animation.IAnimationChanger;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.model.parts.Material;
import thut.core.client.render.model.parts.Mesh;
import thut.core.client.render.texturing.IPartTexturer;
import thut.core.client.render.texturing.IRetexturableModel;
import thut.core.common.ThutCore;

public abstract class Part
implements IExtendedModelPart,
IRetexturableModel {
    private final HashMap<String, IExtendedModelPart> parts = new HashMap();
    private final List<String> order = Lists.newArrayList();
    private final List<Mesh> shapes = Lists.newArrayList();
    private final String name;
    private IExtendedModelPart parent = null;
    IPartTexturer texturer;
    IAnimationChanger changer;
    CapabilityAnimation.IAnimationHolder currentHolder = null;
    public Vector4 preRot = new Vector4();
    public Vector4 postRot = new Vector4();
    public Vector3 preTrans = Vector3.getNewVector();
    public Vector3 postTrans = Vector3.getNewVector();
    public Vertex preScale = new Vertex(1.0f, 1.0f, 1.0f);
    public Vector3 offset = Vector3.getNewVector();
    public Vector4 rotations = new Vector4();
    public Vertex scale = new Vertex(1.0f, 1.0f, 1.0f);
    public int red = 255;
    public int green = 255;
    public int blue = 255;
    public int alpha = 255;
    public int brightness = 0xF00000;
    public int overlay = 655360;
    private final int[] rgbabro = new int[6];
    private boolean hidden = false;
    private final List<Material> materials = Lists.newArrayList();
    private final Set<Material> matcache = Sets.newHashSet();

    public Part(String name) {
        this.name = name;
    }

    @Override
    public void preProcess() {
        this.sort(this.order);
        IExtendedModelPart.super.preProcess();
    }

    public void addShape(Mesh shape) {
        this.shapes.add(shape);
        if (shape.material == null) {
            return;
        }
        if (this.matcache.add(shape.material)) {
            this.materials.add(shape.material);
        }
    }

    public void setShapes(List<Mesh> shapes) {
        this.shapes.clear();
        this.shapes.addAll(shapes);
        for (Mesh shape : shapes) {
            if (shape.material == null || !this.matcache.add(shape.material)) continue;
            this.materials.add(shape.material);
        }
    }

    @Override
    public void applyTexture(IRenderTypeBuffer bufferIn, ResourceLocation tex, IPartTexturer texer) {
        for (Mesh shape : this.shapes) {
            ResourceLocation tex_1 = tex;
            if (texer.hasMapping(shape.material.name)) {
                tex_1 = texer.getTexture(shape.material.name, tex);
            }
            shape.material.makeVertexBuilder(tex_1, bufferIn);
        }
    }

    @Override
    public void addChild(IExtendedModelPart subPart) {
        this.parts.put(subPart.getName(), subPart);
        subPart.setParent(this);
    }

    @Override
    public List<Material> getMaterials() {
        return this.materials;
    }

    @Override
    public Vector4 getDefaultRotations() {
        return this.rotations;
    }

    @Override
    public Vector3 getDefaultTranslations() {
        return this.offset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IExtendedModelPart getParent() {
        return this.parent;
    }

    @Override
    public int[] getRGBABrO() {
        this.rgbabro[0] = this.red;
        this.rgbabro[1] = this.green;
        this.rgbabro[2] = this.blue;
        this.rgbabro[3] = this.alpha;
        this.rgbabro[4] = this.brightness;
        this.rgbabro[5] = this.overlay;
        return this.rgbabro;
    }

    public HashMap<String, IExtendedModelPart> getSubParts() {
        return this.parts;
    }

    private void postRender(MatrixStack mat) {
        mat.func_227865_b_();
        if (this.parent != null) {
            this.parent.unRotateForChild(mat);
        }
    }

    private void preRender(MatrixStack mat) {
        mat.func_227862_a_(this.preScale.x, this.preScale.y, this.preScale.z);
        mat.func_227860_a_();
        mat.func_227861_a_(this.offset.x, this.offset.y, this.offset.z);
        mat.func_227861_a_(this.preTrans.x, this.preTrans.y, this.preTrans.z);
        this.rotations.glRotate(mat);
        this.preRot.glRotate(mat);
        mat.func_227861_a_(this.postTrans.x, this.postTrans.y, this.postTrans.z);
        this.postRot.glRotate(mat);
        mat.func_227862_a_(this.scale.x, this.scale.y, this.scale.z);
    }

    public void render(MatrixStack mat, IVertexBuilder buffer) {
        if (this.hidden) {
            return;
        }
        for (Mesh s : this.shapes) {
            s.rgbabro = this.getRGBABrO();
            s.renderShape(mat, buffer, this.texturer);
        }
    }

    @Override
    public void renderAll(MatrixStack mat, IVertexBuilder buffer) {
        this.renderAllExcept(mat, buffer, "");
    }

    @Override
    public void renderAllExcept(MatrixStack mat, IVertexBuilder buffer, String ... excludedGroupNames) {
        String s1;
        boolean skip = this.hidden;
        String[] stringArray = excludedGroupNames;
        int n = stringArray.length;
        for (int i = 0; i < n && !(skip = (s1 = stringArray[i]).equalsIgnoreCase(this.name)); ++i) {
        }
        if (!skip) {
            this.preRender(mat);
            for (String s : this.order) {
                IExtendedModelPart o = this.parts.get(s);
                o.renderAllExcept(mat, buffer, excludedGroupNames);
            }
            this.render(mat, buffer);
            this.postRender(mat);
        }
    }

    @Override
    public void renderOnly(MatrixStack mat, IVertexBuilder buffer, String ... groupNames) {
        boolean rendered = false;
        for (String s1 : groupNames) {
            rendered = s1.equalsIgnoreCase(this.name);
            if (!rendered) continue;
            this.preRender(mat);
            this.render(mat, buffer);
            this.postRender(mat);
            break;
        }
        if (!rendered) {
            this.preRender(mat);
            for (String s : this.order) {
                IExtendedModelPart o = this.parts.get(s);
                o.renderOnly(mat, buffer, groupNames);
            }
            this.postRender(mat);
        }
    }

    @Override
    public void renderPart(MatrixStack mat, IVertexBuilder buffer, String partName) {
        this.renderOnly(mat, buffer, partName);
    }

    @Override
    public void resetToInit() {
        this.preRot.set(0.0f, 0.0f, 0.0f, 1.0f);
        this.postRot.set(0.0f, 0.0f, 0.0f, 1.0f);
        this.preTrans.clear();
        this.postTrans.clear();
        this.hidden = false;
    }

    @Override
    public void rotateForChild(MatrixStack mat) {
        if (this.parent != null) {
            this.parent.rotateForChild(mat);
        }
    }

    @Override
    public void unRotateForChild(MatrixStack mat) {
        if (this.parent != null) {
            this.parent.unRotateForChild(mat);
        }
    }

    @Override
    public void setAnimationChanger(IAnimationChanger changer) {
        this.changer = changer;
        for (IExtendedModelPart part : this.parts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            ((IRetexturableModel)((Object)part)).setAnimationChanger(changer);
        }
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public void setParent(IExtendedModelPart parent) {
        this.parent = parent;
    }

    @Override
    public void setPostRotations(Vector4 angles) {
        this.postRot = angles;
    }

    @Override
    public void setPostTranslations(Vector3 point) {
        this.postTrans.set(point);
    }

    @Override
    public void setPreRotations(Vector4 angles) {
        this.preRot = angles;
    }

    @Override
    public void setPreScale(Vector3 scale) {
        this.preScale.x = (float)scale.x;
        this.preScale.y = (float)scale.y;
        this.preScale.z = (float)scale.z;
    }

    @Override
    public void setPreTranslations(Vector3 point) {
        this.preTrans.set(point);
    }

    @Override
    public void setRGBABrO(int r, int g, int b, int a, int br, int o) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.alpha = a;
        this.brightness = br;
        this.overlay = o;
    }

    @Override
    public void setTexturer(IPartTexturer texturer) {
        this.texturer = texturer;
        for (IExtendedModelPart part : this.parts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            ((IRetexturableModel)((Object)part)).setTexturer(texturer);
        }
    }

    @Override
    public void updateMaterial(AnimationXML.Mat mat, Material material) {
        String[] parts = mat.name.split(":");
        for (String s : parts) {
            for (Mesh mesh : this.shapes) {
                if (mesh.name == null) {
                    mesh.name = this.getName();
                }
                if (!mesh.name.equals(ThutCore.trim(s)) && !mesh.name.equals(mat.name)) continue;
                mesh.setMaterial(material);
            }
        }
        for (Material m : this.materials) {
            if (!m.name.equals(mat.name)) continue;
            this.matcache.remove(m);
            this.materials.remove(m);
            break;
        }
        this.matcache.add(material);
        this.materials.add(material);
    }

    @Override
    public CapabilityAnimation.IAnimationHolder getAnimationHolder() {
        return this.currentHolder;
    }

    @Override
    public void setAnimationHolder(CapabilityAnimation.IAnimationHolder holder) {
        this.currentHolder = holder;
    }
}

