/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.x3d;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.AnimationComponent;
import thut.core.client.render.animation.AnimationHelper;
import thut.core.client.render.animation.IAnimationChanger;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.IModel;
import thut.core.client.render.model.IModelCustom;
import thut.core.client.render.model.IModelRenderer;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.model.parts.Material;
import thut.core.client.render.texturing.IPartTexturer;
import thut.core.client.render.texturing.IRetexturableModel;
import thut.core.client.render.x3d.X3dMesh;
import thut.core.client.render.x3d.X3dPart;
import thut.core.client.render.x3d.X3dXML;
import thut.core.common.ThutCore;

public class X3dModel
implements IModelCustom,
IModel,
IRetexturableModel {
    public HashMap<String, IExtendedModelPart> parts = new HashMap();
    private final List<String> order = Lists.newArrayList();
    Map<String, Material> mats = Maps.newHashMap();
    Set<String> heads = Sets.newHashSet();
    final IModel.HeadInfo info = new IModel.HeadInfo();
    public String name;
    protected boolean valid = false;

    public X3dModel() {
    }

    public X3dModel(ResourceLocation l) {
        this();
        this.loadModel(l);
    }

    private void addChildren(Set<X3dXML.Transform> allTransforms, X3dXML.Transform transform) {
        for (X3dXML.Transform f : transform.transforms) {
            if (f.DEF.contains("ifs_TRANSFORM")) continue;
            allTransforms.add(f);
            this.addChildren(allTransforms, f);
        }
    }

    @Override
    public void applyAnimation(Entity entity, IModelRenderer<?> renderer, float partialTicks, float limbSwing) {
        this.updateAnimation(entity, renderer, renderer.getAnimation(entity), partialTicks, this.getHeadInfo().headYaw, this.getHeadInfo().headYaw, limbSwing);
    }

    @Override
    public IModel.HeadInfo getHeadInfo() {
        return this.info;
    }

    @Override
    public Set<String> getHeadParts() {
        return this.heads;
    }

    public List<String> getOrder() {
        if (this.order.isEmpty()) {
            IExtendedModelPart.sort(this.order, this.getParts());
            for (String s : this.getOrder()) {
                IExtendedModelPart o = this.parts.get(s);
                o.preProcess();
            }
        }
        return this.order;
    }

    private Material getMaterial(X3dXML.Appearance appearance) {
        X3dXML.Material mat = appearance.material;
        if (mat == null) {
            return null;
        }
        String matName = mat.DEF;
        boolean isDef = matName != null;
        matName = matName == null ? mat.USE.substring(3) : matName.substring(3);
        Material material = this.mats.get(matName = ThutCore.trim(matName));
        if (material == null || isDef) {
            String texName;
            if (appearance.tex != null && appearance.tex.DEF != null) {
                texName = appearance.tex.DEF.substring(3);
                if (texName.contains("_png")) {
                    texName = texName.substring(0, texName.lastIndexOf("_png"));
                }
                texName = ThutCore.trim(texName);
            } else {
                texName = null;
            }
            if (material == null) {
                material = new Material(matName, texName, mat.getDiffuse(), mat.getSpecular(), mat.getEmissive(), mat.ambientIntensity, mat.shininess);
            }
            if (isDef) {
                if (material.texture == null) {
                    material.texture = texName;
                }
                material.ambientIntensity = mat.ambientIntensity;
                material.shininess = mat.shininess;
                material.emissiveColor = mat.getEmissive();
                material.specularColor = mat.getSpecular();
                material.diffuseColor = mat.getDiffuse();
                material.emissiveMagnitude = Math.min(1.0f, (float)((double)mat.getEmissive().length() / Math.sqrt(3.0)) / 0.8f);
            }
            this.mats.put(matName, material);
        }
        return material;
    }

    @Override
    public HashMap<String, IExtendedModelPart> getParts() {
        return this.parts;
    }

    private boolean isHead(String partName) {
        return this.getHeadParts().contains(partName);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public void loadModel(ResourceLocation model) {
        block3: {
            this.valid = true;
            try {
                IResource res = Minecraft.func_71410_x().func_195551_G().func_199002_a(model);
                if (res == null) {
                    this.valid = false;
                    return;
                }
                X3dXML xml = new X3dXML(res.func_199027_b());
                res.close();
                this.makeObjects(xml);
            }
            catch (Exception e) {
                this.valid = false;
                if (e instanceof FileNotFoundException) break block3;
                ThutCore.LOGGER.error("error loading " + model, (Throwable)e);
            }
        }
    }

    public HashMap<String, IExtendedModelPart> makeObjects(X3dXML xml) throws Exception {
        HashMap childMap = Maps.newHashMap();
        HashSet allTransforms = Sets.newHashSet();
        for (X3dXML.Transform transform : xml.model.scene.transforms) {
            allTransforms.add(transform);
            this.addChildren(allTransforms, transform);
        }
        for (X3dXML.Transform transform : allTransforms) {
            String[] offset = transform.translation.split(" ");
            Vector3 translation = Vector3.getNewVector().set(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]));
            offset = transform.scale.split(" ");
            Vertex scale = new Vertex(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]));
            offset = transform.rotation.split(" ");
            Vector3f axis = new Vector3f(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]));
            Quaternion quat = new Quaternion(axis, Float.parseFloat(offset[3]), false);
            Vector4 rotations = new Vector4(quat);
            Set<String> children = transform.getChildNames();
            X3dXML.Transform transform2 = transform.getIfsTransform();
            if (transform2 == null) continue;
            X3dXML.Group group = transform2.group;
            String name = ThutCore.trim(transform2.getGroupName());
            ArrayList shapes = Lists.newArrayList();
            for (X3dXML.Shape shape : group.shapes) {
                X3dXML.IndexedTriangleSet triangleSet = shape.triangleSet;
                X3dMesh renderShape = new X3dMesh(triangleSet.getOrder(), triangleSet.getVertices(), triangleSet.getNormals(), triangleSet.getTexture());
                shapes.add(renderShape);
                X3dXML.Appearance appearance = shape.appearance;
                Material material = this.getMaterial(appearance);
                renderShape.name = name;
                if (material == null) continue;
                renderShape.setMaterial(material);
            }
            X3dPart o = new X3dPart(name);
            o.setShapes(shapes);
            o.rotations.set(rotations.x, rotations.y, rotations.z, rotations.w);
            o.offset.set(translation);
            o.scale = scale;
            this.parts.put(name, o);
            childMap.put(name, children);
        }
        for (Map.Entry entry : childMap.entrySet()) {
            String key = (String)entry.getKey();
            if (this.parts.get(key) == null) continue;
            IExtendedModelPart part = this.parts.get(key);
            for (String s : (Set)entry.getValue()) {
                if (this.parts.get(s) == null || this.parts.get(s) == part) continue;
                part.addChild(this.parts.get(s));
            }
        }
        return this.parts;
    }

    @Override
    public void preProcessAnimations(Collection<List<Animation>> animations) {
        for (List<Animation> list : animations) {
            for (Animation animation : list) {
                for (String s : animation.sets.keySet()) {
                    ArrayList<AnimationComponent> components = animation.sets.get(s);
                    for (AnimationComponent comp : components) {
                        double d0 = comp.posOffset[0] / 16.0;
                        double d1 = comp.posOffset[1] / 16.0;
                        double d2 = comp.posOffset[2] / 16.0;
                        comp.posOffset[0] = -d0;
                        comp.posOffset[1] = d2;
                        comp.posOffset[2] = -d1;
                        d0 = comp.posChange[0] / 16.0;
                        d1 = comp.posChange[1] / 16.0;
                        d2 = comp.posChange[2] / 16.0;
                        comp.posChange[0] = -d0;
                        comp.posChange[1] = d2;
                        comp.posChange[2] = -d1;
                    }
                }
            }
        }
        this.getOrder();
    }

    @Override
    public void renderAll(MatrixStack mat, IVertexBuilder buffer) {
        for (String s : this.getOrder()) {
            IExtendedModelPart o = this.parts.get(s);
            if (o.getParent() != null) continue;
            o.renderAll(mat, buffer);
        }
    }

    @Override
    public void renderAllExcept(MatrixStack mat, IVertexBuilder buffer, String ... excludedGroupNames) {
        for (String s : this.getOrder()) {
            IExtendedModelPart o = this.parts.get(s);
            if (o.getParent() != null) continue;
            o.renderAllExcept(mat, buffer, excludedGroupNames);
        }
    }

    @Override
    public void renderOnly(MatrixStack mat, IVertexBuilder buffer, String ... groupNames) {
        for (String s : this.getOrder()) {
            IExtendedModelPart o = this.parts.get(s);
            if (o.getParent() != null) continue;
            o.renderOnly(mat, buffer, groupNames);
        }
    }

    @Override
    public void renderPart(MatrixStack mat, IVertexBuilder buffer, String partName) {
        for (String s : this.getOrder()) {
            IExtendedModelPart o = this.parts.get(s);
            if (o.getParent() != null) continue;
            o.renderPart(mat, buffer, partName);
        }
    }

    @Override
    public void setAnimationChanger(IAnimationChanger changer) {
        for (IExtendedModelPart part : this.parts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            ((IRetexturableModel)((Object)part)).setAnimationChanger(changer);
        }
    }

    @Override
    public void setTexturer(IPartTexturer texturer) {
        for (IExtendedModelPart part : this.parts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            ((IRetexturableModel)((Object)part)).setTexturer(texturer);
        }
    }

    protected void updateAnimation(Entity entity, IModelRenderer<?> renderer, String currentPhase, float partialTicks, float headYaw, float headPitch, float limbSwing) {
        for (String partName : this.getParts().keySet()) {
            IExtendedModelPart part = this.getParts().get(partName);
            this.updateSubParts(entity, renderer, currentPhase, partialTicks, part, headYaw, headPitch, limbSwing);
        }
    }

    private void updateSubParts(Entity entity, IModelRenderer<?> renderer, String currentPhase, float partialTick, IExtendedModelPart parent, float headYaw, float headPitch, float limbSwing) {
        if (parent == null) {
            return;
        }
        IModel.HeadInfo info = this.getHeadInfo();
        parent.resetToInit();
        boolean anim = renderer.getAnimations().containsKey(currentPhase);
        if (anim) {
            AnimationHelper.doAnimation(renderer.getAnimations().get(currentPhase), entity, parent.getName(), parent, partialTick, limbSwing);
        }
        if (info != null && this.isHead(parent.getName())) {
            float ang2 = -info.headPitch;
            float head = info.headYaw + 180.0f;
            float diff = 0.0f;
            if (info.yawDirection != -1) {
                head *= -1.0f;
            }
            diff = head % 360.0f;
            diff = (diff + 360.0f) % 360.0f;
            diff = (diff - 180.0f) % 360.0f;
            diff = Math.max(diff, info.yawCapMin);
            float ang = diff = Math.min(diff, info.yawCapMax);
            ang2 = Math.max(ang2, info.pitchCapMin);
            ang2 = Math.min(ang2, info.pitchCapMax);
            Vector4 dir = info.yawAxis == 0 ? new Vector4(info.yawDirection, 0.0, 0.0, ang) : (info.yawAxis == 2 ? new Vector4(0.0, 0.0, info.yawDirection, ang) : new Vector4(0.0, info.yawDirection, 0.0, ang));
            Vector4 dir2 = info.pitchAxis == 2 ? new Vector4(0.0, 0.0, info.pitchDirection, ang2) : (info.pitchAxis == 1 ? new Vector4(0.0, info.pitchDirection, 0.0, ang2) : new Vector4(info.yawDirection, 0.0, 0.0, ang2));
            Vector4 combined = new Vector4();
            combined.mul(dir.toQuaternion(), dir2.toQuaternion());
            parent.setPostRotations(combined);
        }
        for (String partName : parent.getSubParts().keySet()) {
            IExtendedModelPart part = (IExtendedModelPart)parent.getSubParts().get(partName);
            this.updateSubParts(entity, renderer, currentPhase, partialTick, part, headYaw, headPitch, limbSwing);
        }
    }
}

