/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.core.common.ThutCore;
import thut.core.common.commands.CommandTools;
import thut.core.common.config.Config;

public class CommandConfigs {
    protected static int execute(Config.ConfigData data, CommandSource source, String field) {
        try {
            Field f = data.getClass().getField(field);
            Object value = f.get(data);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("thutcore.command.settings.check", new Object[]{field, value}), true);
        }
        catch (Exception e) {
            throw new CommandException((ITextComponent)new StringTextComponent("Error with field name " + field));
        }
        return 0;
    }

    protected static int execute(Config.ConfigData data, CommandSource source, String field, String message) {
        Field f = null;
        Object value = null;
        try {
            f = data.getClass().getField(field);
            value = f.get(data);
        }
        catch (Exception e) {
            ThutCore.LOGGER.error((Object)e);
            throw new CommandException((ITextComponent)new StringTextComponent("Error with field name " + field));
        }
        String[] args = message.split(" ");
        String val = args[0];
        if (val.equals("!set")) {
            CommandConfigs.handleSet(data, args, value, f);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("thutcore.command.settings.array.set", new Object[]{field, value}), true);
            return 0;
        }
        if (val.equals("!add")) {
            CommandConfigs.handleAdd(data, args, value, f);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("thutcore.command.settings.array.add", new Object[]{field, value}), true);
            return 0;
        }
        if (val.equals("!remove")) {
            CommandConfigs.handleRemove(data, args, value, f);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("thutcore.command.settings.array.remove", new Object[]{field, value}), true);
            return 0;
        }
        if (args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                val = val + " " + args[i];
            }
        }
        try {
            data.updateField(f, val);
            value = f.get(data);
        }
        catch (Exception e) {
            throw new CommandException((ITextComponent)new StringTextComponent("Error with setting field name " + field));
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("thutcore.command.settings.set", new Object[]{field, value}), true);
        return 0;
    }

    static void handleAdd(Config.ConfigData data, String[] args, Object o, Field field) throws CommandException {
        String value = args[1];
        for (int i = 3; i < args.length; ++i) {
            value = value + " " + args[i];
        }
        Object[] toSet = null;
        if (o instanceof String[]) {
            int len = ((String[])o).length;
            toSet = Arrays.copyOf((String[])o, len + 1);
            toSet[len] = value;
        } else if (o instanceof int[]) {
            int len = ((int[])o).length;
            toSet = Arrays.copyOf((int[])o, len + 1);
            ((int[])toSet)[len] = CommandConfigs.parseInt(value);
        } else {
            throw new CommandException((ITextComponent)new StringTextComponent("This can only by done for arrays."));
        }
        try {
            data.updateField(field, toSet);
        }
        catch (Exception e) {
            throw new CommandException((ITextComponent)new StringTextComponent("Error with setting field name " + field));
        }
    }

    static void handleRemove(Config.ConfigData data, String[] args, Object o, Field field) throws CommandException {
        String value = args[1];
        for (int i = 3; i < args.length; ++i) {
            value = value + " " + args[i];
        }
        Object[] toSet = null;
        if (o instanceof String[]) {
            Object[] arr = (String[])o;
            ArrayList values = Lists.newArrayList((Object[])arr);
            int index = values.indexOf(value);
            if (index != -1) {
                values.remove(index);
            }
            toSet = values.toArray(new String[values.size()]);
        } else if (o instanceof int[]) {
            int[] arr = (int[])o;
            int arg = CommandConfigs.parseInt(value);
            ArrayList values = Lists.newArrayList();
            for (int element : arr) {
                values.add(element);
            }
            int index = values.indexOf(arg);
            if (index != -1) {
                values.remove(index);
            }
            arr = new int[values.size()];
            toSet = arr;
            for (int i = 0; i < values.size(); ++i) {
                arr[i] = (Integer)values.get(i);
            }
        } else {
            throw new CommandException((ITextComponent)new StringTextComponent("This can only by done for arrays."));
        }
        try {
            data.updateField(field, toSet);
        }
        catch (Exception e) {
            throw new CommandException((ITextComponent)new StringTextComponent("Error with setting field name " + field));
        }
    }

    static void handleSet(Config.ConfigData data, String[] args, Object o, Field field) throws CommandException {
        int num = CommandConfigs.parseInt(args[1]);
        String value = args[2];
        for (int i = 4; i < args.length; ++i) {
            value = value + " " + args[i];
        }
        Object toSet = null;
        if (o instanceof String[]) {
            ((String[])o)[num] = value;
            toSet = ((String[])o).clone();
        } else if (o instanceof int[]) {
            ((int[])o)[num] = CommandConfigs.parseInt(value);
            toSet = ((int[])o).clone();
        } else {
            throw new CommandException((ITextComponent)new StringTextComponent("This can only by done for arrays."));
        }
        try {
            data.updateField(field, toSet);
        }
        catch (Exception e) {
            throw new CommandException((ITextComponent)new StringTextComponent("Error with setting field name " + field));
        }
    }

    public static SuggestionProvider<CommandSource> MakeProvider(Config.ConfigData data) {
        ArrayList values = Lists.newArrayList();
        for (Field f : data.commonValues.keySet()) {
            values.add(f.getName());
        }
        for (Field f : data.serverValues.keySet()) {
            values.add(f.getName());
        }
        for (Field f : data.clientValues.keySet()) {
            values.add(f.getName());
        }
        return (ctx, sb) -> ISuggestionProvider.func_197005_b((Iterable)values, (SuggestionsBuilder)sb);
    }

    public static int parseInt(String input) throws CommandException {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException var2) {
            throw new CommandException((ITextComponent)new TranslationTextComponent("commands.generic.num.invalid", new Object[]{input}));
        }
    }

    public static void register(Config.ConfigData data, CommandDispatcher<CommandSource> commandDispatcher, String prefix) {
        String name = "";
        name = prefix;
        String perm1 = "command." + name + ".check";
        PermissionAPI.registerNode((String)perm1, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Is the player allowed to check configs for " + data.MODID));
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> CommandTools.hasPerm(cs, perm1))).then(Commands.func_197056_a((String)"option", (ArgumentType)StringArgumentType.string()).suggests(CommandConfigs.MakeProvider(data)).executes(ctx -> CommandConfigs.execute(data, (CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"option"))));
        commandDispatcher.register(command);
        String perm2 = "command." + name + ".set";
        PermissionAPI.registerNode((String)perm2, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)("Is the player allowed to set configs for " + data.MODID));
        command = (LiteralArgumentBuilder)Commands.func_197057_a((String)name).then(Commands.func_197056_a((String)"option", (ArgumentType)StringArgumentType.string()).suggests(CommandConfigs.MakeProvider(data)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"value", (ArgumentType)StringArgumentType.greedyString()).requires(cs -> CommandTools.hasPerm(cs, perm2))).executes(ctx -> CommandConfigs.execute(data, (CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"option"), StringArgumentType.getString((CommandContext)ctx, (String)"value")))));
        commandDispatcher.register(command);
    }
}

