/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.commands;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public class CommandTools {
    public static boolean hasPerm(CommandSource source, String permission) {
        try {
            ServerPlayerEntity player = source.func_197035_h();
            return CommandTools.hasPerm(player, permission);
        }
        catch (CommandSyntaxException e) {
            return true;
        }
    }

    public static boolean hasPerm(ServerPlayerEntity player, String permission) {
        if (!PermissionAPI.getPermissionHandler().getRegisteredNodes().contains(permission)) {
            String message = "Autogenerated node, this is a bug and should be pre-registered.";
            PermissionAPI.getPermissionHandler().registerNode(permission, DefaultPermissionLevel.OP, "Autogenerated node, this is a bug and should be pre-registered.");
            System.err.println("Autogenerated node, this is a bug and should be pre-registered.: " + permission);
        }
        return PermissionAPI.hasPermission((PlayerEntity)player, (String)permission);
    }

    public static ITextComponent makeError(String text) {
        return CommandTools.makeTranslatedMessage(text, "red:italic", new Object[0]);
    }

    public static ITextComponent makeTranslatedMessage(String key, String formatting, Object ... args) {
        if (formatting == null) {
            formatting = "";
        }
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof String)) continue;
            args[i] = new TranslationTextComponent((String)args[i], new Object[0]);
        }
        TranslationTextComponent translated = new TranslationTextComponent(key, args);
        if (!formatting.isEmpty()) {
            String[] args2 = formatting.split(":");
            String colour = args2[0].toUpperCase(Locale.ROOT);
            translated.func_150256_b().func_150238_a(TextFormatting.func_96300_b((String)colour));
            if (args2.length > 1) {
                for (int i1 = 1; i1 < args2.length; ++i1) {
                    String arg = args2[i1];
                    if (arg.equalsIgnoreCase("italic")) {
                        translated.func_150256_b().func_150217_b(Boolean.valueOf(true));
                    }
                    if (arg.equalsIgnoreCase("bold")) {
                        translated.func_150256_b().func_150227_a(Boolean.valueOf(true));
                    }
                    if (arg.equalsIgnoreCase("underlined")) {
                        translated.func_150256_b().func_150228_d(Boolean.valueOf(true));
                    }
                    if (arg.equalsIgnoreCase("strikethrough")) {
                        translated.func_150256_b().func_150225_c(Boolean.valueOf(true));
                    }
                    if (!arg.equalsIgnoreCase("obfuscated")) continue;
                    translated.func_150256_b().func_150237_e(Boolean.valueOf(true));
                }
            }
        }
        return translated;
    }

    public static void sendBadArgumentsMissingArg(ICommandSource sender) {
        sender.func_145747_a(CommandTools.makeError("pokecube.command.invalidmissing"));
    }

    public static void sendBadArgumentsTryTab(ICommandSource sender) {
        sender.func_145747_a(CommandTools.makeError("pokecube.command.invalidtab"));
    }

    public static void sendError(CommandSource sender, String text) {
        sender.func_197021_a(CommandTools.makeError(text));
    }

    public static void sendError(ICommandSource sender, String text) {
        sender.func_145747_a(CommandTools.makeError(text));
    }

    public static void sendMessage(ICommandSource sender, String text) {
        ITextComponent message = CommandTools.makeTranslatedMessage(text, null, new Object[0]);
        sender.func_145747_a(message);
    }

    public static void sendNoPermissions(ICommandSource sender) {
        sender.func_145747_a(CommandTools.makeError("pokecube.command.noperms"));
    }
}

