/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.network;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraftforge.fml.network.PacketDistributor;
import thut.core.common.ThutCore;
import thut.core.common.network.NBTPacket;
import thut.core.common.network.PacketAssembly;

public class TileUpdate
extends NBTPacket {
    public static final PacketAssembly<TileUpdate> ASSEMBLER = PacketAssembly.registerAssembler(TileUpdate.class, TileUpdate::new, ThutCore.packets);

    public static void sendUpdate(TileEntity tile) {
        if (tile.func_145831_w().field_72995_K) {
            ThutCore.LOGGER.error("Packet sent on wrong side!");
            return;
        }
        CompoundNBT tag = new CompoundNBT();
        CompoundNBT pos = NBTUtil.func_186859_a((BlockPos)tile.func_174877_v());
        tag.func_218657_a("pos", (INBT)pos);
        CompoundNBT mobtag = tile.func_189517_E_();
        tag.func_218657_a("tag", (INBT)mobtag);
        TileUpdate message = new TileUpdate(tag);
        IChunk chunk = tile.func_145831_w().func_217349_x(tile.func_174877_v());
        if (chunk instanceof Chunk && ((Chunk)chunk).func_177412_p().func_72863_F() instanceof ServerChunkProvider) {
            ASSEMBLER.sendTo(message, PacketDistributor.TRACKING_CHUNK.with(() -> (Chunk)chunk));
        }
    }

    public TileUpdate() {
    }

    public TileUpdate(CompoundNBT tag) {
        this.tag = tag;
    }

    public TileUpdate(PacketBuffer buffer) {
        super(buffer);
    }

    @Override
    protected void onCompleteClient() {
        PlayerEntity player = ThutCore.proxy.getPlayer();
        BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)this.tag.func_74775_l("pos"));
        TileEntity tile = player.func_130014_f_().func_175625_s(pos);
        if (tile != null) {
            tile.handleUpdateTag(this.tag.func_74775_l("tag"));
        }
    }
}

