/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.terrain;

import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.terrain.TerrainEffectEvent;
import thut.api.terrain.TerrainManager;
import thut.api.terrain.TerrainSegment;

public class CapabilityTerrainAffected {
    private static final ResourceLocation TERRAINEFFECTCAP = new ResourceLocation("thutcore", "terrainEffects");
    @CapabilityInject(value=ITerrainAffected.class)
    public static final Capability<ITerrainAffected> TERRAIN_CAP = null;

    public CapabilityTerrainAffected() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void EntityUpdate(LivingEvent.LivingUpdateEvent evt) {
        ITerrainAffected effects = (ITerrainAffected)evt.getEntity().getCapability(TERRAIN_CAP, null).orElse(null);
        if (effects != null) {
            effects.onTerrainTick();
        }
    }

    @SubscribeEvent
    public void onEntityCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof LivingEntity) || event.getCapabilities().containsKey(TERRAINEFFECTCAP)) {
            return;
        }
        DefaultAffected effects = new DefaultAffected();
        effects.attach((LivingEntity)event.getObject());
        event.addCapability(TERRAINEFFECTCAP, (ICapabilityProvider)effects);
    }

    public static interface ITerrainAffected {
        public void attach(LivingEntity var1);

        public LivingEntity getAttached();

        public void onTerrainTick();
    }

    public static class DefaultAffected
    implements ITerrainAffected,
    ICapabilityProvider {
        private final LazyOptional<ITerrainAffected> holder = LazyOptional.of(() -> this);
        private LivingEntity theMob;
        private TerrainSegment terrain;
        private Collection<TerrainSegment.ITerrainEffect> effects;

        @Override
        public void attach(LivingEntity mob) {
            this.theMob = mob;
        }

        @Override
        public LivingEntity getAttached() {
            return this.theMob;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
            return TERRAIN_CAP.orEmpty(capability, this.holder);
        }

        public void onTerrainEntry(TerrainSegment entered) {
            if (entered == this.terrain || this.theMob == null) {
                return;
            }
            this.terrain = entered;
            this.effects = this.terrain.getEffects();
            for (TerrainSegment.ITerrainEffect effect : this.effects) {
                TerrainEffectEvent event = new TerrainEffectEvent(this.theMob, effect.getIdenitifer(), true);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) continue;
                effect.doEffect(this.theMob, true);
            }
        }

        @Override
        public void onTerrainTick() {
            if (this.theMob == null) {
                return;
            }
            TerrainSegment current = TerrainManager.getInstance().getTerrainForEntity((Entity)this.theMob);
            if (current != this.terrain) {
                this.onTerrainEntry(current);
                return;
            }
            if (this.effects == null) {
                return;
            }
            for (TerrainSegment.ITerrainEffect effect : this.effects) {
                TerrainEffectEvent event = new TerrainEffectEvent(this.theMob, effect.getIdenitifer(), false);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) continue;
                effect.doEffect(this.theMob, false);
            }
        }
    }
}

