/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.world.mobs;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import thut.api.world.World;
import thut.api.world.mobs.Mob;
import thut.api.world.mobs.ai.AI;
import thut.api.world.utils.Info;
import thut.api.world.utils.Vector;
import thut.core.common.world.WorldManager;
import thut.core.common.world.mobs.ai.AI_Impl;
import thut.core.common.world.utils.Info_Impl;
import thut.core.common.world.utils.Vector_D;
import thut.core.common.world.utils.Vector_I;

public class Mob_Impl
implements Mob,
ICapabilityProvider {
    World world;
    Entity entity;
    String key;
    final AI_Impl ai = new AI_Impl();
    final Info_Impl info = new Info_Impl();
    final Vector_I worldPos = new Vector_I();
    final Vector_D position = new Vector_D();
    final Vector_D velocity = new Vector_D();

    @Override
    public AI getAI() {
        return this.ai;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        return this.entity.getCapability(capability, facing);
    }

    @Override
    public float getMaxHealth() {
        float num = 0.0f;
        if (this.entity instanceof MobEntity) {
            num = ((MobEntity)this.entity).func_110138_aP();
        }
        return num;
    }

    @Override
    public UUID id() {
        return this.entity.func_110124_au();
    }

    @Override
    public Info info() {
        return this.info;
    }

    @Override
    public boolean inWorld() {
        return this.entity.field_70175_ag;
    }

    @Override
    public boolean isDead() {
        return !this.entity.func_70089_S();
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public boolean onClient() {
        return this.entity.func_130014_f_().field_72995_K;
    }

    @Override
    public Vector<Double> position() {
        this.position.setValue(0, this.entity.field_70165_t);
        this.position.setValue(1, this.entity.field_70163_u);
        this.position.setValue(2, this.entity.field_70161_v);
        return this.position;
    }

    @Override
    public void setDead() {
        this.entity.func_70106_y();
    }

    public void setEntity(Entity entity) {
        if (this.world != null) {
            this.world.removeMob(this);
        }
        this.entity = entity;
        this.world = WorldManager.instance().getWorld(this.entity.field_71093_bK);
        this.world.addMob(this);
        this.key = entity.func_200600_R().toString();
    }

    @Override
    public void setHealth(float health) {
        if (this.entity instanceof MobEntity) {
            ((MobEntity)this.entity).func_70606_j(health);
        }
    }

    @Override
    public void setID(UUID id) {
        this.entity.func_184221_a(id);
    }

    @Override
    public void setWorld(World world) {
        this.world = world;
    }

    @Override
    public Vector<Double> velocity() {
        Vec3d motion = this.entity.func_213322_ci();
        this.velocity.setValue(0, motion.field_72450_a);
        this.velocity.setValue(1, motion.field_72448_b);
        this.velocity.setValue(2, motion.field_72449_c);
        return this.velocity;
    }

    @Override
    public World world() {
        return this.world;
    }

    @Override
    public Vector<Integer> worldPos() {
        ((Vector_D)this.position()).toInts(this.worldPos);
        return this.worldPos;
    }

    @Override
    public Object wrapped() {
        return this.entity;
    }
}

