/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.world.mobs.data;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import thut.api.world.mobs.data.Data;
import thut.api.world.mobs.data.DataSync;
import thut.core.common.ThutCore;
import thut.core.common.network.Packet;
import thut.core.common.world.mobs.data.DataSync_Impl;
import thut.core.common.world.mobs.data.SyncHandler;

public class PacketDataSync
extends Packet {
    public int id;
    public List<Data<?>> data = Lists.newArrayList();

    public static void sync(Entity tracked, DataSync data, int entity_id, boolean all) {
        List<Data<?>> list;
        List<Data<?>> list2 = list = all ? data.getAll() : data.getDirty();
        if (list == null || tracked == null) {
            return;
        }
        PacketDataSync packet = new PacketDataSync();
        packet.data = list;
        packet.id = entity_id;
        ThutCore.packets.sendToTracking((Packet)packet, tracked);
        if (tracked instanceof ServerPlayerEntity) {
            ThutCore.packets.sendTo(packet, (ServerPlayerEntity)tracked);
        }
    }

    public static void sync(ServerPlayerEntity syncTo, DataSync data, int entity_id, boolean all) {
        List<Data<?>> list;
        List<Data<?>> list2 = list = all ? data.getAll() : data.getDirty();
        if (list == null) {
            return;
        }
        PacketDataSync packet = new PacketDataSync();
        packet.data = list;
        packet.id = entity_id;
        ThutCore.packets.sendTo(packet, syncTo);
    }

    public PacketDataSync() {
        super(null);
    }

    public PacketDataSync(PacketBuffer buf) {
        super(buf);
        this.id = buf.readInt();
        int num = buf.readByte();
        if (num > 0) {
            for (int i = 0; i < num; ++i) {
                int uid = buf.readInt();
                try {
                    Data val = (Data)DataSync_Impl.makeData(uid);
                    val.read((ByteBuf)buf);
                    this.data.add(val);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void handleClient() {
        PlayerEntity player = ThutCore.proxy.getPlayer();
        World world = player.func_130014_f_();
        Entity mob = world.func_73045_a(this.id);
        if (mob == null) {
            return;
        }
        DataSync sync = SyncHandler.getData(mob);
        if (sync == null) {
            return;
        }
        sync.update(this.data);
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeInt(this.id);
        int num = this.data.size();
        buf.writeByte(num);
        for (int i = 0; i < num; ++i) {
            Data<?> val = this.data.get(i);
            buf.writeInt(val.getUID());
            val.write((ByteBuf)buf);
        }
    }
}

