/*
 * Decompiled with CFR 0.152.
 */
package thut.crafts.proxy;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.tuple.Pair;
import thut.api.entity.blockentity.render.RenderBlockEntity;
import thut.api.maths.Vector3;
import thut.crafts.ThutCrafts;
import thut.crafts.client.TestMobRender;
import thut.crafts.entity.CraftController;
import thut.crafts.entity.EntityCraft;
import thut.crafts.entity.EntityTest;
import thut.crafts.network.PacketCraftControl;
import thut.crafts.proxy.CommonProxy;

public class ClientProxy
extends CommonProxy {
    KeyBinding UP;
    KeyBinding DOWN;
    KeyBinding ROTATERIGHT;
    KeyBinding ROTATELEFT;

    @SubscribeEvent
    public void move(InputUpdateEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void clientTick(TickEvent.PlayerTickEvent event) {
        Entity e;
        if (event.phase == TickEvent.Phase.START || event.player != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        if (event.player.func_184218_aH() && Minecraft.func_71410_x().field_71462_r == null && (e = event.player.func_184187_bx()) instanceof EntityCraft) {
            ClientPlayerEntity player = (ClientPlayerEntity)event.player;
            CraftController controller = ((EntityCraft)e).controller;
            if (controller != null) {
                controller.backInputDown = player.field_71158_b.field_187256_d;
                controller.forwardInputDown = player.field_71158_b.field_187255_c;
                controller.leftInputDown = player.field_71158_b.field_187257_e;
                controller.rightInputDown = player.field_71158_b.field_187258_f;
                controller.upInputDown = this.UP.func_151470_d();
                controller.downInputDown = this.DOWN.func_151470_d();
                if (ThutCrafts.conf.canRotate) {
                    controller.rightRotateDown = this.ROTATERIGHT.func_151470_d();
                    controller.leftRotateDown = this.ROTATELEFT.func_151470_d();
                }
                PacketCraftControl.sendControlPacket(e, controller);
            }
        }
    }

    @Override
    public PlayerEntity getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void RenderBounds(RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ItemStack held = player.func_184614_ca();
        if (!held.func_190926_b() || !(held = player.func_184592_cb()).func_190926_b()) {
            if (held.func_77973_b() != ThutCrafts.CRAFTMAKER) {
                return;
            }
            if (held.func_77978_p() != null && held.func_77978_p().func_74764_b("min")) {
                Minecraft mc = Minecraft.func_71410_x();
                Vec3d projectedView = mc.field_71460_t.func_215316_n().func_216785_c();
                Vec3d pointed = new Vec3d(projectedView.field_72450_a, projectedView.field_72448_b, projectedView.field_72449_c).func_178787_e(mc.field_71439_g.func_70676_i(event.getPartialTicks()));
                if (mc.field_71476_x != null && mc.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    BlockRayTraceResult result = (BlockRayTraceResult)mc.field_71476_x;
                    pointed = new Vec3d((Vec3i)result.func_216350_a());
                }
                Vector3 v = Vector3.readFromNBT(held.func_77978_p().func_74775_l("min"), "");
                AxisAlignedBB one = new AxisAlignedBB(v.getPos());
                AxisAlignedBB two = new AxisAlignedBB(new BlockPos(pointed));
                double minX = Math.min(one.field_72340_a, two.field_72340_a);
                double minY = Math.min(one.field_72338_b, two.field_72338_b);
                double minZ = Math.min(one.field_72339_c, two.field_72339_c);
                double maxX = Math.max(one.field_72336_d, two.field_72336_d);
                double maxY = Math.max(one.field_72337_e, two.field_72337_e);
                double maxZ = Math.max(one.field_72334_f, two.field_72334_f);
                MatrixStack mat = event.getMatrixStack();
                mat.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
                ArrayList lines = Lists.newArrayList();
                lines.add(Pair.of((Object)new Vector3f((float)minX, (float)minY, (float)minZ), (Object)new Vector3f((float)maxX, (float)minY, (float)minZ)));
                lines.add(Pair.of((Object)new Vector3f((float)minX, (float)maxY, (float)minZ), (Object)new Vector3f((float)maxX, (float)maxY, (float)minZ)));
                lines.add(Pair.of((Object)new Vector3f((float)minX, (float)minY, (float)maxZ), (Object)new Vector3f((float)maxX, (float)minY, (float)maxZ)));
                lines.add(Pair.of((Object)new Vector3f((float)minX, (float)maxY, (float)maxZ), (Object)new Vector3f((float)maxX, (float)maxY, (float)maxZ)));
                lines.add(Pair.of((Object)new Vector3f((float)minX, (float)minY, (float)minZ), (Object)new Vector3f((float)minX, (float)minY, (float)maxZ)));
                lines.add(Pair.of((Object)new Vector3f((float)maxX, (float)minY, (float)minZ), (Object)new Vector3f((float)maxX, (float)minY, (float)maxZ)));
                lines.add(Pair.of((Object)new Vector3f((float)minX, (float)maxY, (float)minZ), (Object)new Vector3f((float)minX, (float)maxY, (float)maxZ)));
                lines.add(Pair.of((Object)new Vector3f((float)maxX, (float)maxY, (float)minZ), (Object)new Vector3f((float)maxX, (float)maxY, (float)maxZ)));
                lines.add(Pair.of((Object)new Vector3f((float)minX, (float)minY, (float)minZ), (Object)new Vector3f((float)minX, (float)maxY, (float)minZ)));
                lines.add(Pair.of((Object)new Vector3f((float)maxX, (float)minY, (float)minZ), (Object)new Vector3f((float)maxX, (float)maxY, (float)minZ)));
                lines.add(Pair.of((Object)new Vector3f((float)minX, (float)minY, (float)maxZ), (Object)new Vector3f((float)minX, (float)maxY, (float)maxZ)));
                lines.add(Pair.of((Object)new Vector3f((float)maxX, (float)minY, (float)maxZ), (Object)new Vector3f((float)maxX, (float)maxY, (float)maxZ)));
                mat.func_227860_a_();
                Matrix4f positionMatrix = mat.func_227866_c_().func_227870_a_();
                IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
                IVertexBuilder builder = buffer.getBuffer((RenderType)RenderType.field_228614_Q_);
                for (Pair line : lines) {
                    thut.core.proxy.ClientProxy.line(builder, positionMatrix, (Vector3f)line.getLeft(), (Vector3f)line.getRight(), 1.0f, 0.0f, 0.0f, 1.0f);
                }
                mat.func_227865_b_();
            }
        }
    }

    @Override
    public void setup(FMLCommonSetupEvent event) {
        super.setup(event);
    }

    @Override
    public void setupClient(FMLClientSetupEvent event) {
        this.UP = new KeyBinding("crafts.key.up", 32, "keys.crafts");
        this.DOWN = new KeyBinding("crafts.key.down", 341, "keys.crafts");
        KeyConflictContext inGame = KeyConflictContext.IN_GAME;
        this.UP.setKeyConflictContext((IKeyConflictContext)inGame);
        this.DOWN.setKeyConflictContext((IKeyConflictContext)inGame);
        this.ROTATERIGHT = new KeyBinding("crafts.key.left", 93, "keys.crafts");
        this.ROTATELEFT = new KeyBinding("crafts.key.right", 91, "keys.crafts");
        this.ROTATELEFT.setKeyConflictContext((IKeyConflictContext)inGame);
        this.ROTATERIGHT.setKeyConflictContext((IKeyConflictContext)inGame);
        ClientRegistry.registerKeyBinding((KeyBinding)this.UP);
        ClientRegistry.registerKeyBinding((KeyBinding)this.DOWN);
        ClientRegistry.registerKeyBinding((KeyBinding)this.ROTATELEFT);
        ClientRegistry.registerKeyBinding((KeyBinding)this.ROTATERIGHT);
        RenderingRegistry.registerEntityRenderingHandler(EntityCraft.CRAFTTYPE, RenderBlockEntity::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTest.TYPE, TestMobRender::new);
    }
}

