/*
 * Decompiled with CFR 0.152.
 */
package thut.lib;

import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ItemStackTools {
    public static boolean addItemStackToInventory(ItemStack itemStackIn, IInventory toAddTo, int minIndex) {
        return ItemStackTools.addItemStackToInventory(itemStackIn, (IItemHandlerModifiable)new InvWrapper(toAddTo), minIndex);
    }

    public static boolean addItemStackToInventory(ItemStack itemStackIn, IItemHandlerModifiable toAddTo, int minIndex) {
        if (!itemStackIn.func_190926_b()) {
            try {
                int i;
                int num;
                if (itemStackIn.func_77951_h()) {
                    int j = ItemStackTools.getFirstEmptyStack(toAddTo, minIndex);
                    if (j >= 0) {
                        toAddTo.setStackInSlot(j, itemStackIn.func_77946_l());
                        toAddTo.getStackInSlot(j).func_190915_d(5);
                        itemStackIn.func_190920_e(0);
                        return true;
                    }
                    return false;
                }
                do {
                    i = itemStackIn.func_190916_E();
                    num = ItemStackTools.storePartialItemStack(itemStackIn, toAddTo, minIndex);
                    itemStackIn.func_190920_e(num);
                } while (num > 0 && num < i);
                return itemStackIn.func_190916_E() < i;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Adding item to inventory");
                crashreport.func_85058_a("Item being added");
                throw new ReportedException(crashreport);
            }
        }
        return false;
    }

    private static boolean canMergeStacks(ItemStack stack1, ItemStack stack2) {
        return !stack1.func_190926_b() && ItemStackTools.stackEqualExact(stack1, stack2) && stack1.func_77985_e() && stack1.func_190916_E() < stack1.func_77976_d();
    }

    public static int getFirstEmptyStack(IInventory inventory, int minIndex) {
        return ItemStackTools.getFirstEmptyStack((IItemHandlerModifiable)new InvWrapper(inventory), minIndex);
    }

    public static int getFirstEmptyStack(IItemHandlerModifiable inventory, int minIndex) {
        for (int i = minIndex; i < inventory.getSlots(); ++i) {
            if (!inventory.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    private static boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    private static int storeItemStack(ItemStack itemStackIn, IItemHandlerModifiable inventory, int minIndex) {
        for (int i = minIndex; i < inventory.getSlots(); ++i) {
            if (!ItemStackTools.canMergeStacks(inventory.getStackInSlot(i), itemStackIn)) continue;
            return i;
        }
        return -1;
    }

    private static int storePartialItemStack(ItemStack itemStackIn, IItemHandlerModifiable inventory, int minIndex) {
        int i = itemStackIn.func_190916_E();
        int j = ItemStackTools.storeItemStack(itemStackIn, inventory, minIndex);
        if (j < 0) {
            j = ItemStackTools.getFirstEmptyStack(inventory, minIndex);
        }
        if (j < 0) {
            return i;
        }
        ItemStack itemstack = inventory.getStackInSlot(j);
        if (itemstack.func_190926_b()) {
            itemstack = itemStackIn.func_77946_l();
            itemstack.func_190920_e(0);
            if (itemStackIn.func_77942_o()) {
                itemstack.func_77982_d(itemStackIn.func_77978_p().func_74737_b());
            }
            inventory.setStackInSlot(j, itemstack);
        }
        int k = i;
        int size = inventory.getStackInSlot(j).func_190916_E();
        if (i > inventory.getStackInSlot(j).func_77976_d() - size) {
            k = inventory.getStackInSlot(j).func_77976_d() - size;
        }
        if (k > inventory.getSlotLimit(j) - size) {
            k = inventory.getSlotLimit(j) - size;
        }
        if (k == 0) {
            return i;
        }
        inventory.getStackInSlot(j).func_190920_e(size + k);
        inventory.getStackInSlot(j).func_190915_d(5);
        return i -= k;
    }
}

