/*
 * Decompiled with CFR 0.152.
 */
package thut.api.boom;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import thut.api.boom.ExplosionCustom;
import thut.api.maths.Vector3;
import thut.api.maths.vecmath.Vector3f;
import thut.core.common.ThutCore;

public class Checker {
    final ExplosionCustom boom;
    final Vector3f unit = new Vector3f();

    public Checker(ExplosionCustom boom) {
        this.boom = boom;
    }

    private boolean outOfBounds(Vector3f unit) {
        if (unit.x < this.boom.min.x) {
            return true;
        }
        if (unit.y < this.boom.min.y) {
            return true;
        }
        if (unit.z < this.boom.min.z) {
            return true;
        }
        if (unit.x > this.boom.max.x) {
            return true;
        }
        if (unit.y > this.boom.max.y) {
            return true;
        }
        return unit.z > this.boom.max.z;
    }

    private void validateMinMax(float r) {
        if (r - this.boom.lastBoundCheck > 5.0f) {
            this.boom.min.set(this.boom.min_next);
            this.boom.max.set(this.boom.max_next);
            float s = 1.0f;
            this.boom.min.scale(1.0f);
            this.boom.max.scale(1.0f);
            this.boom.min_next.set(1.0f, 1.0f, 1.0f);
            this.boom.max_next.set(-1.0f, -1.0f, -1.0f);
            this.boom.lastBoundCheck = r;
            ThutCore.LOGGER.debug("Strength: {}, Max radius: {}, Last Radius: {}", (Object)Float.valueOf(this.boom.strength), (Object)this.boom.radius, (Object)((int)r));
            this.boom.shadow.clean(this.boom);
        } else {
            this.boom.min_next.x = Math.min(this.boom.min_next.x, this.unit.x);
            this.boom.min_next.y = Math.min(this.boom.min_next.y, this.unit.y);
            this.boom.min_next.z = Math.min(this.boom.min_next.z, this.unit.z);
            this.boom.max_next.x = Math.max(this.boom.max_next.x, this.unit.x);
            this.boom.max_next.y = Math.max(this.boom.max_next.y, this.unit.y);
            this.boom.max_next.z = Math.max(this.boom.max_next.z, this.unit.z);
        }
    }

    private boolean run(double radSq, int num, Set<ChunkPos> seen, Object2FloatOpenHashMap<BlockPos> ret, List<ExplosionCustom.HitEntity> entityAffected) {
        boolean doAirCheck;
        if (this.boom.r.y + this.boom.centre.y > (double)this.boom.field_77287_j.func_217301_I()) {
            return false;
        }
        double rSq = this.boom.r.magSq();
        if (rSq > radSq) {
            return false;
        }
        double rMag = Math.sqrt(rSq);
        this.boom.rAbs.set(this.boom.r).addTo(this.boom.centre);
        this.boom.rHat.set(this.boom.r).norm();
        BlockPos relPos = this.boom.r.getPos();
        this.unit.set(this.boom.rHat);
        if (this.outOfBounds(this.unit)) {
            return false;
        }
        double str = (double)this.boom.strength / rSq;
        if (str <= (double)this.boom.minBlastDamage) {
            return true;
        }
        if (this.boom.shadow.hasHit(relPos)) {
            return false;
        }
        this.boom.shadow.hit(relPos);
        ++this.boom.ind4;
        if (this.boom.shadow.blocked(relPos, this.boom.rHat)) {
            ++this.boom.ind1;
            return false;
        }
        ChunkPos cpos = new ChunkPos(this.boom.rAbs.getPos());
        if (!seen.contains(cpos) && seen.add(cpos)) {
            this.boom.field_77287_j.func_212866_a_(cpos.field_77276_a, cpos.field_77275_b);
        }
        boolean bl = doAirCheck = this.boom.rHat.y < (double)this.boom.max.y * 0.9 && this.boom.rHat.y > (double)this.boom.min.y * 0.9;
        if (doAirCheck && this.boom.rAbs.isAir((IBlockReader)this.boom.field_77287_j) && !this.boom.r.isEmpty()) {
            float res;
            List hits;
            if (ExplosionCustom.AFFECTINAIR && (hits = this.boom.field_77287_j.func_72839_b(this.boom.field_77283_e, this.boom.rAbs.getAABB().func_72314_b(0.5, 0.5, 0.5))) != null && !hits.isEmpty() && (double)(res = this.boom.resists.getTotalValue(this.boom.rHat, (float)(rMag = this.boom.r.mag()), 0, this.boom)) <= str) {
                for (Entity e : hits) {
                    entityAffected.add(new ExplosionCustom.HitEntity(e, (float)str));
                }
            }
            this.validateMinMax((float)rMag);
            return false;
        }
        if (!this.boom.canBreak(this.boom.rAbs, this.boom.rAbs.getBlockState((IBlockReader)this.boom.field_77287_j))) {
            this.boom.shadow.block(relPos, this.boom.rHat);
            ++this.boom.ind2;
            return false;
        }
        float res = this.boom.resistProvider.getResistance(this.boom.rAbs.getPos(), this.boom);
        this.boom.resists.set(relPos, res);
        rMag = this.boom.r.mag();
        res = this.boom.resists.getTotalValue(this.boom.rHat, (float)rMag, 0, this.boom);
        if ((double)res > str) {
            this.boom.shadow.block(relPos, this.boom.rHat);
            return false;
        }
        this.validateMinMax((float)rMag);
        this.boom.rAbs.set(this.boom.r).addTo(this.boom.centre);
        BlockPos pos = this.boom.rAbs.getPos().func_185334_h();
        this.boom.func_180343_e().add(pos);
        List hits = this.boom.field_77287_j.func_72839_b(this.boom.field_77283_e, this.boom.rAbs.getAABB().func_72314_b(0.5, 0.5, 0.5));
        if (hits != null) {
            for (Entity e : hits) {
                entityAffected.add(new ExplosionCustom.HitEntity(e, (float)str));
            }
        }
        ret.addTo((Object)pos, (float)str);
        return false;
    }

    protected ExplosionCustom.BlastResult getBlocksToRemove() {
        int threshold = this.boom.maxPerTick;
        int num = (int)Math.sqrt((double)this.boom.strength / 0.5);
        int max = this.boom.radius * 2 + 1;
        num = Math.min(num, max);
        int numCubed = num * num * num;
        double radSq = num * num / 4;
        int increment = 0;
        Object2FloatOpenHashMap ret = new Object2FloatOpenHashMap();
        ArrayList entityAffected = Lists.newArrayList();
        HashSet<ChunkPos> seen = new HashSet<ChunkPos>();
        boolean done = true;
        boolean sphere = true;
        long start = System.currentTimeMillis();
        long nanoS = System.nanoTime();
        double radius = this.boom.last_rad;
        double C = 4.0;
        double area = Math.PI * 4 * radius * radius;
        float grid = 0.5f;
        float N = (float)Math.ceil(area / 0.5);
        block0: while (System.currentTimeMillis() - start < (long)threshold && radius < (double)this.boom.radius) {
            double phi_k_1 = this.boom.last_phi;
            if (this.boom.currentIndex < 1) {
                this.boom.currentIndex = 1;
            }
            int k_end = this.yToKMax(this.boom.max.y, N);
            float sqrtN = (float)Math.sqrt(N);
            for (int k = this.boom.currentIndex; k <= k_end; ++k) {
                this.boom.currentIndex = k;
                if (System.currentTimeMillis() - start > (long)threshold) {
                    done = false;
                    break block0;
                }
                float h_k = -this.kToY(k, N);
                float sin_theta = (float)Math.sqrt(1.0f - h_k * h_k);
                float phi_k = (float)(k > 1 && (float)k < N ? (phi_k_1 + 4.0 / (double)(sqrtN * sin_theta)) % (Math.PI * 2) : 0.0);
                this.boom.last_phi = phi_k_1 = (double)phi_k;
                double x = (double)(sin_theta * MathHelper.func_76134_b((float)phi_k)) * radius;
                double y = (double)h_k * radius;
                double z = (double)(sin_theta * MathHelper.func_76126_a((float)phi_k)) * radius;
                this.boom.rTest.set(x, y, z);
                this.boom.r.set(this.boom.rTest.intX(), this.boom.rTest.intY(), this.boom.rTest.intZ());
                done = this.run(radSq, num, seen, (Object2FloatOpenHashMap<BlockPos>)ret, entityAffected);
                if (done) break block0;
            }
            int k_start = this.yToKMin(this.boom.min.y, N);
            this.boom.currentIndex = 1;
            this.boom.last_phi = 0.0;
            area = Math.PI * 4 * (radius += 0.5) * radius;
            N = (float)Math.ceil(area / 0.5);
            this.boom.currentIndex = k_start = this.yToKMin(this.boom.min.y, N);
            this.boom.currentRadius = MathHelper.func_76143_f((double)radius);
        }
        this.boom.last_rad = radius;
        this.boom.totalTime += System.nanoTime() - nanoS;
        this.boom.nextIndex = this.boom.currentIndex + increment;
        return new ExplosionCustom.BlastResult((Object2FloatOpenHashMap<BlockPos>)ret, entityAffected, done);
    }

    float kToY(int k, float N) {
        return -1.0f + (float)(2 * (k - 1)) / (N - 1.0f);
    }

    int yToKMin(float y, float N) {
        int k = (int)(1.0f + (y + 1.0f) * (N - 1.0f) / 2.0f);
        k = Math.max(1, k);
        return k;
    }

    int yToKMax(float y, float N) {
        int k = MathHelper.func_76123_f((float)(1.0f + (y + 1.0f) * (N - 1.0f) / 2.0f));
        k = (int)Math.min(N, (float)k);
        return k;
    }

    public static class Cube
    implements ResistCache {
        final Long2FloatOpenHashMap resistMap = new Long2FloatOpenHashMap(1024, 0.75f);
        int radius = 1;
        boolean had = false;

        public boolean isOn(BlockPos r) {
            boolean zFace;
            boolean yFace;
            boolean xFace;
            int z;
            int y;
            int x = Math.abs(r.func_177958_n());
            int max = Math.max(x, Math.max(y = Math.abs(r.func_177956_o()), z = Math.abs(r.func_177952_p())));
            if (max != this.radius) {
                return false;
            }
            boolean bl = xFace = x == this.radius && y <= this.radius && z <= this.radius;
            if (xFace) {
                return true;
            }
            boolean bl2 = yFace = y == this.radius && x <= this.radius && z <= this.radius;
            if (yFace) {
                return true;
            }
            boolean bl3 = zFace = z == this.radius && y <= this.radius && x <= this.radius;
            return zFace;
        }

        @Override
        public float get(BlockPos r) {
            if (!this.isOn(r)) {
                System.out.println("wrong cube? " + r + " " + this.radius);
                return 0.0f;
            }
            this.had = false;
            float res = this.resistMap.getOrDefault(r.func_218275_a(), -1.0f);
            boolean bl = this.had = res != -1.0f;
            if (!this.had) {
                res = 0.0f;
            }
            return res;
        }

        @Override
        public void set(BlockPos r, float v) {
            if (!this.isOn(r)) {
                System.out.println("wrong cube? " + r + " " + this.radius);
                return;
            }
            this.resistMap.put(r.func_218275_a(), v);
        }

        @Override
        public boolean has(BlockPos pos) {
            return this.resistMap.containsKey(pos.func_218275_a());
        }
    }

    public static class Cubes
    implements ResistCache {
        final Int2ObjectOpenHashMap<Cube> cubes;
        int minCube = Integer.MAX_VALUE;
        int minFound = -1;
        Vector3 tmp = Vector3.getNewVector();

        public Cubes(ExplosionCustom boom) {
            this.cubes = new Int2ObjectOpenHashMap(boom.radius, 0.25f);
        }

        Cube getCube(BlockPos r) {
            int z;
            int y;
            int x = Math.abs(r.func_177958_n());
            int max = Math.max(x, Math.max(y = Math.abs(r.func_177956_o()), z = Math.abs(r.func_177952_p())));
            if (!this.cubes.containsKey(max)) {
                Cube c = new Cube();
                c.radius = max;
                this.cubes.put(max, (Object)c);
                return c;
            }
            this.minFound = this.minFound == -1 ? max : Math.min(max, this.minFound);
            this.minCube = Math.min(max, this.minCube);
            return (Cube)this.cubes.get(max);
        }

        BlockPos getPrevPos(Vector3 r, Vector3 rHat) {
            this.tmp.set(r).addTo(0.5, 0.5, 0.5).subtractFrom(rHat);
            return this.tmp.getPos().func_185334_h();
        }

        Cube getPrev(Vector3 r, Vector3 rHat) {
            if (r.magSq() <= 1.0) {
                return null;
            }
            return this.getCube(this.getPrevPos(r, rHat));
        }

        @Override
        public float getTotalValue(Vector3 rHat, float r, int minCube, ExplosionCustom boom) {
            return ResistCache.super.getTotalValue(rHat, r, minCube, boom);
        }

        void removeLess() {
            while (this.minFound > this.minCube) {
                this.cubes.remove(this.minCube);
                ++this.minCube;
            }
            this.minFound = -1;
            this.minCube = Integer.MAX_VALUE;
        }

        @Override
        public final float get(BlockPos pos) {
            Cube c = this.getCube(pos);
            return c.get(pos);
        }

        @Override
        public final void set(BlockPos pos, float var) {
            this.getCube(pos).set(pos, var);
        }

        @Override
        public final boolean has(BlockPos pos) {
            return this.getCube(pos).has(pos);
        }

        @Override
        public void clean(ExplosionCustom boom) {
            this.removeLess();
        }
    }

    public static class ShadowSet
    implements ShadowMap {
        LongSet blockedSet = new LongOpenHashSet();
        final Cubes hitTracker;
        final float num;
        Vector3 tmp = Vector3.getNewVector();

        public ShadowSet(ExplosionCustom boom) {
            float scaleFactor = 10.0f;
            int num = (int)Math.sqrt((double)(boom.strength * 10.0f) / 0.5);
            int max = boom.radius * 2 + 1;
            this.num = (float)Math.min(num, max) / 2.0f;
            this.hitTracker = new Cubes(boom);
        }

        @Override
        public final boolean blocked(BlockPos pos, Vector3 dir) {
            this.tmp.set(dir).scalarMultBy(this.num);
            long key = this.tmp.getPos().func_218275_a();
            return this.blockedSet.contains(key);
        }

        @Override
        public final void block(BlockPos pos, Vector3 dir) {
            this.tmp.set(dir).scalarMultBy(this.num);
            long key = this.tmp.getPos().func_218275_a();
            this.blockedSet.add(key);
        }

        @Override
        public final boolean hasHit(BlockPos pos) {
            return this.hitTracker.has(pos);
        }

        @Override
        public final void hit(BlockPos pos) {
            this.hitTracker.set(pos, 1.0f);
        }

        @Override
        public void clean(ExplosionCustom boom) {
            this.hitTracker.clean(boom);
        }
    }

    public static class ResistMap
    implements ResistCache {
        Long2FloatOpenHashMap resists = new Long2FloatOpenHashMap();

        @Override
        public float get(BlockPos pos) {
            return this.resists.getOrDefault(pos.func_218275_a(), 0.0f);
        }

        @Override
        public void set(BlockPos pos, float var) {
            this.resists.put(pos.func_218275_a(), var);
        }

        @Override
        public boolean has(BlockPos pos) {
            return this.resists.containsKey(pos.func_218275_a());
        }
    }

    public static interface ShadowMap {
        public boolean blocked(BlockPos var1, Vector3 var2);

        public void block(BlockPos var1, Vector3 var2);

        public boolean hasHit(BlockPos var1);

        public void hit(BlockPos var1);

        default public void clean(ExplosionCustom boom) {
        }
    }

    public static interface ResistCache {
        public float get(BlockPos var1);

        public void set(BlockPos var1, float var2);

        public boolean has(BlockPos var1);

        default public void clean(ExplosionCustom boom) {
        }

        default public float getTotalValue(Vector3 rHat, float r, int minCube, ExplosionCustom boom) {
            float resist = 0.0f;
            for (float j = 0.0f; j <= r; j += 1.0f) {
                boom.rTest.set(boom.rHat).scalarMultBy(j);
                if (!boom.rTest.sameBlock(boom.rTestPrev)) {
                    float res;
                    boom.rTestAbs.set(boom.rTest).addTo(boom.centre);
                    BlockPos testPos = boom.rTest.getPos();
                    if (this.has(testPos)) {
                        res = this.get(testPos);
                    } else {
                        ChunkPos cpos = new ChunkPos(boom.rTestAbs.getPos());
                        boom.field_77287_j.func_212866_a_(cpos.field_77276_a, cpos.field_77275_b);
                        res = boom.resistProvider.getResistance(boom.rTestAbs.getPos(), boom);
                        this.set(testPos, res);
                    }
                    resist += res;
                    float str = (float)((double)boom.strength / boom.rTest.magSq());
                    if (resist > str) {
                        boom.shadow.block(boom.r.getPos(), boom.rHat);
                        ++boom.ind3;
                        return boom.strength;
                    }
                }
                boom.rTestPrev.set(boom.rTest);
            }
            return 0.0f;
        }
    }

    public static interface ResistProvider {
        default public float getResistance(BlockPos pos, ExplosionCustom boom) {
            BlockState state = boom.field_77287_j.func_180495_p(pos);
            float resist = state.getExplosionResistance((IBlockReader)boom.field_77287_j, pos, (Explosion)boom);
            if (state.func_177230_c() == Blocks.field_196658_i) {
                resist /= 2.0f;
            }
            if (state.func_177230_c() instanceof LeavesBlock) {
                resist /= 10.0f;
            }
            if (resist > 1.0f) {
                resist *= resist;
            }
            return resist;
        }
    }
}

