/*
 * Decompiled with CFR 0.152.
 */
package thut.api.boom;

import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.boom.Checker;
import thut.api.maths.Vector3;
import thut.api.maths.vecmath.Vector3f;
import thut.api.terrain.TerrainManager;
import thut.core.common.ThutCore;

public class ExplosionCustom
extends Explosion {
    public static int MAX_RADIUS = 127;
    public static int MAXPERTICK = 25;
    public static float MINBLASTDAMAGE = 0.1f;
    public static boolean AFFECTINAIR = true;
    public static Block melt;
    public static Block solidmelt;
    public static Block dust;
    public IEntityHitter hitter = (e, power, boom) -> {
        EntitySize size = e.func_213305_a(e.func_213283_Z());
        float area = size.field_220315_a * size.field_220316_b;
        float damage = area * power;
        e.func_70097_a(DamageSource.func_94539_a((Explosion)boom), damage);
    };
    int currentIndex = 0;
    int nextIndex = 0;
    double last_phi = 0.0;
    double last_rad = 0.25;
    int ind1;
    int ind2;
    int ind3;
    int ind4;
    float minBlastDamage;
    int radius = MAX_RADIUS;
    int currentRadius = 0;
    public int maxPerTick;
    public World field_77287_j;
    Vector3 centre;
    final float strength;
    public BlockBreaker breaker = new BlockBreaker(){};
    public Checker.ResistProvider resistProvider = new Checker.ResistProvider(){};
    public PlayerEntity owner = null;
    List<Entity> targets = new ArrayList<Entity>();
    private final double explosionX;
    private final double explosionY;
    private final double explosionZ;
    public long totalTime = 0L;
    public long realTotalTime = 0L;
    Entity field_77283_e;
    Vector3f min = new Vector3f(-1.0f, -1.0f, -1.0f);
    Vector3f max = new Vector3f(1.0f, 1.0f, 1.0f);
    Vector3f min_next = new Vector3f(1.0f, 1.0f, 1.0f);
    Vector3f max_next = new Vector3f(-1.0f, -1.0f, -1.0f);
    float lastBoundCheck = 10.0f;
    Long2FloatOpenHashMap resistMap = new Long2FloatOpenHashMap();
    LongSet blockedSet = new LongOpenHashSet();
    Checker.ShadowMap shadow;
    Checker.ResistCache resists;
    LongSet checked = new LongOpenHashSet();
    LongSet seen = new LongOpenHashSet();
    Checker.Cubes cubes;
    Vector3 r = Vector3.getNewVector();
    Vector3 rAbs = Vector3.getNewVector();
    Vector3 rHat = Vector3.getNewVector();
    Vector3 rTest = Vector3.getNewVector();
    Vector3 rTestPrev = Vector3.getNewVector();
    Vector3 rTestAbs = Vector3.getNewVector();

    public ExplosionCustom(World world, Entity par2Entity, double x, double y, double z, float power) {
        this(world, par2Entity, Vector3.getNewVector().set(x, y, z), power);
    }

    public ExplosionCustom(World world, Entity par2Entity, Vector3 center, float power2) {
        super(world, par2Entity, center.x, center.y, center.z, power2, false, Explosion.Mode.DESTROY);
        this.field_77287_j = world;
        this.field_77283_e = par2Entity;
        this.explosionX = center.x;
        this.explosionY = center.y;
        this.explosionZ = center.z;
        this.centre = center.copy();
        this.minBlastDamage = MINBLASTDAMAGE;
        this.maxPerTick = MAXPERTICK;
        double scaleFactor = 150.0;
        this.strength = (float)(150.0 * (double)power2);
        this.cubes = new Checker.Cubes(this);
        this.shadow = new Checker.ShadowSet(this);
        this.resists = new Checker.ResistMap();
        this.resists = this.cubes;
        this.lastBoundCheck = center.intY() - world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, center.intX(), center.intZ()) + 10;
        this.lastBoundCheck = Math.max(this.lastBoundCheck, 10.0f);
    }

    private void applyBlockEffects(BlastResult result) {
        this.func_180343_e().clear();
        this.breaker.breakBlocks(result, this);
    }

    private void applyEntityEffects(BlastResult result) {
        this.targets.clear();
        for (HitEntity e : result.hit) {
            Entity hit = e.entity;
            float power = e.blastStrength;
            if (!(power > 0.0f)) continue;
            this.hitter.hitEntity(hit, power, this);
            this.targets.add(hit);
        }
    }

    public boolean canBreak(Vector3 location, BlockState state) {
        boolean ret;
        boolean bl = ret = state.func_177230_c() != Blocks.field_150357_h;
        if (this.owner != null) {
            try {
                BlockEvent.BreakEvent evt = new BlockEvent.BreakEvent(this.field_77287_j, location.getPos(), state, this.owner);
                MinecraftForge.EVENT_BUS.post((Event)evt);
                if (evt.isCanceled()) {
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return ret;
    }

    public void doExplosion() {
        this.field_77287_j.func_184148_a((PlayerEntity)null, this.explosionX, this.explosionY, this.explosionZ, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        this.field_77287_j.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.realTotalTime = System.nanoTime();
    }

    public void func_77278_a() {
        ThutCore.LOGGER.error("This should not be run anymore", (Throwable)new Exception());
    }

    public void func_77279_a(boolean par1) {
        ThutCore.LOGGER.error("This should not be run anymore", (Throwable)new Exception());
    }

    public void doKineticImpactor(World world, Vector3 velocity, Vector3 hitLocation, Vector3 acceleration, float density, float energy) {
        if (density < 0.0f || energy <= 0.0f) {
            return;
        }
        int max = 63;
        if (acceleration == null) {
            acceleration = Vector3.empty;
        }
        float factor = 1.0f;
        int n = 0;
        ArrayList<Vector3> locations = new ArrayList<Vector3>();
        ArrayList<Float> blasts = new ArrayList<Float>();
        float resist = hitLocation.getExplosionResistance(this, (IWorldReader)world);
        float blast = Math.min(energy * (resist / density), energy);
        if (resist > density) {
            hitLocation = hitLocation.subtract(velocity.normalize());
            ExplosionCustom boo = new ExplosionCustom(world, this.field_77283_e, hitLocation, blast * 1.0f);
            boo.setMaxRadius(this.radius);
            boo.owner = this.owner;
            boo.doExplosion();
            return;
        }
        Vector3 absorbedLoc = Vector3.getNewVector();
        float remainingEnergy = 0.0f;
        density -= resist;
        while (energy > 0.0f && density > 0.0f) {
            locations.add(hitLocation.subtract(velocity.normalize()));
            blasts.add(Float.valueOf(blast));
            hitLocation = hitLocation.add(velocity.normalize());
            velocity.add(acceleration);
            resist = Math.max(hitLocation.getExplosionResistance(this, (IWorldReader)world), 0.0f);
            blast = Math.min(energy * (resist / density), energy);
            if (resist > density) {
                absorbedLoc.set(hitLocation);
                remainingEnergy = energy;
                break;
            }
            energy -= energy * (resist / density);
            density = (float)((double)density - ((double)resist + 0.1));
        }
        if ((n = locations.size()) != 0) {
            for (int i = 0; i < n; ++i) {
                Vector3 source = (Vector3)locations.get(i);
                float strength = Math.min(((Float)blasts.get(i)).floatValue(), 256.0f);
                if (!TerrainManager.isAreaLoaded((IWorld)world, source.getPos(), 63.0) || strength == 0.0f) continue;
                ExplosionCustom boo = new ExplosionCustom(world, this.field_77283_e, source, strength * 1.0f);
                boo.setMaxRadius(this.radius);
                boo.owner = this.owner;
                boo.doExplosion();
            }
        }
        if (remainingEnergy > 10.0f) {
            absorbedLoc = absorbedLoc.subtract(velocity.normalize());
            ExplosionCustom boo = new ExplosionCustom(world, this.field_77283_e, absorbedLoc, remainingEnergy * 1.0f);
            boo.setMaxRadius(this.radius);
            boo.owner = this.owner;
            boo.doExplosion();
        }
    }

    @SubscribeEvent
    public void doRemoveBlocks(TickEvent.WorldTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START || evt.world != this.field_77287_j) {
            return;
        }
        this.func_180342_d();
        BlastResult result = new Checker(this).getBlocksToRemove();
        this.applyBlockEffects(result);
        this.applyEntityEffects(result);
        ExplosionEvent.Detonate evt2 = new ExplosionEvent.Detonate(this.field_77287_j, (Explosion)this, this.targets);
        MinecraftForge.EVENT_BUS.post((Event)evt2);
        if (result.done) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.realTotalTime = System.nanoTime() - this.realTotalTime;
            ThutCore.LOGGER.info("Strength: {}, Max radius: {}, Last Radius: {}", (Object)Float.valueOf(this.strength), (Object)this.radius, (Object)this.r.mag());
            ThutCore.LOGGER.info("time (tick/real): {}/{}ms, {} shadowed, {} denied, {} blocked, {} checked", (Object)((double)this.totalTime / 1000000.0), (Object)((double)this.realTotalTime / 1000000.0), (Object)this.ind1, (Object)this.ind2, (Object)this.ind3, (Object)this.ind4);
            ThutCore.LOGGER.info("bounds: {} {}", (Object)this.min, (Object)this.max);
        }
    }

    public ExplosionCustom setMaxRadius(int radius) {
        this.radius = radius;
        return this;
    }

    @SubscribeEvent
    public void WorldUnloadEvent(WorldEvent.Unload evt) {
        if (evt.getWorld() == this.field_77287_j) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    public static interface BlockBreaker {
        default public void breakBlocks(BlastResult result, ExplosionCustom boom) {
            for (Object2FloatMap.Entry pos : result.results.object2FloatEntrySet()) {
                boom.func_180343_e().add(pos.getKey());
                BlockState destroyed = boom.field_77287_j.func_180495_p((BlockPos)pos.getKey());
                float power = pos.getFloatValue();
                BlockState to = Blocks.field_150350_a.func_176223_P();
                if (power < 36.0f) {
                    if (destroyed.func_185904_a() == Material.field_151584_j) {
                        to = Blocks.field_150480_ab.func_176223_P();
                    }
                    if (destroyed.func_185904_a() == Material.field_151582_l) {
                        to = Blocks.field_150480_ab.func_176223_P();
                    }
                }
                boom.field_77287_j.func_180501_a((BlockPos)pos.getKey(), to, 3);
            }
        }
    }

    public static interface IEntityHitter {
        public void hitEntity(Entity var1, float var2, Explosion var3);
    }

    public static class HitEntity {
        final Entity entity;
        final float blastStrength;

        public HitEntity(Entity entity, float blastStrength) {
            this.entity = entity;
            this.blastStrength = blastStrength;
        }
    }

    public static class BlastResult {
        public final Object2FloatOpenHashMap<BlockPos> results;
        public final List<HitEntity> hit;
        public final boolean done;

        public BlastResult(Object2FloatOpenHashMap<BlockPos> results, List<HitEntity> hit, boolean done) {
            this.results = results;
            this.hit = hit;
            this.done = done;
        }
    }
}

