/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity;

import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.MathHelper;
import thut.api.maths.vecmath.Matrix3f;
import thut.api.maths.vecmath.Vector3f;

public interface IMultiplePassengerEntity {
    public static final IDataSerializer<Seat> SEATSERIALIZER = new IDataSerializer<Seat>(){

        public Seat copyValue(Seat value) {
            return new Seat((Vector3f)value.seat.clone(), value.getEntityId());
        }

        public DataParameter<Seat> func_187161_a(int id) {
            return new DataParameter(id, (IDataSerializer)this);
        }

        public Seat read(PacketBuffer buf) {
            return new Seat(buf);
        }

        public void write(PacketBuffer buf, Seat value) {
            value.writeToBuf(buf);
        }
    };

    public Entity getPassenger(Vector3f var1);

    public float getPitch();

    public float getPrevPitch();

    public float getPrevYaw();

    public Vector3f getSeat(Entity var1);

    public List<Vector3f> getSeats();

    public float getYaw();

    public void updateSeat(int var1, UUID var2);

    public static class Seat {
        public static final UUID BLANK = new UUID(0L, 0L);
        public Vector3f seat;
        private UUID entityId;

        public static Seat readFromNBT(CompoundNBT tag) {
            byte[] arr = tag.func_74770_j("v");
            PacketBuffer buf = new PacketBuffer(Unpooled.copiedBuffer((byte[])arr));
            return new Seat(buf);
        }

        public Seat(PacketBuffer buf) {
            this.seat = new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
            this.setEntityId(new UUID(buf.readLong(), buf.readLong()));
        }

        public Seat(Vector3f vector3f, UUID readInt) {
            this.seat = vector3f;
            this.setEntityId(readInt != null ? readInt : BLANK);
        }

        public Object clone() {
            return new Seat((Vector3f)this.seat.clone(), this.getEntityId());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Seat)) {
                return false;
            }
            Seat other = (Seat)obj;
            return this.getEntityId().equals(other.getEntityId()) && this.seat.epsilonEquals(other.seat, 0.1f);
        }

        public UUID getEntityId() {
            return this.entityId;
        }

        public void setEntityId(UUID entityId) {
            this.entityId = entityId;
        }

        public String toString() {
            return this.seat + " " + this.getEntityId();
        }

        public void writeToBuf(PacketBuffer buf) {
            buf.writeFloat(this.seat.x);
            buf.writeFloat(this.seat.y);
            buf.writeFloat(this.seat.z);
            buf.writeLong(this.getEntityId().getMostSignificantBits());
            buf.writeLong(this.getEntityId().getLeastSignificantBits());
        }

        public void writeToNBT(CompoundNBT tag) {
            PacketBuffer buffer = new PacketBuffer(Unpooled.buffer((int)8));
            this.writeToBuf(buffer);
            tag.func_74773_a("v", buffer.array());
        }
    }

    public static class MultiplePassengerManager {
        public static void managePassenger(Entity passenger, IMultiplePassengerEntity multipassenger) {
            Entity entity = (Entity)multipassenger;
            if (!entity.func_184196_w(passenger)) {
                return;
            }
            Vector3f v = multipassenger.getSeat(passenger);
            float yaw = -multipassenger.getYaw() * ((float)Math.PI / 180);
            float pitch = -multipassenger.getPitch() * ((float)Math.PI / 180);
            float sinYaw = MathHelper.func_76126_a((float)yaw);
            float cosYaw = MathHelper.func_76134_b((float)yaw);
            float sinPitch = MathHelper.func_76126_a((float)pitch);
            float cosPitch = MathHelper.func_76134_b((float)pitch);
            Matrix3f matrixYaw = new Matrix3f(cosYaw, 0.0f, sinYaw, 0.0f, 1.0f, 0.0f, -sinYaw, 0.0f, cosYaw);
            Matrix3f matrixPitch = new Matrix3f(cosPitch, -sinPitch, 0.0f, sinPitch, cosPitch, 0.0f, 0.0f, 0.0f, 1.0f);
            Matrix3f transform = new Matrix3f();
            transform.mul(matrixYaw, matrixPitch);
            if (v == null) {
                v = new Vector3f();
            } else {
                v = (Vector3f)v.clone();
                transform.transform(v);
            }
            passenger.func_70107_b(entity.func_226277_ct_() + (double)v.x, entity.func_226278_cu_() + passenger.func_70033_W() + (double)v.y, entity.func_226281_cx_() + (double)v.z);
        }
    }
}

