/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.entity.IShearable;

public class ShearableCaps {
    @CapabilityInject(value=IShearable.class)
    public static final Capability<IShearable> CAPABILITY = null;
    public static final ResourceLocation LOC = new ResourceLocation("thutcore:shearable");

    public static IShearable get(ICapabilityProvider in) {
        return (IShearable)in.getCapability(CAPABILITY).orElse(null);
    }

    @SubscribeEvent
    public static void attachMobs(AttachCapabilitiesEvent<Entity> event) {
        if (event.getCapabilities().containsKey(LOC)) {
            return;
        }
        if (event.getObject() instanceof SheepEntity) {
            event.addCapability(LOC, (ICapabilityProvider)new Sheep((SheepEntity)event.getObject()));
        }
    }

    public static void setup() {
        CapabilityManager.INSTANCE.register(IShearable.class, (Capability.IStorage)new Storage(), Impl::new);
        MinecraftForge.EVENT_BUS.register(ShearableCaps.class);
    }

    public static class Storage
    implements Capability.IStorage<IShearable> {
        public void readNBT(Capability<IShearable> capability, IShearable instance, Direction side, INBT nbt) {
            if (instance instanceof ICapabilitySerializable) {
                ((ICapabilitySerializable)instance).deserializeNBT(nbt);
            }
        }

        public INBT writeNBT(Capability<IShearable> capability, IShearable instance, Direction side) {
            if (instance instanceof ICapabilitySerializable) {
                return ((ICapabilitySerializable)instance).serializeNBT();
            }
            return null;
        }
    }

    public static class Impl
    implements IShearable,
    ICapabilityProvider {
        private final LazyOptional<IShearable> holder = LazyOptional.of(() -> this);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CAPABILITY.orEmpty(cap, this.holder);
        }

        @Override
        public boolean isSheared() {
            return false;
        }

        @Override
        public void shear() {
        }
    }

    public static class Wrapper
    extends Impl {
        final IShearable wrapped;

        public Wrapper(IShearable wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean isSheared() {
            return this.wrapped.isSheared();
        }

        @Override
        public void shear() {
            this.wrapped.shear();
        }

        @Override
        public void shear(ItemStack shears) {
            this.wrapped.shear(shears);
        }
    }

    public static class Sheep
    extends Impl {
        final SheepEntity sheep;

        public Sheep(SheepEntity sheep) {
            this.sheep = sheep;
        }

        @Override
        public boolean isSheared() {
            return this.sheep.func_70892_o();
        }

        @Override
        public void shear() {
            this.sheep.func_70893_e(true);
        }
    }
}

