/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.maths.Vector3;

public class ThutTeleporter {
    public static void transferTo(Entity entity, TeleDest dest) {
        ThutTeleporter.transferTo(entity, dest, false);
    }

    public static void transferTo(Entity entity, TeleDest dest, boolean sound) {
        if (entity.func_130014_f_() instanceof ServerWorld) {
            new InvulnTicker(entity);
            if (dest.loc.func_239646_a_() == entity.field_70170_p.func_234923_W_()) {
                ThutTeleporter.moveMob(entity, dest);
                return;
            }
            ServerWorld destWorld = entity.func_184102_h().func_71218_a(dest.loc.func_239646_a_());
            if (entity instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)entity;
                player.field_184851_cj = true;
                player.func_200619_a(destWorld, ((TeleDest)dest).subLoc.x, ((TeleDest)dest).subLoc.y, ((TeleDest)dest).subLoc.z, entity.field_70177_z, entity.field_70125_A);
                if (sound) {
                    destWorld.func_184134_a(((TeleDest)dest).subLoc.x, ((TeleDest)dest).subLoc.y, ((TeleDest)dest).subLoc.z, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                }
                player.field_184851_cj = false;
            } else {
                new TransferTicker(destWorld, entity, dest, sound);
            }
        }
    }

    private static void transferMob(ServerWorld destWorld, TeleDest dest, Entity entity) {
        ServerPlayerEntity player = null;
        if (entity instanceof ServerPlayerEntity) {
            player = (ServerPlayerEntity)entity;
            player.field_184851_cj = true;
        }
        ServerWorld serverworld = (ServerWorld)entity.func_130014_f_();
        ThutTeleporter.removeMob(serverworld, entity, true);
        entity.revive();
        entity.func_70012_b(((TeleDest)dest).subLoc.x, ((TeleDest)dest).subLoc.y, ((TeleDest)dest).subLoc.z, entity.field_70177_z, entity.field_70125_A);
        entity.func_70029_a((World)destWorld);
        ThutTeleporter.addMob(destWorld, entity);
        if (player != null) {
            player.field_184851_cj = false;
            player.field_71135_a.func_184342_d();
            player.field_71135_a.func_147364_a(((TeleDest)dest).subLoc.x, ((TeleDest)dest).subLoc.y, ((TeleDest)dest).subLoc.z, entity.field_70177_z, entity.field_70125_A);
        }
    }

    private static void addMob(ServerWorld world, Entity entity) {
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(entity, (World)world))) {
            return;
        }
        IChunk ichunk = world.func_217353_a(MathHelper.func_76128_c((double)(entity.func_226277_ct_() / 16.0)), MathHelper.func_76128_c((double)(entity.func_226281_cx_() / 16.0)), ChunkStatus.field_222617_m, true);
        if (ichunk instanceof Chunk) {
            ichunk.func_76612_a(entity);
        }
        world.func_217440_f(entity);
    }

    private static void removeMob(ServerWorld world, Entity entity, boolean keepData) {
        entity.remove(keepData);
        world.removeEntity(entity, keepData);
    }

    private static void moveMob(Entity entity, TeleDest dest) {
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            player.field_184851_cj = true;
            ((ServerPlayerEntity)entity).field_71135_a.func_147364_a(((TeleDest)dest).subLoc.x, ((TeleDest)dest).subLoc.y, ((TeleDest)dest).subLoc.z, entity.field_70177_z, entity.field_70125_A);
            ((ServerPlayerEntity)entity).field_71135_a.func_184342_d();
            player.field_184851_cj = false;
        } else {
            entity.func_70012_b(((TeleDest)dest).subLoc.x, ((TeleDest)dest).subLoc.y, ((TeleDest)dest).subLoc.z, entity.field_70177_z, entity.field_70125_A);
        }
    }

    private static class TransferTicker {
        private final Entity entity;
        private final ServerWorld destWorld;
        private final TeleDest dest;
        private final boolean sound;

        public TransferTicker(ServerWorld destWorld, Entity entity, TeleDest dest, boolean sound) {
            this.entity = entity;
            this.dest = dest;
            this.sound = sound;
            this.destWorld = destWorld;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void TickEvent(TickEvent.WorldTickEvent event) {
            if (event.world == this.entity.func_130014_f_() && event.phase == TickEvent.Phase.END) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                ThutTeleporter.transferMob(this.destWorld, this.dest, this.entity);
                if (this.sound) {
                    this.destWorld.func_184134_a(((TeleDest)this.dest).subLoc.x, ((TeleDest)this.dest).subLoc.y, ((TeleDest)this.dest).subLoc.z, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    this.entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                }
            }
        }
    }

    private static class InvulnTicker {
        private final ServerWorld overworld;
        private final Entity entity;
        private final long start;

        public InvulnTicker(Entity entity) {
            this.entity = entity;
            this.overworld = entity.func_184102_h().func_71218_a(World.field_234918_g_);
            this.start = this.overworld.func_82737_E();
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void damage(LivingHurtEvent event) {
            if (event.getEntity() != this.entity) {
                return;
            }
            long time = this.overworld.func_82737_E();
            if (time - this.start > 20L) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                return;
            }
            event.setCanceled(true);
        }
    }

    public static class TeleDest {
        public GlobalPos loc;
        private Vector3 subLoc;
        private String name;
        public int index;

        public static TeleDest readFromNBT(CompoundNBT nbt) {
            Vector3 loc = Vector3.readFromNBT(nbt, "v");
            String name = nbt.func_74779_i("name");
            int index = nbt.func_74762_e("i");
            GlobalPos pos = null;
            pos = (GlobalPos)((Pair)GlobalPos.field_239645_a_.decode((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt.func_74781_a("pos")).result().get()).getFirst();
            return new TeleDest().setLoc(pos, loc).setPos(pos).setName(name).setIndex(index);
        }

        public TeleDest setLoc(GlobalPos loc, Vector3 subLoc) {
            this.loc = loc;
            this.subLoc = subLoc;
            this.name = loc.func_218180_b().toString() + " " + loc.func_239646_a_().getRegistryName();
            return this;
        }

        public TeleDest setPos(GlobalPos pos) {
            if (pos != null) {
                this.loc = pos;
                this.subLoc = Vector3.getNewVector().set(this.loc.func_218180_b().func_177958_n(), this.loc.func_218180_b().func_177956_o(), this.loc.func_218180_b().func_177952_p());
                this.name = this.loc.func_218180_b().toString() + " " + this.loc.func_239646_a_().getRegistryName();
            }
            return this;
        }

        public GlobalPos getPos() {
            return this.loc;
        }

        public Vector3 getLoc() {
            return this.subLoc;
        }

        public String getName() {
            return this.name;
        }

        public TeleDest setIndex(int index) {
            this.index = index;
            return this;
        }

        public TeleDest setName(String name) {
            this.name = name;
            return this;
        }

        public void writeToNBT(CompoundNBT nbt) {
            this.subLoc.writeToNBT(nbt, "v");
            nbt.func_218657_a("pos", (INBT)GlobalPos.field_239645_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.loc).get().left().get());
            nbt.func_74778_a("name", this.name);
            nbt.func_74768_a("i", this.index);
        }

        public void shift(double dx, int dy, double dz) {
            this.subLoc.x += dx;
            this.subLoc.y += (double)dy;
            this.subLoc.z += dz;
        }

        public boolean withinDist(TeleDest other, double dist) {
            if (other.loc.func_239646_a_() == this.loc.func_239646_a_()) {
                return other.loc.func_218180_b().func_218141_a((Vector3i)this.loc.func_218180_b(), dist);
            }
            return false;
        }
    }
}

