/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import thut.api.entity.blockentity.IBlockEntity;

public class BlockEntityInventory
implements IItemHandlerModifiable,
ICapabilityProvider {
    private final LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this);
    IItemHandlerModifiable empty = new EmptyHandler();
    List<IItemHandlerModifiable> handlers;
    List<Integer> starts = Lists.newArrayList();
    int size = -1;
    final IBlockEntity base;

    public BlockEntityInventory(IBlockEntity base) {
        this.base = base;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.holder);
    }

    void init() {
        if (this.handlers == null) {
            this.handlers = Lists.newArrayList();
            this.size = 0;
            int sizeX = this.base.getTiles().length;
            int sizeY = this.base.getTiles()[0].length;
            int sizeZ = this.base.getTiles()[0][0].length;
            for (int i = 0; i < sizeX; ++i) {
                for (int k = 0; k < sizeY; ++k) {
                    for (int j = 0; j < sizeZ; ++j) {
                        LazyOptional opt;
                        TileEntity tile = this.base.getTiles()[i][j][k];
                        if (tile == null || !(opt = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent() || !(opt.orElse(null) instanceof IItemHandlerModifiable)) continue;
                        IItemHandlerModifiable handler = (IItemHandlerModifiable)opt.orElse(null);
                        this.handlers.add(handler);
                        this.starts.add(this.size);
                        this.size += handler.getSlots();
                    }
                }
            }
        }
    }

    protected int getSubSlot(int slot) {
        for (int i = 0; i < this.starts.size() - 1; ++i) {
            if (this.starts.get(i + 1) <= slot) continue;
            return slot - this.starts.get(i);
        }
        return 0;
    }

    protected int getIndex(int slot) {
        for (int i = 0; i < this.starts.size() - 1; ++i) {
            if (this.starts.get(i + 1) <= slot) continue;
            return i;
        }
        return 0;
    }

    protected IItemHandlerModifiable getFromSlot(int slot) {
        int index = this.getIndex(slot);
        if (index < this.handlers.size()) {
            return this.handlers.get(index);
        }
        return this.empty;
    }

    public int getSlots() {
        return this.size;
    }

    public ItemStack getStackInSlot(int slot) {
        IItemHandlerModifiable sub = this.getFromSlot(slot);
        slot = this.getSubSlot(slot);
        return sub.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        IItemHandlerModifiable sub = this.getFromSlot(slot);
        slot = this.getSubSlot(slot);
        return sub.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        IItemHandlerModifiable sub = this.getFromSlot(slot);
        slot = this.getSubSlot(slot);
        return sub.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        IItemHandlerModifiable sub = this.getFromSlot(slot);
        slot = this.getSubSlot(slot);
        return sub.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        IItemHandlerModifiable sub = this.getFromSlot(slot);
        slot = this.getSubSlot(slot);
        return sub.isItemValid(slot, stack);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        IItemHandlerModifiable sub = this.getFromSlot(slot);
        slot = this.getSubSlot(slot);
        sub.setStackInSlot(slot, stack);
    }
}

