/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import thut.api.entity.blockentity.BlockEntityInteractHandler;
import thut.api.entity.blockentity.BlockEntityUpdater;
import thut.api.entity.blockentity.world.IBlockEntityWorld;
import thut.api.maths.Vector3;

public interface IBlockEntity {
    public static final Set<ResourceLocation> BLOCKBLACKLIST = Sets.newHashSet();
    public static final Set<String> TEBLACKLIST = Sets.newHashSet();
    public static final BiMap<Class<?>, ITileRemover> CUSTOMREMOVERS = HashBiMap.create();
    public static final List<ITileRemover> SORTEDREMOVERS = Lists.newArrayList();
    public static final ITileRemover DEFAULTREMOVER = new ITileRemover(){

        @Override
        public void postBlockRemoval(TileEntity tileIn) {
        }

        @Override
        public void preBlockRemoval(TileEntity tileIn) {
            tileIn.func_145843_s();
        }
    };

    public static void addRemover(ITileRemover remover, Class<?> clas) {
        CUSTOMREMOVERS.put(clas, (Object)remover);
        SORTEDREMOVERS.add(remover);
        Collections.sort(SORTEDREMOVERS, (o1, o2) -> o1.getPriority() - o2.getPriority());
    }

    public static ITileRemover getRemover(TileEntity tile) {
        ITileRemover ret = (ITileRemover)CUSTOMREMOVERS.get(tile.getClass());
        if (ret != null) {
            return ret;
        }
        for (ITileRemover temp : SORTEDREMOVERS) {
            Class key = (Class)CUSTOMREMOVERS.inverse().get((Object)temp);
            if (!key.isInstance(tile)) continue;
            return temp;
        }
        return DEFAULTREMOVER;
    }

    public BlockState[][][] getBlocks();

    public IBlockEntityWorld getFakeWorld();

    public BlockEntityInteractHandler getInteractor();

    public BlockPos getMax();

    public BlockPos getMin();

    public BlockPos getOriginalPos();

    public TileEntity[][][] getTiles();

    public void setBlocks(BlockState[][][] var1);

    public void setFakeWorld(IBlockEntityWorld var1);

    public void setMax(BlockPos var1);

    public void setMin(BlockPos var1);

    public void setSize(EntitySize var1);

    public void setTiles(TileEntity[][][] var1);

    default public boolean shouldHide(BlockPos pos) {
        TileEntity tile = this.getFakeWorld().getTile(pos);
        return tile != null && !BlockEntityUpdater.isWhitelisted(tile);
    }

    public static interface ITileRemover {
        default public int getPriority() {
            return 0;
        }

        public void postBlockRemoval(TileEntity var1);

        public void preBlockRemoval(TileEntity var1);
    }

    public static class BlockEntityFormer {
        public static BlockState[][][] checkBlocks(World world, BlockPos min, BlockPos max, BlockPos pos) {
            int xMin = min.func_177958_n();
            int zMin = min.func_177952_p();
            int xMax = max.func_177958_n();
            int zMax = max.func_177952_p();
            int yMin = min.func_177956_o();
            int yMax = max.func_177956_o();
            BlockState[][][] ret = new BlockState[xMax - xMin + 1][yMax - yMin + 1][zMax - zMin + 1];
            boolean valid = false;
            for (int i = xMin; i <= xMax; ++i) {
                for (int j = yMin; j <= yMax; ++j) {
                    for (int k = zMin; k <= zMax; ++k) {
                        BlockPos temp = pos.func_177982_a(i, j, k);
                        BlockState state = world.func_180495_p(temp);
                        if (BLOCKBLACKLIST.contains(state.func_177230_c().getRegistryName())) {
                            return null;
                        }
                        valid = valid || !state.func_177230_c().isAir(state, (IBlockReader)world, pos);
                        ret[i - xMin][j - yMin][k - zMin] = state;
                    }
                }
            }
            return valid ? ret : (BlockState[][][])null;
        }

        public static TileEntity[][][] checkTiles(World world, BlockPos min, BlockPos max, BlockPos pos) {
            int xMin = min.func_177958_n();
            int zMin = min.func_177952_p();
            int xMax = max.func_177958_n();
            int zMax = max.func_177952_p();
            int yMin = min.func_177956_o();
            int yMax = max.func_177956_o();
            TileEntity[][][] ret = new TileEntity[xMax - xMin + 1][yMax - yMin + 1][zMax - zMin + 1];
            for (int i = xMin; i <= xMax; ++i) {
                for (int j = yMin; j <= yMax; ++j) {
                    for (int k = zMin; k <= zMax; ++k) {
                        BlockPos temp = pos.func_177982_a(i, j, k);
                        TileEntity old = world.func_175625_s(temp);
                        if (old == null) continue;
                        CompoundNBT tag = new CompoundNBT();
                        tag = old.func_189515_b(tag);
                        ret[i - xMin][j - yMin][k - zMin] = TileEntity.func_235657_b_((BlockState)world.func_180495_p(temp), (CompoundNBT)tag);
                    }
                }
            }
            return ret;
        }

        public static <T extends Entity> T makeBlockEntity(World world, BlockPos min, BlockPos max, BlockPos pos, EntityType<T> type) {
            Entity ret = type.func_200721_a(world);
            AxisAlignedBB box = new AxisAlignedBB(min, max);
            min = new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c);
            max = new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f);
            IBlockEntity entity = (IBlockEntity)ret;
            ret.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            BlockState[][][] blocks = BlockEntityFormer.checkBlocks(world, min, max, pos);
            if (blocks == null) {
                return null;
            }
            entity.setBlocks(blocks);
            entity.setTiles(BlockEntityFormer.checkTiles(world, min, max, pos));
            entity.setMin(min);
            entity.setMax(max);
            BlockEntityFormer.removeBlocks(world, min, max, pos);
            world.func_217376_c(ret);
            return (T)ret;
        }

        public static RayTraceResult rayTraceInternal(Vector3d start, Vector3d end, IBlockEntity toTrace) {
            Vector3d diff = end.func_178788_d(start);
            double l = diff.func_72433_c();
            diff = diff.func_72432_b();
            IBlockEntityWorld world = toTrace.getFakeWorld();
            Vector3.MutableBlockPos pos = new Vector3.MutableBlockPos(0, 0, 0);
            for (double i = 0.0; i < l; i += 0.1) {
                VoxelShape shape;
                BlockRayTraceResult hit;
                Vector3d spot = start.func_178787_e(diff.func_216372_d(i, i, i));
                pos.set(MathHelper.func_76128_c((double)spot.field_72450_a), MathHelper.func_76128_c((double)spot.field_72448_b), MathHelper.func_76128_c((double)spot.field_72449_c));
                BlockState state = world.getBlock(pos);
                if (state == null || state.isAir((IBlockReader)world, (BlockPos)pos) || (hit = (shape = state.func_196952_d((IBlockReader)world, (BlockPos)pos)).func_212433_a(start, end, (BlockPos)pos)) == null) continue;
                return hit;
            }
            return BlockRayTraceResult.func_216352_a((Vector3d)end, (Direction)Direction.DOWN, (BlockPos)new BlockPos(end));
        }

        public static void removeBlocks(World world, BlockPos min, BlockPos max, BlockPos pos) {
            ITileRemover tileHandler;
            TileEntity tile;
            int k;
            int j;
            int i;
            int xMin = min.func_177958_n();
            int zMin = min.func_177952_p();
            int xMax = max.func_177958_n();
            int zMax = max.func_177952_p();
            int yMin = min.func_177956_o();
            int yMax = max.func_177956_o();
            BlockPos.Mutable temp = new BlockPos.Mutable();
            for (i = xMin; i <= xMax; ++i) {
                for (j = yMin; j <= yMax; ++j) {
                    for (k = zMin; k <= zMax; ++k) {
                        temp.func_181079_c(pos.func_177958_n() + i, pos.func_177956_o() + j, pos.func_177952_p() + k);
                        tile = world.func_175625_s((BlockPos)temp);
                        tileHandler = null;
                        if (tile == null) continue;
                        tileHandler = IBlockEntity.getRemover(tile);
                        tileHandler.preBlockRemoval(tile);
                    }
                }
            }
            for (i = xMin; i <= xMax; ++i) {
                for (j = yMin; j <= yMax; ++j) {
                    for (k = zMin; k <= zMax; ++k) {
                        temp.func_181079_c(pos.func_177958_n() + i, pos.func_177956_o() + j, pos.func_177952_p() + k);
                        tile = world.func_175625_s((BlockPos)temp);
                        tileHandler = null;
                        if (tile != null) {
                            tileHandler = IBlockEntity.getRemover(tile);
                        }
                        world.func_180501_a((BlockPos)temp, Blocks.field_150350_a.func_176223_P(), 114);
                        if (tileHandler == null) continue;
                        tileHandler.postBlockRemoval(tile);
                    }
                }
            }
            for (i = xMin; i <= xMax; ++i) {
                for (j = yMin; j <= yMax; ++j) {
                    for (k = zMin; k <= zMax; ++k) {
                        temp.func_181079_c(pos.func_177958_n() + i, pos.func_177956_o() + j, pos.func_177952_p() + k);
                        world.func_180501_a((BlockPos)temp, Blocks.field_150350_a.func_176223_P(), 3);
                    }
                }
            }
        }

        public static void RevertEntity(IBlockEntity toRevert) {
            int xMin = toRevert.getMin().func_177958_n();
            int zMin = toRevert.getMin().func_177952_p();
            int yMin = toRevert.getMin().func_177956_o();
            if (toRevert.getBlocks() == null) {
                return;
            }
            int sizeX = toRevert.getBlocks().length;
            int sizeY = toRevert.getBlocks()[0].length;
            int sizeZ = toRevert.getBlocks()[0][0].length;
            Entity entity = (Entity)toRevert;
            for (int i = 0; i < sizeX; ++i) {
                for (int j = 0; j < sizeY; ++j) {
                    for (int k = 0; k < sizeZ; ++k) {
                        TileEntity newTile;
                        BlockPos pos = new BlockPos((double)(i + xMin) + entity.func_226277_ct_(), (double)(j + yMin) + entity.func_226278_cu_(), (double)(k + zMin) + entity.func_226281_cx_());
                        BlockState state = toRevert.getFakeWorld().getBlock(pos);
                        TileEntity tile = toRevert.getFakeWorld().getTile(pos);
                        if (state == null) continue;
                        entity.func_130014_f_().func_175656_a(pos, state);
                        if (tile == null || (newTile = entity.func_130014_f_().func_175625_s(pos)) == null) continue;
                        newTile.func_230337_a_(state, tile.func_189515_b(new CompoundNBT()));
                    }
                }
            }
            List possibleInside = entity.func_130014_f_().func_72839_b(entity, entity.func_174813_aQ());
            for (Entity e : possibleInside) {
                e.func_70107_b(e.func_226277_ct_(), e.func_226278_cu_() + 0.25, e.func_226281_cx_());
            }
        }
    }
}

