/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity.world;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.lighting.WorldLightManager;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.entity.blockentity.world.WorldEntity;

public class BlockEntityChunkProvider
extends AbstractChunkProvider {
    private final WorldEntity world;
    private final WorldLightManager lightManager;
    private final Map<BlockPos, Chunk> chunks = Maps.newHashMap();
    private BlockPos lastOrigin = null;

    public BlockEntityChunkProvider(WorldEntity worldIn) {
        this.world = worldIn;
        this.lightManager = new WorldLightManager((IChunkLightProvider)this, true, worldIn.getWorld().func_230315_m_().func_218272_d());
    }

    public IChunk func_212849_a_(int chunkX, int chunkZ, ChunkStatus status, boolean load) {
        AxisAlignedBB chunkBox = new AxisAlignedBB((double)(chunkX * 16), 0.0, (double)(chunkZ * 16), (double)(chunkX * 16 + 15), (double)this.world.getWorld().func_217301_I(), (double)(chunkZ * 16 + 15));
        if (!this.intersects(chunkBox)) {
            return this.world.getWorld().func_212866_a_(chunkX, chunkZ);
        }
        Entity entity = (Entity)this.world.getBlockEntity();
        if (this.lastOrigin == null || !this.lastOrigin.equals((Object)entity.func_233580_cy_())) {
            this.lastOrigin = entity.func_233580_cy_();
            this.chunks.clear();
        }
        BlockPos.Mutable pos = new BlockPos.Mutable();
        pos.func_181079_c(chunkX, 0, chunkZ);
        BlockPos immut = pos.func_185334_h();
        if (this.chunks.containsKey(immut)) {
            return (IChunk)this.chunks.get(immut);
        }
        ChunkPrimer primer = new ChunkPrimer(new ChunkPos(chunkX, chunkZ), UpgradeData.field_196994_a);
        Chunk ret = new Chunk(this.world.getWorld(), primer);
        this.chunks.put(immut, ret);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 256; ++j) {
                for (int k = 0; k < 16; ++k) {
                    int x = chunkX * 16 + i;
                    int y = j;
                    int z = chunkZ * 16 + k;
                    pos.func_181079_c(x, y, z);
                    BlockState state = this.world.func_180495_p((BlockPos)pos);
                    if (state.func_177230_c() == Blocks.field_150350_a) continue;
                    ChunkSection storage = ret.func_76587_i()[j >> 4];
                    if (storage == null) {
                        ret.func_76587_i()[j >> 4] = storage = new ChunkSection(j >> 4 << 4);
                    }
                    storage.func_177484_a(i & 0xF, j & 0xF, k & 0xF, state, false);
                    TileEntity tile = this.world.func_175625_s((BlockPos)pos);
                    if (tile == null) continue;
                    ret.func_150813_a(tile);
                }
            }
        }
        return ret;
    }

    public WorldLightManager func_212863_j_() {
        return this.lightManager;
    }

    public IBlockReader func_212864_k_() {
        return this.world;
    }

    private boolean intersects(AxisAlignedBB other) {
        IBlockEntity mob = this.world.getBlockEntity();
        BlockPos pos = ((Entity)mob).func_233580_cy_();
        AxisAlignedBB thisBox = new AxisAlignedBB(mob.getMin().func_177971_a((Vector3i)pos).func_177982_a(-1, -1, -1), mob.getMax().func_177971_a((Vector3i)pos).func_177982_a(1, 1, 1));
        return thisBox.func_72326_a(other);
    }

    public String func_73148_d() {
        return "BlockEntity: " + this.world + " " + this.world.getWorld();
    }

    public boolean func_222866_a(BlockPos pos) {
        return false;
    }
}

