/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity.world;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import thut.api.entity.blockentity.IBlockEntity;

public interface IBlockEntityWorld
extends IWorld {
    default public BlockState getBlock(BlockPos pos) {
        if (!this.inBounds(pos)) {
            return null;
        }
        IBlockEntity mob = this.getBlockEntity();
        Entity entity = (Entity)mob;
        int i = pos.func_177958_n() - MathHelper.func_76128_c((double)(entity.func_226277_ct_() + (double)mob.getMin().func_177958_n()));
        int j = pos.func_177956_o() - MathHelper.func_76128_c((double)(entity.func_226278_cu_() + (double)mob.getMin().func_177956_o()));
        int k = pos.func_177952_p() - MathHelper.func_76128_c((double)(entity.func_226281_cx_() + (double)mob.getMin().func_177952_p()));
        return mob.getBlocks()[i][j][k];
    }

    public IBlockEntity getBlockEntity();

    default public World getWorld() {
        Entity entity = (Entity)this.getBlockEntity();
        return entity.func_130014_f_();
    }

    default public TileEntity getTile(BlockPos pos) {
        if (!this.inBounds(pos)) {
            return null;
        }
        IBlockEntity mob = this.getBlockEntity();
        Entity entity = (Entity)mob;
        int i = pos.func_177958_n() - MathHelper.func_76128_c((double)(entity.func_226277_ct_() + (double)mob.getMin().func_177958_n()));
        int j = pos.func_177956_o() - MathHelper.func_76128_c((double)(entity.func_226278_cu_() + (double)mob.getMin().func_177956_o()));
        int k = pos.func_177952_p() - MathHelper.func_76128_c((double)(entity.func_226281_cx_() + (double)mob.getMin().func_177952_p()));
        TileEntity tile = mob.getTiles()[i][j][k];
        if (tile != null) {
            tile.func_174878_a(pos.func_185334_h());
        }
        return tile;
    }

    default public boolean inBounds(BlockPos pos) {
        IBlockEntity mob = this.getBlockEntity();
        if (mob.getBlocks() == null) {
            return false;
        }
        Entity entity = (Entity)mob;
        int i = pos.func_177958_n() - MathHelper.func_76128_c((double)(entity.func_226277_ct_() + (double)mob.getMin().func_177958_n()));
        int j = pos.func_177956_o() - MathHelper.func_76128_c((double)(entity.func_226278_cu_() + (double)mob.getMin().func_177956_o()));
        int k = pos.func_177952_p() - MathHelper.func_76128_c((double)(entity.func_226281_cx_() + (double)mob.getMin().func_177952_p()));
        return i < mob.getBlocks().length && j < mob.getBlocks()[0].length && k < mob.getBlocks()[0][0].length && i >= 0 && j >= 0 && k >= 0;
    }

    default public boolean setBlock(BlockPos pos, BlockState state) {
        if (!this.inBounds(pos)) {
            return false;
        }
        IBlockEntity mob = this.getBlockEntity();
        Entity entity = (Entity)mob;
        int i = pos.func_177958_n() - MathHelper.func_76128_c((double)(entity.func_226277_ct_() + (double)mob.getMin().func_177958_n()));
        int j = pos.func_177956_o() - MathHelper.func_76128_c((double)(entity.func_226278_cu_() + (double)mob.getMin().func_177956_o()));
        int k = pos.func_177952_p() - MathHelper.func_76128_c((double)(entity.func_226281_cx_() + (double)mob.getMin().func_177952_p()));
        mob.getBlocks()[i][j][k] = state;
        return true;
    }

    default public void setBlockEntity(IBlockEntity mob) {
        Entity entity = (Entity)mob;
        int xMin = mob.getMin().func_177958_n();
        int zMin = mob.getMin().func_177952_p();
        int yMin = mob.getMin().func_177956_o();
        if (mob.getBlocks() == null) {
            if (!entity.func_130014_f_().field_72995_K) {
                entity.func_70106_y();
            }
            return;
        }
        int sizeX = mob.getBlocks().length;
        int sizeY = mob.getBlocks()[0].length;
        int sizeZ = mob.getBlocks()[0][0].length;
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                for (int k = 0; k < sizeZ; ++k) {
                    if (mob.getTiles()[i][j][k] == null) continue;
                    BlockPos pos = new BlockPos((double)(i + xMin) + entity.func_226277_ct_(), (double)(j + yMin) + entity.func_226278_cu_(), (double)(k + zMin) + entity.func_226281_cx_());
                    mob.getTiles()[i][j][k].func_174878_a(pos);
                    mob.getTiles()[i][j][k].func_145829_t();
                }
            }
        }
    }

    default public boolean setTile(BlockPos pos, TileEntity tile) {
        if (!this.inBounds(pos)) {
            return false;
        }
        IBlockEntity mob = this.getBlockEntity();
        Entity entity = (Entity)mob;
        int i = pos.func_177958_n() - MathHelper.func_76128_c((double)(entity.func_226277_ct_() + (double)mob.getMin().func_177958_n()));
        int j = pos.func_177956_o() - MathHelper.func_76128_c((double)(entity.func_226278_cu_() + (double)mob.getMin().func_177956_o()));
        int k = pos.func_177952_p() - MathHelper.func_76128_c((double)(entity.func_226281_cx_() + (double)mob.getMin().func_177952_p()));
        mob.getTiles()[i][j][k] = tile;
        if (tile != null) {
            boolean invalid = tile.func_145837_r();
            if (!invalid) {
                tile.func_145843_s();
            }
            tile.func_174878_a(pos.func_185334_h());
            tile.func_145829_t();
        }
        return true;
    }

    default public RayTraceResult trace(RayTraceContext context) {
        return this.getWorld().func_217299_a(context);
    }
}

