/*
 * Decompiled with CFR 0.152.
 */
package thut.api.inventory.big;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import thut.api.inventory.big.BigInventory;
import thut.core.common.ThutCore;
import thut.core.common.handlers.PlayerDataHandler;

public abstract class Manager<T extends BigInventory> {
    protected Map<UUID, T> _map = Maps.newHashMap();
    private final Predicate<ItemStack> valid;
    private final BigInventory.NewFactory<T> new_factory;
    private final BigInventory.LoadFactory<T> load_factory;

    public Manager(Predicate<ItemStack> valid, BigInventory.NewFactory<T> new_factory, BigInventory.LoadFactory<T> load_factory) {
        this.valid = valid;
        this.new_factory = new_factory;
        this.load_factory = load_factory;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public abstract String fileName();

    public abstract String tagID();

    protected void load(UUID uuid) {
        if (ThutCore.proxy.isClientSide()) {
            return;
        }
        try {
            File file = PlayerDataHandler.getFileForUUID(uuid.toString(), this.fileName());
            if (file != null && file.exists()) {
                FileInputStream fileinputstream = new FileInputStream(file);
                CompoundNBT CompoundNBT2 = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                fileinputstream.close();
                this.loadNBT(CompoundNBT2.func_74775_l("Data"));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadNBT(CompoundNBT nbt) {
        INBT temp = nbt.func_74781_a(this.tagID());
        if (temp instanceof ListNBT) {
            ListNBT tagListPC = (ListNBT)temp;
            for (int i = 0; i < tagListPC.size(); ++i) {
                CompoundNBT items = tagListPC.func_150305_b(i);
                BigInventory load = (BigInventory)this.load_factory.create(this, items);
                this._map.put(load.id, load);
            }
        }
    }

    protected void save(UUID uuid) {
        if (ThutCore.proxy.isClientSide()) {
            return;
        }
        T save = this.get(uuid, false);
        if (save == null || !((BigInventory)save).dirty) {
            return;
        }
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        try {
            File file = PlayerDataHandler.getFileForUUID(uuid.toString(), this.fileName());
            if (file != null) {
                CompoundNBT CompoundNBT2 = new CompoundNBT();
                this.writeToNBT(CompoundNBT2, save);
                CompoundNBT CompoundNBT1 = new CompoundNBT();
                CompoundNBT1.func_218657_a("Data", (INBT)CompoundNBT2);
                FileOutputStream fileoutputstream = new FileOutputStream(file);
                CompressedStreamTools.func_74799_a((CompoundNBT)CompoundNBT1, (OutputStream)fileoutputstream);
                fileoutputstream.close();
                if (server.func_184103_al().func_177451_a(uuid) == null) {
                    this._map.remove(uuid);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeToNBT(CompoundNBT nbt, T save) {
        ListNBT nbttag = new ListNBT();
        CompoundNBT items = ((BigInventory)save).serializeNBT();
        nbttag.add((Object)items);
        nbt.func_218657_a(this.tagID(), (INBT)nbttag);
    }

    public T get(Entity mob) {
        return this.get(mob.func_110124_au());
    }

    public T get(UUID id, boolean create) {
        if (!this._map.containsKey(id) && create) {
            this.load(id);
            if (!this._map.containsKey(id)) {
                this._map.put(id, this.new_factory.create(this, id));
            }
        }
        return (T)((BigInventory)this._map.get(id));
    }

    public T get(UUID id) {
        return this.get(id, true);
    }

    public void clear() {
        this._map.clear();
    }

    @SubscribeEvent
    protected void serverStarting(FMLServerAboutToStartEvent event) {
        this.clear();
    }

    boolean isItemValid(ItemStack stack) {
        return this.valid.test(stack);
    }
}

