/*
 * Decompiled with CFR 0.152.
 */
package thut.api.maths;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import thut.api.entity.ICompoundMob;
import thut.api.maths.Cruncher;
import thut.api.maths.Matrix3;

public class Vector3 {
    public static final Vector3 secondAxis = Vector3.getNewVector().set(0.0, 1.0, 0.0);
    public static final Vector3 secondAxisNeg = Vector3.getNewVector().set(0.0, -1.0, 0.0);
    public static final Vector3 firstAxis = Vector3.getNewVector().set(1.0, 0.0, 0.0);
    public static final Vector3 firstAxisNeg = Vector3.getNewVector().set(-1.0, 0.0, 0.0);
    public static final Vector3 thirdAxis = Vector3.getNewVector().set(0.0, 0.0, 1.0);
    public static final Vector3 thirdAxisNeg = Vector3.getNewVector().set(0.0, 0.0, -1.0);
    public static final Vector3 empty = Vector3.getNewVector();
    public static final int length = 3;
    public static Vector3 vecMult = Vector3.getNewVector();
    public static double[][] rotBox = new double[3][3];
    static Vector3 move1 = Vector3.getNewVector();
    static Vector3 move2 = Vector3.getNewVector();
    private static FakePlayer USEDFORRAYTRACECONTEXT = null;
    private static final UUID PLAYERID = new UUID(1234567L, 7324156L);
    private static final GameProfile FAKEPLAYER = new GameProfile(PLAYERID, "raytrace-context");
    public double x;
    public double y;
    public double z;
    MutableBlockPos pos;

    public static Vector3 entity(Entity e) {
        if (e != null) {
            return Vector3.getNewVector().set(e.func_226277_ct_(), e.func_226278_cu_() + (double)e.func_70047_e(), e.func_226281_cx_());
        }
        return null;
    }

    public static Vector3 findMidPoint(List<Vector3> points) {
        Vector3 mid = Vector3.getNewVector();
        for (Vector3 point : points) {
            mid.addTo(point);
        }
        if (points.size() > 0) {
            mid.scalarMultBy(1.0 / (double)points.size());
        }
        return mid;
    }

    public static Vector3 findNextSolidBlock(IBlockReader world, Vector3 source, Vector3 direction, double range) {
        direction = direction.normalize();
        double xprev = source.x;
        double yprev = source.y;
        double zprev = source.z;
        Vector3 test = Vector3.getNewVector();
        for (double i = 0.0; i < range; i += 1.0) {
            double dx = i * direction.x;
            double dy = i * direction.y;
            double dz = i * direction.z;
            double xtest = source.x + dx;
            double ytest = source.y + dy;
            double ztest = source.z + dz;
            if (ytest > 255.0) {
                return null;
            }
            if (Vector3.Int(xtest) != Vector3.Int(xprev) || Vector3.Int(ytest) != Vector3.Int(yprev) || Vector3.Int(ztest) != Vector3.Int(zprev)) {
                test.set(xtest, ytest, ztest);
                boolean clear = test.isClearOfBlocks(world);
                if (!clear) {
                    return Vector3.getNewVector().set(Vector3.Int(xtest), Vector3.Int(ytest), Vector3.Int(ztest));
                }
            }
            yprev = ytest;
            xprev = xtest;
            zprev = ztest;
        }
        return null;
    }

    public static Vector3 getNewVector() {
        return new Vector3();
    }

    public static Vector3 getNextSurfacePoint(IBlockReader world, Vector3 source, Vector3 direction, double range) {
        direction = direction.normalize();
        MutableBlockPos pos = new MutableBlockPos(0, 0, 0);
        for (double i = 0.0; i < range; i += 0.0625) {
            double dx = i * direction.x;
            double xtest = source.x + dx;
            double dy = i * direction.y;
            double ytest = source.y + dy;
            double dz = i * direction.z;
            double ztest = source.z + dz;
            boolean check = Vector3.isPointClearBlocks_internal(xtest, ytest - dy, ztest - dz, world, pos);
            check = check && Vector3.isPointClearBlocks_internal(xtest - dx, ytest, ztest - dz, world, pos);
            boolean bl = check = check && Vector3.isPointClearBlocks_internal(xtest - dx, ytest - dy, ztest, world, pos);
            if (check) continue;
            return Vector3.getNewVector().set(xtest, ytest, ztest);
        }
        return null;
    }

    public static boolean isPointClearBlocks_internal(double x, double y, double z, IBlockReader world, MutableBlockPos pos) {
        int x0 = MathHelper.func_76128_c((double)x);
        int y0 = MathHelper.func_76128_c((double)y);
        int z0 = MathHelper.func_76128_c((double)z);
        pos.set(x0, y0, z0);
        BlockState state = world.func_180495_p((BlockPos)pos);
        if (state == null) {
            return true;
        }
        VoxelShape shape = state.func_196952_d(world, (BlockPos)pos);
        List aabbs = shape.func_197756_d();
        for (AxisAlignedBB aabb : aabbs) {
            if (aabb == null || !aabb.func_197744_e(x - (double)x0, y - (double)y0, z - (double)z0)) continue;
            return false;
        }
        return true;
    }

    public static int Int(double x) {
        return MathHelper.func_76128_c((double)x);
    }

    public static boolean isPointClearBlocks(double x, double y, double z, IBlockReader world) {
        int z0;
        int y0;
        int x0 = MathHelper.func_76128_c((double)x);
        BlockPos pos = new BlockPos(x0, y0 = MathHelper.func_76128_c((double)y), z0 = MathHelper.func_76128_c((double)z));
        BlockState state = world.func_180495_p(pos);
        if (state == null) {
            return true;
        }
        VoxelShape shape = state.func_196952_d(world, pos);
        List aabbs = shape.func_197756_d();
        for (AxisAlignedBB aabb : aabbs) {
            if (aabb == null || !aabb.func_197744_e(x - (double)x0, y - (double)y0, z - (double)z0)) continue;
            return false;
        }
        return true;
    }

    public static boolean isVisibleEntityFromEntity(Entity looker, Entity target) {
        if (looker == null || target == null) {
            return false;
        }
        if (looker instanceof LivingEntity) {
            return ((LivingEntity)looker).func_70685_l(target);
        }
        return false;
    }

    public static boolean isVisibleRange(IBlockReader world, Vector3 source, Vector3 direction, double range) {
        direction = direction.normalize();
        if (world instanceof ServerWorld) {
            Vector3d start = source.toVec3d();
            Vector3d end = direction.scalarMultBy(range).addTo(source).toVec3d();
            if (USEDFORRAYTRACECONTEXT == null) {
                USEDFORRAYTRACECONTEXT = FakePlayerFactory.get((ServerWorld)((ServerWorld)world), (GameProfile)FAKEPLAYER);
            } else {
                USEDFORRAYTRACECONTEXT.func_70029_a((World)world);
            }
            RayTraceContext context = new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)USEDFORRAYTRACECONTEXT);
            BlockRayTraceResult result = world.func_217299_a(context);
            return result.func_216346_c() == RayTraceResult.Type.MISS;
        }
        for (double i = 0.0; i < range; i += 0.0625) {
            double dx = i * direction.x;
            double xtest = source.x + dx;
            double dy = i * direction.y;
            double ytest = source.y + dy;
            double dz = i * direction.z;
            double ztest = source.z + dz;
            boolean check = Vector3.isPointClearBlocks(xtest, ytest, ztest, world);
            if (check) continue;
            return false;
        }
        return true;
    }

    public static Vector3 readFromBuff(ByteBuf dat) {
        Vector3 ret = Vector3.getNewVector();
        ret.x = dat.readDouble();
        ret.y = dat.readDouble();
        ret.z = dat.readDouble();
        return ret;
    }

    public static Vector3 readFromNBT(CompoundNBT nbt, String tag) {
        if (!nbt.func_74764_b(tag + "x")) {
            return null;
        }
        Vector3 ret = Vector3.getNewVector();
        ret.x = nbt.func_74769_h(tag + "x");
        ret.y = nbt.func_74769_h(tag + "y");
        ret.z = nbt.func_74769_h(tag + "z");
        return ret;
    }

    public static void rotateAboutAngles(Vector3[] points, double pitch, double yaw, Vector3 temp, Vector3 temp1) {
        for (int i = 0; i < points.length; ++i) {
            points[i] = points[i].rotateAboutAngles(pitch, yaw, temp, temp1);
        }
    }

    public static double vectorDot(Vector3 vector1, Vector3 vector2) {
        double dot = 0.0;
        for (int i = 0; i < 3; ++i) {
            dot += vector1.get(i) * vector2.get(i);
        }
        return dot;
    }

    private Vector3() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    private Vector3(double pitch, double yaw) {
        this.x = 1.0;
        this.y = Math.toRadians(pitch);
        this.z = Math.toRadians(yaw);
    }

    private Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    private Vector3(Entity e, boolean bool) {
        if (e != null && bool) {
            this.x = e.func_226277_ct_();
            this.y = e.func_226278_cu_() + (double)(e.func_213302_cg() / 2.0f);
            this.z = e.func_226281_cx_();
        } else if (e != null) {
            this.x = e.func_226277_ct_();
            this.y = e.func_226278_cu_() + (double)e.func_70047_e();
            this.z = e.func_226281_cx_();
        }
    }

    private Vector3(Object a) {
        this();
        this.set(a);
    }

    private Vector3(Object a, Object b) {
        this();
        Vector3 A = Vector3.getNewVector().set(a);
        Vector3 B = Vector3.getNewVector().set(b);
        this.set(B.subtract(A));
    }

    private Vector3(Vector3d vec) {
        this.x = vec.field_72450_a;
        this.y = vec.field_72448_b;
        this.z = vec.field_72449_c;
    }

    public Vector3 add(double i, double j, double k) {
        return Vector3.getNewVector().set(this.x + i, j + this.y, k + this.z);
    }

    public void add(int i, double j) {
        if (i == 0) {
            this.x += j;
        } else if (i == 1) {
            this.y += j;
        } else if (i == 2) {
            this.z += j;
        }
    }

    public Vector3 add(Vector3 vectorB) {
        Vector3 vectorC = Vector3.getNewVector();
        for (int i = 0; i < 3; ++i) {
            vectorC.set(i, this.get(i) + vectorB.get(i));
        }
        return vectorC;
    }

    public Vector3 addTo(double i, double j, double k) {
        this.x += i;
        this.y += j;
        this.z += k;
        return this;
    }

    public Vector3 addTo(Vector3 b) {
        if (b == null) {
            return this;
        }
        this.x += b.x;
        this.y += b.y;
        this.z += b.z;
        return this;
    }

    public void addVelocities(Entity e) {
        e.func_70024_g(this.x, this.y, this.z);
    }

    public List<Entity> allEntityLocationExcluding(int range, double size, Vector3 direction, Vector3 source, World world, Entity excluded) {
        direction = direction.normalize();
        ArrayList<Entity> ret = new ArrayList<Entity>();
        Predicate<Entity> predicate = e -> e != excluded;
        predicate = predicate.and(EntityPredicates.field_180132_d);
        double ds = range;
        Vector3d vec3 = source.toVec3d();
        Vector3d vec31 = direction.toVec3d();
        Vector3d vec32 = vec3.func_72441_c(vec31.field_72450_a * ds, vec31.field_72448_b * ds, vec31.field_72449_c * ds);
        float f = 0.5f;
        AxisAlignedBB aabb = this.getAABB().func_72321_a(vec31.field_72450_a * ds, vec31.field_72448_b * ds, vec31.field_72449_c * ds).func_72314_b(0.5, 0.5, 0.5);
        List mobs = world.func_175674_a(excluded, aabb, predicate);
        ICompoundMob.ICompoundPart[] parts = null;
        block0: for (Entity entity1 : mobs) {
            if (entity1 instanceof ICompoundMob && (parts = ((ICompoundMob)entity1).getParts()).length > 0) {
                for (ICompoundMob.ICompoundPart part : parts) {
                    AxisAlignedBB axisalignedbb = part.getMob().func_174813_aQ().func_186662_g((double)0.3f);
                    Optional optional = axisalignedbb.func_216365_b(vec3, vec32);
                    if (!optional.isPresent()) continue;
                    ret.add(entity1);
                    continue block0;
                }
                continue;
            }
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f);
            Optional optional = axisalignedbb.func_216365_b(vec3, vec32);
            if (!optional.isPresent()) continue;
            ret.add(entity1);
        }
        return ret;
    }

    public List<Entity> allEntityLocationExcluding(int range, double size, Vector3 direction, Vector3 source, World world, Entity excluded, Predicate<Entity> predicate) {
        direction = direction.normalize();
        ArrayList<Entity> ret = new ArrayList<Entity>();
        if (predicate == null) {
            predicate = EntityPredicates.field_180132_d;
        }
        double ds = range;
        Vector3d vec3 = source.toVec3d();
        Vector3d vec31 = direction.toVec3d();
        Vector3d vec32 = vec3.func_72441_c(vec31.field_72450_a * ds, vec31.field_72448_b * ds, vec31.field_72449_c * ds);
        float f = 1.0f;
        AxisAlignedBB aabb = this.getAABB().func_72321_a(vec31.field_72450_a * ds, vec31.field_72448_b * ds, vec31.field_72449_c * ds).func_72314_b(1.0, 1.0, 1.0);
        List mobs = world.func_175674_a(excluded, aabb, predicate);
        ICompoundMob.ICompoundPart[] parts = null;
        block0: for (Entity entity1 : mobs) {
            if (entity1 instanceof ICompoundMob && (parts = ((ICompoundMob)entity1).getParts()).length > 0) {
                for (ICompoundMob.ICompoundPart part : parts) {
                    AxisAlignedBB axisalignedbb = part.getMob().func_174813_aQ().func_186662_g(size);
                    Optional optional = axisalignedbb.func_216365_b(vec3, vec32);
                    if (!optional.isPresent()) continue;
                    ret.add(entity1);
                    continue block0;
                }
                continue;
            }
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g(size);
            Optional optional = axisalignedbb.func_216365_b(vec3, vec32);
            if (!optional.isPresent()) continue;
            ret.add(entity1);
        }
        return ret;
    }

    public int blockCount(IBlockReader world, Block block, int range) {
        int ret = 0;
        Vector3 v = this.copy();
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    Vector3 test = v.set(this).addTo(i, j, k);
                    if (test.getBlock(world) != block) continue;
                    ++ret;
                }
            }
        }
        return ret;
    }

    public int blockCount2(IWorld world, Block block, int range) {
        int ret = 0;
        Vector3 v = this.copy();
        IChunk chunk = world.func_217349_x(new BlockPos(this.intX(), 0, this.intZ()));
        for (int i = -range / 2; i <= range / 2; ++i) {
            for (int j = -range / 2; j <= range / 2; ++j) {
                for (int k = -range / 2; k <= range / 2; ++k) {
                    int i1 = MathHelper.func_76128_c((double)((double)this.intX() / 16.0));
                    int k1 = MathHelper.func_76128_c((double)((double)this.intZ() / 16.0));
                    int j1 = MathHelper.func_76128_c((double)((double)this.intY() / 16.0));
                    int i2 = MathHelper.func_76128_c((double)((double)(this.intX() + i) / 16.0));
                    int k2 = MathHelper.func_76128_c((double)((double)(this.intZ() + k) / 16.0));
                    int j2 = MathHelper.func_76128_c((double)((double)(this.intY() + j) / 16.0));
                    if (i1 != i2 || k1 != k2 || j1 != j2) continue;
                    v.set(this);
                    Vector3 test = v.addTo(i, j, k);
                    Block testBlock = chunk.func_180495_p(test.getPos()).func_177230_c();
                    if (testBlock != block) continue;
                    ++ret;
                }
            }
        }
        return ret;
    }

    public void breakBlock(World world, boolean drops) {
        world.func_175655_b(this.getPos(), drops);
    }

    public boolean canSeeSky(IWorld world) {
        if (world.func_226660_f_(this.getPos())) {
            return true;
        }
        return (double)world.func_201676_a(Heightmap.Type.OCEAN_FLOOR, this.intX(), this.intZ()) <= this.y;
    }

    public Vector3 clear() {
        return this.set(0.0, 0.0, 0.0);
    }

    public Vector3 copy() {
        Vector3 newVector = Vector3.getNewVector().set(this.x, this.y, this.z);
        return newVector;
    }

    public double distanceTo(Vector3 vec) {
        return this.subtract(vec).mag();
    }

    public double distTo(Vector3 pointB) {
        return this.subtract(pointB).mag();
    }

    public double distToEntity(Entity e) {
        return this.distanceTo(Vector3.entity(e));
    }

    public double distToSq(Vector3 pointB) {
        return this.subtract(pointB).magSq();
    }

    public double dot(Vector3 vector2) {
        double dot = 0.0;
        for (int i = 0; i < 3; ++i) {
            dot += this.get(i) * vector2.get(i);
        }
        return dot;
    }

    public boolean equals(Object vec) {
        if (!(vec instanceof Vector3)) {
            return false;
        }
        Vector3 v = (Vector3)vec;
        return v.x == this.x && v.y == this.y && v.z == this.z;
    }

    public Vector3 findClosestVisibleObject(IBlockReader world, boolean water, int sightDistance, Object matching) {
        int size = Math.min(sightDistance, 30);
        ArrayList list = new ArrayList();
        Block seekingBlock = null;
        Class seekingClass = null;
        boolean predicate = matching instanceof Predicate;
        Predicate matcher = null;
        if (predicate) {
            matcher = (Predicate)matching;
        }
        boolean isInterface = false;
        boolean blockList = false;
        boolean predicateList = false;
        Vector3 temp = Vector3.getNewVector();
        if (matching instanceof Block) {
            seekingBlock = (Block)matching;
        }
        if (matching instanceof Class && (seekingClass = (Class)matching).isInterface()) {
            isInterface = true;
        }
        if (matching instanceof Collection && !((Collection)matching).isEmpty()) {
            if (matching instanceof Collection && ((Collection)matching).toArray()[0] instanceof Block) {
                blockList = true;
                list.addAll((Collection)matching);
            }
            if (matching instanceof Collection && ((Collection)matching).toArray()[0] instanceof Predicate) {
                predicateList = true;
                list.addAll((Collection)matching);
            }
        }
        Vector3 r = Vector3.getNewVector();
        Vector3 rAbs = Vector3.getNewVector();
        Vector3 rHat = Vector3.getNewVector();
        Vector3 rTest = Vector3.getNewVector();
        Vector3 rTestPrev = Vector3.getNewVector();
        Vector3 rTestAbs = Vector3.getNewVector();
        Vector3 ret = Vector3.getNewVector();
        HashMap interfaces = new HashMap();
        block0: for (int i = 0; i < size * size * size; ++i) {
            Cruncher.indexToVals(i, r);
            rAbs.set(r).addTo(this);
            rHat.set(temp.set(r).norm());
            double rm = r.mag();
            if (rm > (double)size || rm > (double)sightDistance || rAbs.isAir(world) && !r.isEmpty()) continue;
            rTest.clear();
            rTestPrev.clear();
            double rMag = r.mag();
            float dj = 1.0f;
            float j = 0.0f;
            while ((double)j <= rMag) {
                rTest = temp.set(rHat).scalarMultBy(j);
                if (!rTest.sameBlock(rTestPrev)) {
                    rTestAbs.set(rTest).addTo(this);
                    BlockState state = rTestAbs.getBlockState(world);
                    if (state == null) continue block0;
                    Block b = state.func_177230_c();
                    if (predicateList) {
                        for (Object o : list) {
                            if (!((Predicate)o).test(state)) continue;
                            ret.set(rTestAbs);
                            return ret;
                        }
                    }
                    if (isInterface) {
                        ArrayList tempList = (ArrayList)interfaces.get(b.getClass());
                        if (tempList == null) {
                            tempList = new ArrayList();
                            interfaces.put(b.getClass(), tempList);
                            for (Class<?> o : b.getClass().getInterfaces()) {
                                tempList.add(o);
                            }
                        }
                        list = tempList;
                    }
                    if (matcher != null && matcher.test(state)) {
                        ret.set(rTestAbs);
                        return ret;
                    }
                    if (seekingBlock != null && b == seekingBlock) {
                        ret.set(rTestAbs);
                        return ret;
                    }
                    if (!isInterface && seekingClass != null && b.getClass().isAssignableFrom(seekingClass)) {
                        ret.set(rTestAbs);
                        return ret;
                    }
                    if (seekingClass != null && list.contains(seekingClass)) {
                        ret.set(rTestAbs);
                        return ret;
                    }
                    if (blockList && list.contains(b)) {
                        ret.set(rTestAbs);
                        return ret;
                    }
                    if (!rTestAbs.isClearOfBlocks(world) || !water && state.func_185904_a() == Material.field_151586_h) continue block0;
                }
                j += 1.0f;
            }
        }
        return null;
    }

    public Vector3 findNextSolidBlock(IBlockReader world, Vector3 direction, double range) {
        return Vector3.findNextSolidBlock(world, this, direction, range);
    }

    public Entity firstEntityExcluding(double range, Vector3d vec31, World world, Entity entity, Predicate<Entity> predicate) {
        Entity pointedEntity = null;
        if (predicate == null) {
            predicate = EntityPredicates.field_180132_d;
        }
        double ds = range;
        Vector3d vec3 = this.toVec3d();
        Vector3d vec32 = vec3.func_72441_c(vec31.field_72450_a * ds, vec31.field_72448_b * ds, vec31.field_72449_c * ds);
        float f = 2.5f;
        AxisAlignedBB aabb = this.getAABB().func_72321_a(vec31.field_72450_a * ds, vec31.field_72448_b * ds, vec31.field_72449_c * ds).func_72314_b(2.5, 2.5, 2.5);
        List mobs = world.func_175674_a(entity, aabb, predicate);
        ds *= ds;
        ICompoundMob.ICompoundPart[] parts = null;
        block0: for (Entity entity1 : mobs) {
            double d1;
            if (entity1 instanceof ICompoundMob && (parts = ((ICompoundMob)entity1).getParts()).length > 0) {
                for (ICompoundMob.ICompoundPart part : parts) {
                    double d12;
                    AxisAlignedBB axisalignedbb = part.getMob().func_174813_aQ().func_186662_g((double)0.3f);
                    Optional optional = axisalignedbb.func_216365_b(vec3, vec32);
                    if (!optional.isPresent() || !((d12 = vec3.func_72436_e((Vector3d)optional.get())) < ds)) continue;
                    pointedEntity = entity1;
                    ds = d12;
                    continue block0;
                }
                continue;
            }
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f);
            Optional optional = axisalignedbb.func_216365_b(vec3, vec32);
            if (!optional.isPresent() || !((d1 = vec3.func_72436_e((Vector3d)optional.get())) < ds)) continue;
            pointedEntity = entity1;
            ds = d1;
        }
        return pointedEntity;
    }

    public Vector3d toVec3d() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public List<Entity> firstEntityLocationExcluding(int range, double size, Vector3 direction, Vector3 source, World world, Entity excluded) {
        double dz;
        double ztest;
        double dy;
        double ytest;
        double dx;
        double xtest;
        boolean check;
        direction = direction.normalize();
        for (double i = 0.0; i < (double)range && (check = Vector3.isPointClearBlocks(xtest = source.x + (dx = i * direction.x), ytest = source.y + (dy = i * direction.y), ztest = source.z + (dz = i * direction.z), (IBlockReader)world)); i += 0.0625) {
            double z0;
            double y0;
            double x0 = xtest > 0.0 ? (double)((int)xtest) : (double)((int)xtest - 1);
            List targets = world.func_72839_b(excluded, new AxisAlignedBB(x0 - size, (y0 = ytest > 0.0 ? (double)((int)ytest) : (double)((int)ytest - 1)) - size, (z0 = ztest > 0.0 ? (double)((int)ztest) : (double)((int)ztest - 1)) - size, x0 + size, y0 + size, z0 + size));
            if (targets == null || targets.size() <= 0) continue;
            ArrayList<Entity> ret = new ArrayList<Entity>();
            for (Entity e : targets) {
                if (!(e instanceof MobEntity)) continue;
                ret.add(e);
            }
            if (ret.size() <= 0) continue;
            return ret;
        }
        return null;
    }

    public double get(int i) {
        assert (i < 3);
        return i == 0 ? this.x : (i == 1 ? this.y : this.z);
    }

    public AxisAlignedBB getAABB() {
        return Matrix3.getAABB(this.x, this.y, this.z, this.x, this.y, this.z);
    }

    public Biome getBiome(IWorld world) {
        return world.func_226691_t_(new BlockPos(this.intX(), 0, this.intZ()));
    }

    public Block getBlock(IBlockReader worldMap) {
        BlockState state = worldMap.func_180495_p(this.getPos());
        if (state == null) {
            return Blocks.field_150350_a;
        }
        return state.func_177230_c();
    }

    public Block getBlock(IBlockReader world, Direction side) {
        Vector3 other = this.offset(side);
        Block ret = other.getBlock(world);
        return ret;
    }

    public Material getBlockMaterial(IBlockReader world) {
        BlockState state = world.func_180495_p(this.getPos());
        if (state == null || state.func_177230_c() == null) {
            return Material.field_151579_a;
        }
        return state.func_185904_a();
    }

    public BlockState getBlockState(IBlockReader world) {
        return world.func_180495_p(this.getPos());
    }

    public float getExplosionResistance(Explosion boom, IWorldReader world) {
        BlockState state = this.getBlockState((IBlockReader)world);
        if (state == null || state.func_177230_c().isAir(state, (IBlockReader)world, this.getPos())) {
            return 0.0f;
        }
        float res = state.getExplosionResistance((IBlockReader)world, (BlockPos)this.pos, boom);
        return res;
    }

    public int getLightValue(World world) {
        return world.func_201696_r(this.getPos());
    }

    public int getMaxY(IWorld world) {
        return this.getMaxY(world, this.intX(), this.intZ());
    }

    public int getMaxY(IWorld world, int x, int z) {
        IChunk chunk = world.func_217349_x(this.getPos());
        int y1 = chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR, this.intX() & 0xF, this.intZ() & 0xF);
        int y2 = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, this.intX() & 0xF, this.intZ() & 0xF);
        return Math.min(y1, y2);
    }

    public int[] getMinMaxY(World world, int range) {
        int[] ret = new int[2];
        int minY = 255;
        int maxY = 0;
        for (int i = 0; i < range; ++i) {
            for (int j = 0; j < range; ++j) {
                if (this.getMaxY((IWorld)world, this.intX() + i, this.intZ() + j) < minY) {
                    minY = this.getMaxY((IWorld)world, this.intX() + i, this.intZ() + j);
                }
                if (this.getMaxY((IWorld)world, this.intX() + i, this.intZ() + j) <= maxY) continue;
                maxY = this.getMaxY((IWorld)world, this.intX() + i, this.intZ() + j);
            }
        }
        ret[0] = minY;
        ret[1] = maxY;
        return ret;
    }

    public BlockPos getPos() {
        if (this.pos == null) {
            this.pos = new MutableBlockPos(this.intX(), this.intY(), this.intZ());
        } else {
            this.pos.setTo(this);
        }
        return this.pos;
    }

    public TileEntity getTileEntity(IBlockReader world) {
        return world.func_175625_s(this.getPos());
    }

    public TileEntity getTileEntity(IBlockReader world, Direction side) {
        Vector3 other = this.offset(side);
        TileEntity ret = other.getTileEntity(world);
        return ret;
    }

    public Vector3 getTopBlockPos(World world) {
        int y = this.getTopBlockY((IBlockReader)world);
        return Vector3.getNewVector().set(this.intX(), y, this.intZ());
    }

    public int getTopBlockY(IBlockReader world) {
        int ret = 255;
        for (ret = 255; ret > 1; --ret) {
            BlockState state = world.func_180495_p(new BlockPos(this.intX(), ret, this.intZ()));
            if (state == null || !state.func_185904_a().func_76220_a()) continue;
            return ret;
        }
        return ret;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Vector3 horizonalPerp() {
        Vector3 vectorH = Vector3.getNewVector().set(-this.z, 0.0, this.x);
        return vectorH.norm();
    }

    public boolean inAABB(AxisAlignedBB aabb) {
        if (this.y >= aabb.field_72337_e || this.y <= aabb.field_72338_b) {
            return false;
        }
        if (this.z >= aabb.field_72334_f || this.z <= aabb.field_72339_c) {
            return false;
        }
        return !(this.x >= aabb.field_72336_d) && !(this.x <= aabb.field_72340_a);
    }

    public boolean inMatBox(Matrix3 box) {
        Vector3 min = box.get(0);
        Vector3 max = box.get(1);
        boolean ycheck = false;
        boolean xcheck = false;
        boolean zcheck = false;
        if (this.y <= max.y && this.y >= min.y) {
            ycheck = true;
        }
        if (this.z <= max.z && this.z >= min.z) {
            zcheck = true;
        }
        if (this.x <= max.x && this.x >= min.x) {
            xcheck = true;
        }
        return ycheck && zcheck && xcheck;
    }

    public int intX() {
        return MathHelper.func_76128_c((double)this.x);
    }

    public int intY() {
        return MathHelper.func_76128_c((double)this.y);
    }

    public int intZ() {
        return MathHelper.func_76128_c((double)this.z);
    }

    public boolean isAir(IBlockReader world) {
        if (world instanceof World) {
            Material m;
            BlockState state = world.func_180495_p(this.getPos());
            return state.func_177230_c() == null || (m = this.getBlockMaterial(world)) == null || m == Material.field_151579_a || state.func_177230_c().isAir(state, world, this.getPos());
        }
        Material m = this.getBlockMaterial(world);
        return m == null || m == Material.field_151579_a;
    }

    public boolean isClearOfBlocks(IBlockReader world) {
        boolean ret = false;
        BlockState state = world.func_180495_p(this.getPos());
        if (state == null) {
            return true;
        }
        ret = this.isAir(world);
        if (!ret) {
            boolean bl = ret = ret || this.getBlockMaterial(world).func_76224_d();
        }
        if (!ret) {
            boolean bl = ret = ret || this.getBlockMaterial(world).func_76222_j();
        }
        if (!ret) {
            boolean bl = ret = ret || !this.getBlockMaterial(world).func_76230_c();
        }
        if (!ret) {
            VoxelShape shape = state.func_196952_d(world, this.getPos());
            List aabbs = shape.func_197756_d();
            if (aabbs.size() == 0) {
                return true;
            }
            for (AxisAlignedBB aabb : aabbs) {
                if (aabb == null || !aabb.func_197744_e(this.x - (double)this.intX(), this.y - (double)this.intY(), this.z - (double)this.intZ())) continue;
                return false;
            }
            return true;
        }
        return ret;
    }

    public boolean isEmpty() {
        return this.x == 0.0 && this.z == 0.0 && this.y == 0.0;
    }

    public boolean isEntityClearOfBlocks(IBlockReader world, Entity e) {
        int j;
        int i;
        boolean ret = false;
        EntitySize size = e.func_213305_a(e.func_213283_Z());
        Vector3 v = Vector3.getNewVector();
        Vector3 v1 = Vector3.getNewVector();
        v.set(this);
        ret = v.addTo(v1.set(0.0, size.field_220316_b, 0.0)).isClearOfBlocks(world);
        if (!ret) {
            return ret;
        }
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                ret = ret && v.set(this).addTo(v1.set((float)i * size.field_220315_a / 2.0f, 0.0, (float)j * size.field_220315_a / 2.0f)).isClearOfBlocks(world);
            }
        }
        if (!ret) {
            return ret;
        }
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                ret = ret && v.set(this).addTo(v1.set((float)i * size.field_220315_a / 2.0f, size.field_220316_b, (float)j * size.field_220315_a / 2.0f)).isClearOfBlocks(world);
            }
        }
        return ret;
    }

    public boolean isFluid(World world) {
        return !world.func_204610_c(this.getPos()).func_206888_e();
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.z) || Double.isNaN(this.y);
    }

    public boolean isOnSurface(Chunk chunk) {
        return (double)chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, this.intX() & 0xF, this.intZ() & 0xF) <= this.y;
    }

    public boolean isOnSurface(World world) {
        return (double)this.getMaxY((IWorld)world) <= this.y;
    }

    public boolean isOnSurfaceIgnoringDecorationAndWater(Chunk chunk, IBlockReader world) {
        int h = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, this.intX() & 0xF, this.intZ() & 0xF);
        return (double)h <= this.y;
    }

    public boolean isPointClearOfEntity(double x, double y, double z, Entity e) {
        AxisAlignedBB aabb = e.func_174813_aQ();
        if (y <= aabb.field_72337_e && y >= aabb.field_72338_b) {
            return false;
        }
        if (z <= aabb.field_72334_f && z >= aabb.field_72339_c) {
            return false;
        }
        return !(x <= aabb.field_72336_d) || !(x >= aabb.field_72340_a);
    }

    public boolean isVisible(IBlockReader world, Vector3 location) {
        Vector3 direction = location.subtract(this);
        double range = direction.mag();
        return Vector3.isVisibleRange(world, this, direction, range);
    }

    public List<Entity> livingEntityAtPoint(World world) {
        int x0 = this.intX();
        int y0 = this.intY();
        int z0 = this.intZ();
        ArrayList<Entity> ret = new ArrayList<Entity>();
        List targets = world.func_217357_a(MobEntity.class, new AxisAlignedBB((double)x0, (double)y0, (double)z0, (double)(x0 + 1), (double)(y0 + 1), (double)(z0 + 1)));
        for (Entity e : targets) {
            if (this.isPointClearOfEntity(this.x, this.y, this.z, e)) continue;
            ret.add(e);
        }
        return ret;
    }

    public List<Entity> livingEntityAtPointExcludingEntity(World world, Entity entity) {
        int x0 = this.intX();
        int y0 = this.intY();
        int z0 = this.intZ();
        ArrayList<Entity> ret = new ArrayList<Entity>();
        List targets = world.func_217357_a(MobEntity.class, new AxisAlignedBB((double)x0, (double)y0, (double)z0, (double)(x0 + 1), (double)(y0 + 1), (double)(z0 + 1)));
        for (Entity e : targets) {
            if (this.isPointClearOfEntity(this.x, this.y, this.z, e) || e == entity) continue;
            ret.add(e);
        }
        return ret;
    }

    public double mag() {
        double vmag = Math.sqrt(this.magSq());
        return vmag;
    }

    public double magSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 matrixMult(Matrix3 Matrix2) {
        Vector3 newVect = vecMult.clear();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                newVect.add(i, Matrix2.get(i).get(j) * this.get(j));
            }
        }
        return newVect;
    }

    public void moveEntity(Entity e) {
        e.func_70107_b(this.x, this.y, this.z);
    }

    public Vector3 norm() {
        double vmag = this.mag();
        if (vmag == 0.0) {
            return this.clear();
        }
        this.scalarMultBy(1.0 / vmag);
        return this;
    }

    public Vector3 normalize() {
        double vmag = this.mag();
        Vector3 vHat = Vector3.getNewVector();
        if (vmag == 0.0) {
            return vHat.clear();
        }
        vHat.set(this).scalarMultBy(1.0 / vmag);
        return vHat;
    }

    public Vector3 offset(Direction side) {
        return this.add(Vector3.getNewVector().set(side));
    }

    public Vector3 offsetBy(Direction side) {
        return this.addTo(side.func_82601_c(), side.func_96559_d(), side.func_82599_e());
    }

    public Vector3 reverse() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3 rotateAboutAngles(double pitch, double yaw, Vector3 temp, Vector3 temp1) {
        if (this.isEmpty() || pitch == 0.0 && yaw == 0.0) {
            return this;
        }
        temp.set(this);
        if (yaw != 0.0) {
            this.rotateAboutLine(secondAxis, yaw, temp);
        }
        if (pitch != 0.0) {
            this.rotateAboutLine(this.horizonalPerp(), pitch, temp);
        }
        if (temp.isNaN()) {
            return temp.clear();
        }
        return temp;
    }

    public Vector3 rotateAboutLine(Vector3 line, double angle, Vector3 ret) {
        if (line.magSq() != 1.0) {
            line = line.normalize();
        }
        if (ret == null) {
            ret = Vector3.getNewVector();
        }
        double[][] mat = rotBox;
        mat[0][0] = line.get(0) * line.get(0) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + (double)MathHelper.func_76134_b((float)((float)angle));
        mat[0][1] = line.get(0) * line.get(1) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) - line.get(2) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[0][2] = line.get(0) * line.get(2) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + line.get(1) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[1][0] = line.get(1) * line.get(0) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + line.get(2) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[1][1] = line.get(1) * line.get(1) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + (double)MathHelper.func_76134_b((float)((float)angle));
        mat[1][2] = line.get(1) * line.get(2) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) - line.get(0) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[2][0] = line.get(2) * line.get(0) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) - line.get(1) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[2][1] = line.get(2) * line.get(1) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + line.get(0) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[2][2] = line.get(2) * line.get(2) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + (double)MathHelper.func_76134_b((float)((float)angle));
        ret.x = mat[0][0] * this.x + mat[0][1] * this.y + mat[0][2] * this.z;
        ret.y = mat[1][0] * this.x + mat[1][1] * this.y + mat[1][2] * this.z;
        ret.z = mat[2][0] * this.x + mat[2][1] * this.y + mat[2][2] * this.z;
        return ret;
    }

    public boolean sameBlock(Vector3 vec) {
        return this.intX() == vec.intX() && this.intY() == vec.intY() && this.intZ() == vec.intZ();
    }

    public Vector3 scalarMult(double constant) {
        Vector3 newVector = Vector3.getNewVector();
        for (int i = 0; i < 3; ++i) {
            newVector.set(i, constant * this.get(i));
        }
        return newVector;
    }

    public Vector3 scalarMultBy(double i) {
        this.x *= i;
        this.y *= i;
        this.z *= i;
        return this;
    }

    public Vector3 set(Direction dir) {
        this.x = dir.func_82601_c();
        this.y = dir.func_96559_d();
        this.z = dir.func_82599_e();
        return this;
    }

    public Vector3 set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3 set(double[] vec) {
        this.x = vec[0];
        this.y = vec[1];
        this.z = vec[2];
        return this;
    }

    public Vector3 set(Entity e, boolean b) {
        if (e != null && b) {
            this.x = e.func_226277_ct_();
            this.y = e.func_226278_cu_() + (double)(e.func_213302_cg() / 2.0f);
            this.z = e.func_226281_cx_();
        } else if (e != null) {
            this.x = e.func_226277_ct_();
            this.y = e.func_226278_cu_() + (double)e.func_70047_e();
            this.z = e.func_226281_cx_();
        }
        return this;
    }

    public void set(int i, double j) {
        if (i == 0) {
            this.x = j;
        } else if (i == 1) {
            this.y = j;
        } else if (i == 2) {
            this.z = j;
        }
    }

    public Vector3 set(Object o) {
        if (o instanceof Entity) {
            Entity e = (Entity)o;
            this.set(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
        } else if (o instanceof TileEntity) {
            TileEntity te = (TileEntity)o;
            this.set(te.func_174877_v());
        } else if (o instanceof double[]) {
            double[] d = (double[])o;
            this.set(d[0], d[1], d[2]);
        } else if (o instanceof Direction) {
            Direction side = (Direction)o;
            this.set(side.func_82601_c(), side.func_96559_d(), side.func_82599_e());
        } else if (o instanceof Vector3) {
            this.set((Vector3)o);
        } else if (o instanceof BlockPos) {
            BlockPos c = (BlockPos)o;
            this.set(c.func_177958_n(), c.func_177956_o(), c.func_177952_p());
        } else if (o instanceof PathPoint) {
            PathPoint p = (PathPoint)o;
            this.set(p.field_75839_a, p.field_75837_b, p.field_75838_c);
        } else if (o instanceof Vector3d) {
            Vector3d p = (Vector3d)o;
            this.set(p.field_72450_a, p.field_72448_b, p.field_72449_c);
        } else if (o instanceof int[]) {
            int[] p = (int[])o;
            this.set(p[0], p[1], p[2]);
        } else if (o instanceof byte[]) {
            byte[] p = (byte[])o;
            this.set(p[0], p[1], p[2]);
        } else if (o instanceof short[]) {
            short[] p = (short[])o;
            this.set(p[0], p[1], p[2]);
        } else if (o instanceof Double) {
            this.y = this.z = ((Double)o).doubleValue();
            this.x = this.z;
        }
        return this;
    }

    public Vector3 set(Vector3 vec) {
        if (vec != null) {
            this.x = vec.x;
            this.y = vec.y;
            this.z = vec.z;
        }
        return this;
    }

    public void setAir(World world) {
        world.func_175656_a(this.getPos(), Blocks.field_150350_a.func_176223_P());
    }

    public void setBiome(Biome biome, World world) {
        int x = this.intX();
        int z = this.intZ();
        IChunk chunk = world.func_217349_x(new BlockPos(x, 0, z));
        BiomeContainer biomes = chunk.func_225549_i_();
        int i = x & BiomeContainer.field_227050_b_;
        int j = (int)MathHelper.func_151237_a((double)this.y, (double)0.0, (double)BiomeContainer.field_227051_c_);
        int k = z & BiomeContainer.field_227050_b_;
        int index = j << BiomeContainer.field_227052_d_ + BiomeContainer.field_227052_d_ | k << BiomeContainer.field_227052_d_ | i;
        biomes.field_227054_f_[index] = biome;
    }

    public void setBlock(World world, BlockState defaultState) {
        world.func_175656_a(this.getPos(), defaultState);
    }

    public Vector3 setToVelocity(Entity e) {
        this.set(e.func_213322_ci());
        return this;
    }

    public void setVelocities(Entity e) {
        e.func_213293_j(this.x, this.y, this.z);
    }

    public Vector3 subtract(Vector3 vectorB) {
        Vector3 vectorC = Vector3.getNewVector();
        for (int i = 0; i < 3; ++i) {
            vectorC.set(i, this.get(i) - vectorB.get(i));
        }
        return vectorC;
    }

    public Vector3 subtractFrom(Vector3 b) {
        if (b == null) {
            return this;
        }
        this.x -= b.x;
        this.y -= b.y;
        this.z -= b.z;
        return this;
    }

    public Vector3 toSpherical() {
        Vector3 vectorSpher = Vector3.getNewVector();
        vectorSpher.x = this.mag();
        vectorSpher.y = Math.acos(this.get(1) / vectorSpher.x) - 1.5707963267948966;
        vectorSpher.z = Math.atan2(this.get(2), this.x);
        return vectorSpher;
    }

    public String toString() {
        return "x:" + this.x + " y:" + this.y + " z:" + this.z;
    }

    public void writeToBuff(ByteBuf data) {
        data.writeDouble(this.x);
        data.writeDouble(this.y);
        data.writeDouble(this.z);
    }

    public void writeToNBT(CompoundNBT nbt, String tag) {
        nbt.func_74780_a(tag + "x", this.x);
        nbt.func_74780_a(tag + "y", this.y);
        nbt.func_74780_a(tag + "z", this.z);
    }

    public static final class MutableBlockPos
    extends BlockPos {
        public int field_177962_a;
        public int field_177960_b;
        public int field_177961_c;

        public MutableBlockPos(int x_, int y_, int z_) {
            super(0, 0, 0);
            this.field_177962_a = x_;
            this.field_177960_b = y_;
            this.field_177961_c = z_;
        }

        MutableBlockPos(int p_i46025_1_, int p_i46025_2_, int p_i46025_3_, Object p_i46025_4_) {
            this(p_i46025_1_, p_i46025_2_, p_i46025_3_);
        }

        public int func_177958_n() {
            return this.field_177962_a;
        }

        public int func_177956_o() {
            return this.field_177960_b;
        }

        public int func_177952_p() {
            return this.field_177961_c;
        }

        void setTo(Vector3 vector) {
            this.field_177962_a = vector.intX();
            this.field_177960_b = vector.intY();
            this.field_177961_c = vector.intZ();
        }

        public void set(int x0, int y0, int z0) {
            this.field_177962_a = x0;
            this.field_177960_b = y0;
            this.field_177961_c = z0;
        }

        public BlockPos func_185334_h() {
            return new BlockPos((Vector3i)this);
        }
    }
}

