/*
 * Decompiled with CFR 0.152.
 */
package thut.api.maths;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Vector4 {
    public float x;
    public float y;
    public float z;
    public float w;
    @OnlyIn(value=Dist.CLIENT)
    private Quaternion quat;

    public static Vector4 fromAngles(float x, float y, float z) {
        Vector4 angle = null;
        if (z != 0.0f) {
            angle = new Vector4(0.0, 0.0, 1.0, z);
        }
        if (x != 0.0f) {
            angle = angle != null ? angle.addAngles(new Vector4(1.0, 0.0, 0.0, x)) : new Vector4(1.0, 0.0, 0.0, x);
        }
        if (y != 0.0f) {
            angle = angle != null ? angle.addAngles(new Vector4(0.0, 1.0, 0.0, y)) : new Vector4(0.0, 1.0, 0.0, y);
        }
        if (angle == null) {
            angle = new Vector4();
        }
        return angle;
    }

    public Vector4() {
        this.x = 0.0f;
        this.z = 0.0f;
        this.y = 0.0f;
        this.w = 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector4(Quaternion quat) {
        this(quat.func_195889_a(), quat.func_195891_b(), quat.func_195893_c(), quat.func_195894_d());
        this.quat = quat;
    }

    public Vector4(CompoundNBT nbt) {
        this();
        this.x = nbt.func_74760_g("x");
        this.y = nbt.func_74760_g("y");
        this.z = nbt.func_74760_g("z");
        this.w = nbt.func_74760_g("w");
    }

    public Vector4(double posX, double posY, double posZ, float w) {
        this.x = (float)posX;
        this.y = (float)posY;
        this.z = (float)posZ;
        this.w = w;
    }

    public Vector4(Entity e) {
        this(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), 0.0f);
    }

    public Vector4(String toParse) {
        String[] vals = toParse.split(" ");
        if (vals.length == 4) {
            this.x = Float.parseFloat(vals[0]);
            this.y = Float.parseFloat(vals[1]);
            this.z = Float.parseFloat(vals[2]);
            this.w = Float.parseFloat(vals[3]);
        }
    }

    public Vector4 add(Vector4 b) {
        Vector4 quat = new Vector4();
        quat.w = this.w + b.w;
        quat.x = this.x + b.x;
        quat.y = this.y + b.y;
        quat.z = this.z + b.z;
        return quat;
    }

    public Vector4 addAngles(Vector4 toAdd) {
        Vector4 ret = this.copy();
        Vector4 temp = toAdd.copy();
        if (Float.isNaN(temp.x) || Float.isNaN(temp.y) || Float.isNaN(temp.z) || Float.isNaN(temp.w)) {
            System.out.println(temp + " " + toAdd);
            new Exception().printStackTrace();
            temp.x = 0.0f;
            temp.y = 0.0f;
            temp.z = 0.0f;
            temp.w = 1.0f;
        }
        temp.toQuaternion();
        ret.toQuaternion();
        ret.mul(ret.copy(), temp);
        return ret.toAxisAngle();
    }

    public Vector4 copy() {
        return new Vector4(this.x, this.y, this.z, this.w);
    }

    public boolean equals(Object o) {
        if (o instanceof Vector4) {
            Vector4 v = (Vector4)o;
            return v.x == this.x && v.y == this.y && v.z == this.z && v.w == this.w;
        }
        return super.equals(o);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void glRotate(MatrixStack mat) {
        mat.func_227863_a_(this.toMCQ());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void glUnRotate(MatrixStack mat) {
        mat.func_227863_a_(this.toMCQInv());
    }

    public boolean isEmpty() {
        return this.x == 0.0f && this.z == 0.0f && this.y == 0.0f;
    }

    public final void mul(Vector4 q1, Vector4 q2) {
        this.x = q1.x * q2.w + q1.y * q2.z - q1.z * q2.y + q1.w * q2.x;
        this.y = -q1.x * q2.z + q1.y * q2.w + q1.z * q2.x + q1.w * q2.y;
        this.z = q1.x * q2.y - q1.y * q2.x + q1.z * q2.w + q1.w * q2.z;
        this.w = -q1.x * q2.x - q1.y * q2.y - q1.z * q2.z + q1.w * q2.w;
    }

    public Vector4 normalize() {
        float s = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        s = (float)Math.sqrt(s);
        this.x /= s;
        this.y /= s;
        this.z /= s;
        this.w /= s;
        return this;
    }

    public Vector4 scalarMult(float scalar) {
        Vector4 ret = new Vector4(this.x, this.y, this.z, this.w);
        ret.w = this.w * scalar;
        return ret;
    }

    public Vector4 set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        this.quat = null;
        return this;
    }

    public Vector4 subtractAngles(Vector4 toAdd) {
        Vector4 temp = new Vector4(toAdd.x, toAdd.y, toAdd.z, -toAdd.w);
        return this.addAngles(temp);
    }

    public Vector4 toAxisAngle() {
        float qw = this.w;
        float qx = this.x;
        float qy = this.y;
        float qz = this.z;
        if (this.w == 0.0f) {
            this.x = 1.0f;
            this.y = 0.0f;
            this.z = 0.0f;
            return this;
        }
        this.w = (float)Math.toDegrees(2.0 * Math.acos(qw));
        float s = (float)Math.sqrt(1.0f - qw * qw);
        if (s == 0.0f) {
            // empty if block
        }
        if (s > 0.001f) {
            this.x = qx / s;
            this.y = qy / s;
            this.z = qz / s;
        }
        float rad = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x /= rad;
        this.y /= rad;
        this.z /= rad;
        return this;
    }

    public String toIntString() {
        return "x:" + MathHelper.func_76141_d((float)this.x) + " y:" + MathHelper.func_76141_d((float)this.y) + " z:" + MathHelper.func_76141_d((float)this.z) + " w:" + MathHelper.func_76141_d((float)this.w);
    }

    public Vector4 toQuaternion() {
        double a = Math.toRadians(this.w);
        float ax = this.x;
        float ay = this.y;
        float az = this.z;
        this.w = (float)Math.cos(a / 2.0);
        this.x = (float)((double)ax * Math.sin(a / 2.0));
        this.y = (float)((double)ay * Math.sin(a / 2.0));
        this.z = (float)((double)az * Math.sin(a / 2.0));
        return this.normalize();
    }

    public String toString() {
        return "x:" + this.x + " y:" + this.y + " z:" + this.z + " w:" + this.w;
    }

    public boolean withinDistance(float distance, Vector4 toCheck) {
        if ((int)this.w == (int)toCheck.w) {
            double dss = (this.x - toCheck.x) * (this.x - toCheck.x) + (this.y - toCheck.y) * (this.y - toCheck.y) + (this.z - toCheck.z) * (this.z - toCheck.z);
            return dss < (double)(distance * distance);
        }
        return false;
    }

    public void writeToNBT(CompoundNBT nbt) {
        nbt.func_74776_a("x", this.x);
        nbt.func_74776_a("y", this.y);
        nbt.func_74776_a("z", this.z);
        nbt.func_74776_a("w", this.w);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Quaternion toMCQ() {
        if (this.quat != null) {
            return this.quat;
        }
        return new Quaternion(this.x, this.y, this.z, this.w);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Quaternion toMCQInv() {
        Quaternion quat = this.toMCQ();
        quat.func_195892_e();
        return quat;
    }
}

