/*
 * Decompiled with CFR 0.152.
 */
package thut.api.particle;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.item.DyeColor;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thut.api.maths.Vector3;
import thut.api.particle.IAnimatedParticle;
import thut.api.particle.IParticle;

public class ParticleBase
extends ParticleType<ParticleBase>
implements IParticle,
IAnimatedParticle,
IParticleData {
    private static final IParticleData.IDeserializer<ParticleBase> DESERIALIZER = new IParticleData.IDeserializer<ParticleBase>(){

        public ParticleBase deserialize(ParticleType<ParticleBase> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return ((ParticleBase)particleTypeIn).read(reader);
        }

        public ParticleBase read(ParticleType<ParticleBase> particleTypeIn, PacketBuffer buffer) {
            return ((ParticleBase)particleTypeIn).read(buffer);
        }
    };
    public static ResourceLocation TEXTUREMAP = new ResourceLocation("thutcore", "textures/particles.png");
    private final Codec<ParticleBase> codec = Codec.unit((Object)this);
    public int duration = 10;
    public int lifetime = 10;
    public int initTime = 0;
    public long lastTick = 0L;
    public int animSpeed = 2;
    public float size = 1.0f;
    public int rgba = -1;
    public boolean billboard = true;
    public String name = "";
    public Vector3 velocity = Vector3.empty;
    public Vector3 position = Vector3.empty;
    public int[][] tex = new int[1][2];

    public ParticleBase(int x, int y) {
        super(true, DESERIALIZER);
        this.tex[0][0] = x;
        this.tex[0][1] = y;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    public String func_197555_a() {
        return ForgeRegistries.PARTICLE_TYPES.getKey((IForgeRegistryEntry)this).toString();
    }

    public ParticleType<?> func_197554_b() {
        return this;
    }

    @Override
    public void kill() {
    }

    @Override
    public long lastTick() {
        return this.lastTick;
    }

    public ParticleBase read(PacketBuffer buffer) {
        this.duration = buffer.readInt();
        this.lifetime = buffer.readInt();
        this.initTime = buffer.readInt();
        this.animSpeed = buffer.readInt();
        this.size = buffer.readFloat();
        this.rgba = buffer.readInt();
        this.billboard = buffer.readBoolean();
        this.velocity = Vector3.readFromBuff((ByteBuf)buffer);
        this.position = Vector3.readFromBuff((ByteBuf)buffer);
        this.tex = new int[buffer.readInt()][];
        for (int i = 0; i < this.tex.length; ++i) {
            this.tex[i] = buffer.func_186863_b();
        }
        return this;
    }

    protected ParticleBase read(StringReader reader) {
        return this;
    }

    protected void render(IVertexBuilder buffer, Quaternion quaternion, thut.api.maths.vecmath.Vector3f offset) {
        Vector3f vector3f1 = new thut.api.maths.vecmath.Vector3f(-1.0f, -1.0f, 0.0f).toMC();
        vector3f1.func_214905_a(quaternion);
        Vector3f[] verts = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.size;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = verts[i];
            vector3f.func_214905_a(quaternion);
            vector3f.func_195898_a(f4);
            vector3f.func_195904_b(offset.x, offset.y, offset.z);
        }
        this.setColour();
        float a = (float)(this.rgba >> 24 & 0xFF) / 255.0f;
        float r = (float)(this.rgba >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.rgba >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.rgba & 0xFF) / 255.0f;
        int j = 0xF000F0;
        int num = this.getDuration() / this.animSpeed % this.tex.length;
        int u = this.tex[num][0];
        int v = this.tex[num][1];
        float u1 = (float)u * 1.0f / 16.0f;
        float v1 = (float)v * 1.0f / 16.0f;
        float u2 = (float)(u + 1) * 1.0f / 16.0f;
        float v2 = (float)(v + 1) * 1.0f / 16.0f;
        buffer.func_225582_a_((double)verts[0].func_195899_a(), (double)verts[0].func_195900_b(), (double)verts[0].func_195902_c()).func_227885_a_(r, g, b, a).func_225583_a_(u1, v2).func_227886_a_(0xF000F0).func_181675_d();
        buffer.func_225582_a_((double)verts[1].func_195899_a(), (double)verts[1].func_195900_b(), (double)verts[1].func_195902_c()).func_227885_a_(r, g, b, a).func_225583_a_(u2, v2).func_227886_a_(0xF000F0).func_181675_d();
        buffer.func_225582_a_((double)verts[2].func_195899_a(), (double)verts[2].func_195900_b(), (double)verts[2].func_195902_c()).func_227885_a_(r, g, b, a).func_225583_a_(u2, v1).func_227886_a_(0xF000F0).func_181675_d();
        buffer.func_225582_a_((double)verts[3].func_195899_a(), (double)verts[3].func_195900_b(), (double)verts[3].func_195902_c()).func_227885_a_(r, g, b, a).func_225583_a_(u1, v1).func_227886_a_(0xF000F0).func_181675_d();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderParticle(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks, thut.api.maths.vecmath.Vector3f offset) {
        Quaternion quaternion = renderInfo.func_227995_f_();
        this.render(buffer, quaternion, offset);
    }

    @Override
    public void setAnimSpeed(int speed) {
        this.animSpeed = Math.max(speed, 5);
    }

    void setColour() {
        if (this.name.equalsIgnoreCase("aurora")) {
            this.rgba = -16777216;
            int num = (this.getDuration() + this.initTime) / this.animSpeed % 16;
            this.rgba += DyeColor.func_196056_a((int)num).field_218390_z;
        }
    }

    @Override
    public void setColour(int colour) {
        this.rgba = colour;
    }

    @Override
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public void setLastTick(long tick) {
        this.lastTick = tick;
    }

    @Override
    public void setLifetime(int ticks) {
        this.duration = this.lifetime = ticks;
    }

    public void setPosition(Vector3 v) {
        this.position = v;
    }

    @Override
    public void setSize(float size) {
        this.size = size;
    }

    @Override
    public void setStartTime(int start) {
        this.initTime = start;
    }

    @Override
    public void setTex(int[][] textures) {
        this.tex = textures;
    }

    public void setVelocity(Vector3 v) {
        if (v == null) {
            v = Vector3.empty;
        }
        this.velocity = v;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeInt(this.duration);
        buffer.writeInt(this.lifetime);
        buffer.writeInt(this.initTime);
        buffer.writeInt(this.animSpeed);
        buffer.writeFloat(this.size);
        buffer.writeInt(this.rgba);
        buffer.writeBoolean(this.billboard);
        this.velocity.writeToBuff((ByteBuf)buffer);
        this.position.writeToBuff((ByteBuf)buffer);
        buffer.writeInt(this.tex.length);
        for (int[] element : this.tex) {
            buffer.func_186875_a(element);
        }
    }

    public Codec<ParticleBase> func_230522_e_() {
        return this.codec;
    }
}

