/*
 * Decompiled with CFR 0.152.
 */
package thut.api.particle;

import java.util.Random;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.api.particle.ParticleBase;
import thut.api.particle.ParticleNoGravity;
import thut.api.particle.ParticleOrientable;
import thut.core.common.ThutCore;

public class ThutParticles {
    public static final ParticleNoGravity STRING = new ParticleNoGravity(8, 5);
    public static final ParticleNoGravity AURORA = new ParticleNoGravity(0, 0);
    public static final ParticleNoGravity MISC = new ParticleNoGravity(0, 0);
    public static final ParticleNoGravity POWDER = new ParticleNoGravity(0, 0);
    public static final ParticleOrientable LEAF = new ParticleOrientable(2, 2);

    public static ParticleBase clone(ParticleBase type) {
        ParticleBase ret = null;
        if (type == AURORA) {
            ret = new ParticleNoGravity(0, 0);
        } else if (type == STRING) {
            ret = new ParticleNoGravity(8, 5);
        } else if (type == MISC) {
            ret = new ParticleNoGravity(0, 0);
        } else if (type == POWDER) {
            ret = new ParticleNoGravity(0, 0);
        } else if (type == LEAF) {
            ret = new ParticleOrientable(2, 2);
            ((ParticleOrientable)ret).setOrientation(((ParticleOrientable)type).orientation);
        }
        if (ret != null) {
            ret.setVelocity(type.velocity.copy());
            ret.setTex((int[][])type.tex.clone());
            ret.setLastTick(type.lastTick());
            ret.setAnimSpeed(type.animSpeed);
            ret.setLifetime(type.lifetime);
            ret.setSize(type.size);
            ret.setStartTime(type.initTime);
            ret.setColour(type.rgba);
            ret.name = type.name;
        }
        return ret;
    }

    public static IParticleData makeParticle(String name, Vector3 pos, Vector3 vel, int ... args) {
        ResourceLocation location;
        ParticleType type;
        int[][] textures;
        ParticleBase particle;
        if (!name.toLowerCase().equals(name)) {
            ThutCore.LOGGER.error("Error with particle name of: " + name);
        }
        name = name.toLowerCase();
        ParticleBase ret = null;
        if (name.equalsIgnoreCase("string")) {
            particle = STRING;
            particle.setVelocity(vel);
            ret = particle;
        } else if (name.equalsIgnoreCase("aurora")) {
            particle = AURORA;
            particle.setVelocity(vel);
            textures = new int[2][2];
            textures[0][0] = 2;
            textures[0][1] = 4;
            textures[1][0] = 1;
            textures[1][1] = 4;
            particle.setTex(textures);
            int life = 32;
            if (args.length > 1) {
                life = args[1];
            }
            particle.setStartTime(new Random().nextInt(100));
            particle.setAnimSpeed(1);
            particle.setLifetime(life);
            particle.setSize(0.1f);
            ((ParticleNoGravity)particle).name = "aurora";
            ret = particle;
        } else if (name.equalsIgnoreCase("misc")) {
            particle = MISC;
            particle.setVelocity(vel);
            textures = new int[2][2];
            textures[0][0] = 2;
            textures[0][1] = 4;
            textures[1][0] = 1;
            textures[1][1] = 4;
            particle.setTex(textures);
            int life = 32;
            if (args.length > 0) {
                particle.setColour(args[0]);
            }
            if (args.length > 1) {
                life = args[1];
            }
            particle.setLifetime(life);
            particle.setSize(0.15f);
            ret = particle;
        } else if (name.equalsIgnoreCase("powder")) {
            particle = POWDER;
            particle.setVelocity(vel);
            textures = new int[7][2];
            textures[0][0] = 0;
            textures[0][1] = 0;
            textures[1][0] = 1;
            textures[1][1] = 0;
            textures[2][0] = 2;
            textures[2][1] = 0;
            textures[3][0] = 3;
            textures[3][1] = 0;
            textures[4][0] = 4;
            textures[4][1] = 0;
            textures[5][0] = 5;
            textures[5][1] = 0;
            textures[6][0] = 6;
            textures[6][1] = 0;
            particle.setTex(textures);
            particle.setSize(0.125f);
            int life = 32;
            if (args.length > 0) {
                particle.setColour(args[0]);
            }
            if (args.length > 1) {
                life = args[1];
            }
            particle.setLifetime(life);
            ret = particle;
        } else if (name.equalsIgnoreCase("leaf")) {
            particle = LEAF;
            particle.setLifetime(20);
            particle.setVelocity(vel);
            ((ParticleOrientable)particle).size = 0.25f;
            if (vel != null) {
                Vector3 normal = vel.normalize().copy();
                Vector4 v3 = new Vector4(0.0, 1.0, 0.0, (float)(90.0 - normal.toSpherical().z * 180.0 / Math.PI));
                Vector4 v2 = new Vector4(1.0, 0.0, 0.0, (float)(90.0 + normal.y * 180.0 / Math.PI));
                ((ParticleOrientable)particle).setOrientation(v3.addAngles(v2).toQuaternion());
            }
            ret = particle;
        }
        if (ret == null && (type = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(location = new ResourceLocation(name))) != null) {
            return (IParticleData)type;
        }
        if (ret == null) {
            particle = MISC;
            particle.setVelocity(vel);
            ret = particle;
        }
        return ret;
    }
}

