/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import thut.core.common.ThutCore;

public class BiomeType {
    private static final Map<Integer, BiomeType> typeMap = Maps.newHashMap();
    private static final Map<Integer, BiomeType> typeMapClient = Maps.newHashMap();
    private static int MAXID = 256;
    public static final BiomeType NONE = new BiomeType("none");
    public static final BiomeType SKY = new BiomeType("sky");
    public static final BiomeType FLOWER = new BiomeType("flower");
    public static final BiomeType LAKE = new BiomeType("lake");
    public static final BiomeType INDUSTRIAL = new BiomeType("industrial");
    public static final BiomeType METEOR = new BiomeType("meteor");
    public static final BiomeType RUIN = new BiomeType("ruin");
    public static final BiomeType CAVE = new BiomeType("cave");
    public static final BiomeType CAVE_WATER = new BiomeType("cavewater");
    public static final BiomeType VILLAGE = new BiomeType("village");
    public static final BiomeType ALL = new BiomeType("all");
    public final String name;
    private int id;
    public final String readableName;

    public static BiomeType getBiome(String name) {
        return BiomeType.getBiome(name, true);
    }

    public static BiomeType getBiome(String name, boolean generate) {
        name = ThutCore.trim(name);
        for (BiomeType b : BiomeType.values()) {
            if (!b.name.equalsIgnoreCase(name)) continue;
            return b;
        }
        if (generate) {
            BiomeType ret = new BiomeType(name);
            return ret;
        }
        return NONE;
    }

    public static Map<Integer, String> getMap() {
        HashMap map = Maps.newHashMap();
        for (BiomeType type : BiomeType.values()) {
            map.put(type.getType(), type.name);
        }
        return map;
    }

    public static BiomeType getType(int id) {
        if (ThutCore.proxy.isClientSide()) {
            return typeMapClient.containsKey(id) ? typeMapClient.get(id) : NONE;
        }
        return typeMap.containsKey(id) ? typeMap.get(id) : NONE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setMap(Map<Integer, String> mapIn) {
        typeMapClient.clear();
        for (Integer i : mapIn.keySet()) {
            String name = mapIn.get(i);
            BiomeType type = BiomeType.getBiome(name, true);
            typeMapClient.put(i, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<BiomeType> values() {
        Collection<BiomeType> values;
        if (ThutCore.proxy.isClientSide()) {
            Collection<BiomeType> values2;
            ArrayList types = Lists.newArrayList();
            Collection<BiomeType> collection = values2 = typeMapClient.values();
            synchronized (collection) {
                types.addAll(values2);
            }
            return types;
        }
        ArrayList types = Lists.newArrayList();
        Collection<BiomeType> collection = values = typeMap.values();
        synchronized (collection) {
            types.addAll(values);
        }
        return types;
    }

    private BiomeType(String name) {
        this.name = name;
        this.readableName = "thutcore.biometype." + name;
        this.id = -1;
        for (BiomeType type : typeMap.values()) {
            if (!type.name.equals(name)) continue;
            this.id = type.id;
        }
        if (this.id == -1) {
            this.id = MAXID++;
        }
        typeMap.put(this.id, this);
        typeMapClient.put(this.id, this);
    }

    public boolean equals(Object o) {
        if (o instanceof BiomeType) {
            return ((BiomeType)o).id == this.id;
        }
        return false;
    }

    public int getType() {
        return this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }
}

