/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import thut.api.ThutCaps;
import thut.api.terrain.CapabilityTerrain;
import thut.api.terrain.GlobalChunkPos;
import thut.api.terrain.TerrainSegment;

public interface ITerrainProvider {
    public static final Object lock = new Object();
    public static final Map<GlobalChunkPos, TerrainCache> pendingCache = new Object2ObjectOpenHashMap();
    public static final Map<GlobalChunkPos, IChunk> loadedChunks = new Object2ObjectOpenHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addChunk(DimensionType dim, IChunk chunk) {
        GlobalChunkPos pos = new GlobalChunkPos(dim, chunk.func_76632_l());
        Object object = lock;
        synchronized (object) {
            loadedChunks.put(pos, chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeChunk(DimensionType dim, ChunkPos cpos) {
        GlobalChunkPos pos = new GlobalChunkPos(dim, cpos);
        Object object = lock;
        synchronized (object) {
            if (loadedChunks.containsKey(pos)) {
                loadedChunks.remove(pos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IChunk getChunk(DimensionType dim, ChunkPos cpos) {
        GlobalChunkPos pos = new GlobalChunkPos(dim, cpos);
        Object object = lock;
        synchronized (object) {
            if (!loadedChunks.containsKey(pos)) {
                return null;
            }
            return loadedChunks.get(pos);
        }
    }

    public static TerrainSegment removeCached(DimensionType dim, BlockPos pos) {
        GlobalChunkPos wpos = new GlobalChunkPos(dim, new ChunkPos(pos.func_177958_n(), pos.func_177952_p()));
        TerrainCache segs = pendingCache.get(wpos);
        if (segs == null) {
            return null;
        }
        TerrainSegment var = segs.remove(pos.func_177956_o());
        if (!segs.isValid()) {
            pendingCache.remove(wpos);
        }
        return var;
    }

    default public TerrainSegment getTerrain(IWorld world, BlockPos p) {
        boolean real;
        ChunkPos temp = new ChunkPos(p);
        int y = p.func_177956_o() >> 4;
        if (y < 0) {
            y = 0;
        }
        if (y > 15) {
            y = 15;
        }
        BlockPos pos = new BlockPos(temp.field_77276_a, y, temp.field_77275_b);
        DimensionType dim = world.func_230315_m_();
        IChunk chunk = ITerrainProvider.getChunk(dim, temp);
        boolean bl = real = chunk != null && chunk instanceof ICapabilityProvider;
        if (!real) {
            GlobalChunkPos wpos = new GlobalChunkPos(dim, temp);
            TerrainCache segs = pendingCache.get(wpos);
            if (segs == null) {
                segs = new TerrainCache(temp, chunk);
                pendingCache.put(wpos, segs);
            }
            return segs.get(y);
        }
        CapabilityTerrain.ITerrainProvider provider = (CapabilityTerrain.ITerrainProvider)((ICapabilityProvider)chunk).getCapability(ThutCaps.TERRAIN_CAP).orElse(null);
        provider.setChunk(chunk);
        return provider.getTerrainSegement(pos);
    }

    public static class TerrainCache {
        TerrainSegment[] segs = new TerrainSegment[16];
        int num = 16;

        public TerrainCache(ChunkPos temp, IChunk chunk) {
            for (int i = 0; i < 16; ++i) {
                this.segs[i] = new TerrainSegment(temp.field_77276_a, i, temp.field_77275_b);
                this.segs[i].chunk = chunk;
                this.segs[i].real = false;
            }
        }

        public TerrainSegment remove(int y) {
            TerrainSegment seg = this.segs[y];
            if (seg == null) {
                return null;
            }
            --this.num;
            return seg;
        }

        public boolean isValid() {
            return this.num > 0;
        }

        public TerrainSegment get(int y) {
            return this.segs[y];
        }
    }
}

