/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.terrain.GlobalChunkPos;
import thut.api.terrain.ITerrainProvider;

public class StructureManager {
    public static Map<GlobalChunkPos, Set<StructureInfo>> map_by_pos = new Object2ObjectOpenHashMap();

    private static Set<StructureInfo> getOrMake(GlobalChunkPos pos) {
        Set<StructureInfo> set = map_by_pos.getOrDefault(pos, Sets.newHashSet());
        if (!map_by_pos.containsKey(pos)) {
            map_by_pos.put(pos, set);
        }
        return set;
    }

    public static Set<StructureInfo> getFor(DimensionType dim, BlockPos loc) {
        GlobalChunkPos pos = new GlobalChunkPos(dim, new ChunkPos(loc));
        Set<StructureInfo> forPos = map_by_pos.getOrDefault(pos, Collections.emptySet());
        if (forPos.isEmpty()) {
            return forPos;
        }
        HashSet matches = Sets.newHashSet();
        for (StructureInfo i : forPos) {
            if (!i.isIn(loc)) continue;
            matches.add(i);
        }
        return matches;
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load evt) {
        if (evt.getWorld() == null || evt.getWorld().func_201670_d()) {
            return;
        }
        DimensionType dim = evt.getWorld().func_230315_m_();
        for (Map.Entry<Structure<?>, StructureStart<?>> entry : evt.getChunk().func_201609_c().entrySet()) {
            StructureInfo info = new StructureInfo(entry);
            MutableBoundingBox b = info.start.func_75071_a();
            for (int x = b.field_78897_a >> 4; x <= b.field_78893_d >> 4; ++x) {
                for (int z = b.field_78896_c >> 4; z <= b.field_78892_f >> 4; ++z) {
                    ChunkPos p = new ChunkPos(x, z);
                    GlobalChunkPos pos = new GlobalChunkPos(dim, p);
                    Set<StructureInfo> set = StructureManager.getOrMake(pos);
                    set.add(info);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload evt) {
        if (evt.getWorld() == null || evt.getWorld().func_201670_d()) {
            return;
        }
        DimensionType dim = evt.getChunk().getWorldForge().func_230315_m_();
        GlobalChunkPos pos = new GlobalChunkPos(dim, evt.getChunk().func_76632_l());
        map_by_pos.remove(pos);
    }

    public static void clear() {
        map_by_pos.clear();
        ITerrainProvider.loadedChunks.clear();
        ITerrainProvider.pendingCache.clear();
    }

    public static class StructureInfo {
        public String name;
        public StructureStart<?> start;
        private int hash;
        private String key;

        public StructureInfo() {
        }

        public StructureInfo(Map.Entry<Structure<?>, StructureStart<?>> entry) {
            this.name = entry.getKey().func_143025_a();
            this.start = entry.getValue();
            this.key = this.name + " " + this.start.func_75071_a();
            this.hash = this.key.hashCode();
        }

        public boolean isIn(BlockPos pos) {
            if (!this.start.func_75071_a().func_175898_b((Vector3i)pos)) {
                return false;
            }
            for (StructurePiece p1 : this.start.func_186161_c()) {
                if (!this.isIn(p1.func_74874_b(), pos)) continue;
                return true;
            }
            return false;
        }

        private boolean isIn(MutableBoundingBox b, BlockPos pos) {
            int x1 = pos.func_177958_n();
            int y1 = pos.func_177956_o();
            int z1 = pos.func_177952_p();
            for (int x = x1; x < x1 + 4; ++x) {
                for (int y = y1; y < y1 + 4; ++y) {
                    for (int z = z1; z < z1 + 4; ++z) {
                        pos = new BlockPos(x, y, z);
                        if (!b.func_175898_b((Vector3i)pos)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StructureInfo)) {
                return false;
            }
            return obj.toString().equals(this.toString());
        }

        public String toString() {
            return this.key;
        }
    }
}

