/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.AnimationComponent;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.model.IExtendedModelPart;

public class AnimationHelper {
    private static final Map<UUID, CapabilityAnimation.IAnimationHolder> holderMap = Maps.newHashMap();

    public static boolean animate(Animation animation, CapabilityAnimation.IAnimationHolder animate, String partName, IExtendedModelPart part, float partialTick, float limbSwing, int tick) {
        ArrayList<AnimationComponent> components = animation.getComponents(partName);
        if (components == null) {
            return false;
        }
        boolean animated = false;
        Vector3 temp = Vector3.getNewVector();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float sx = 1.0f;
        float sy = 1.0f;
        float sz = 1.0f;
        int aniTick = tick;
        float time1 = aniTick;
        float time2 = 0.0f;
        int animationLength = animation.getLength();
        animationLength = Math.max(1, animationLength);
        float limbSpeedFactor = 3.0f;
        time1 = (time1 + partialTick) % (float)animationLength;
        time2 = limbSwing * 3.0f % (float)animationLength;
        aniTick = (int)time1;
        for (AnimationComponent component : components) {
            float time;
            float f = time = component.limbBased ? time2 : time1;
            if (component.limbBased) {
                aniTick = (int)time2;
            }
            if (!(time >= (float)component.startKey)) continue;
            animated = true;
            float componentTimer = time - (float)component.startKey;
            if (componentTimer > (float)component.length) {
                componentTimer = component.length;
            }
            int length = component.length == 0 ? 1 : component.length;
            float ratio = componentTimer / (float)length;
            temp.addTo(component.posChange[0] * (double)ratio + component.posOffset[0], component.posChange[1] * (double)ratio + component.posOffset[1], component.posChange[2] * (double)ratio + component.posOffset[2]);
            x += (float)(component.rotChange[0] * (double)ratio + component.rotOffset[0]);
            y += (float)(component.rotChange[1] * (double)ratio + component.rotOffset[1]);
            z += (float)(component.rotChange[2] * (double)ratio + component.rotOffset[2]);
            sx += (float)(component.scaleChange[0] * (double)ratio + component.scaleOffset[0]);
            sy += (float)(component.scaleChange[1] * (double)ratio + component.scaleOffset[1]);
            sz += (float)(component.scaleChange[2] * (double)ratio + component.scaleOffset[2]);
            part.setHidden(component.hidden);
        }
        animate.setStep(animation, aniTick + 2);
        if (animated) {
            part.setPreTranslations(temp);
            part.setPreScale(temp.set(sx, sy, sz));
            Quaternion quat = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
            if (z != 0.0f) {
                quat.func_195890_a(Vector3f.field_229180_c_.func_229187_a_(z));
            }
            if (x != 0.0f) {
                quat.func_195890_a(Vector3f.field_229179_b_.func_229187_a_(x));
            }
            if (y != 0.0f) {
                quat.func_195890_a(Vector3f.field_229183_f_.func_229187_a_(y));
            }
            part.setPreRotations(new Vector4(quat));
        }
        return animated;
    }

    public static boolean doAnimation(List<Animation> list, Entity entity, String partName, IExtendedModelPart part, float partialTick, float limbSwing) {
        boolean animate = false;
        CapabilityAnimation.IAnimationHolder holder = part.getAnimationHolder();
        if (holder != null) {
            list = Lists.newArrayList(holder.getPlaying());
            for (Animation animation : list) {
                animate = AnimationHelper.animate(animation, holder, partName, part, partialTick, limbSwing, entity.field_70173_aa) || animate;
            }
        }
        return animate;
    }

    public static CapabilityAnimation.IAnimationHolder getHolder(Entity mob) {
        CapabilityAnimation.IAnimationHolder cap = (CapabilityAnimation.IAnimationHolder)mob.getCapability(CapabilityAnimation.CAPABILITY).orElse(null);
        if (cap != null) {
            return cap;
        }
        if (holderMap.containsKey(mob.func_110124_au())) {
            return holderMap.get(mob.func_110124_au());
        }
        CapabilityAnimation.DefaultImpl holder = new CapabilityAnimation.DefaultImpl();
        holderMap.put(mob.func_110124_au(), holder);
        return holder;
    }
}

