/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation.prefab;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.AnimationComponent;
import thut.core.client.render.animation.AnimationRegistry;
import thut.core.client.render.animation.AnimationXML;
import thut.core.common.ThutCore;

public class BiWalkAnimation
extends Animation {
    public BiWalkAnimation() {
        this.loops = true;
        this.name = "walking";
    }

    @Override
    public Animation init(AnimationXML.Phase map, @Nullable AnimationRegistry.IPartRenamer renamer) {
        HashSet<String> hl = new HashSet<String>();
        HashSet<String> hr = new HashSet<String>();
        HashSet<String> fl = new HashSet<String>();
        HashSet<String> fr = new HashSet<String>();
        int biwalkdur = 0;
        float walkAngle1 = 20.0f;
        float walkAngle2 = 20.0f;
        String[] lh = this.get(map, "leftLeg").split(":");
        String[] rh = this.get(map, "rightLeg").split(":");
        String[] lf = this.get(map, "leftArm").split(":");
        String[] rf = this.get(map, "rightArm").split(":");
        if (renamer != null) {
            renamer.convertToIdents(lh);
            renamer.convertToIdents(rh);
            renamer.convertToIdents(lf);
            renamer.convertToIdents(rf);
        }
        for (String s : lh) {
            if (s == null) continue;
            hl.add(ThutCore.trim(s));
        }
        for (String s : rh) {
            if (s == null) continue;
            hr.add(ThutCore.trim(s));
        }
        for (String s : rf) {
            if (s == null) continue;
            fr.add(ThutCore.trim(s));
        }
        for (String s : lf) {
            if (s == null) continue;
            fl.add(ThutCore.trim(s));
        }
        biwalkdur = Integer.parseInt(this.get(map, "duration"));
        int armAxis = 0;
        int legAxis = 0;
        if (!this.get(map, "legAngle").isEmpty()) {
            walkAngle1 = Float.parseFloat(this.get(map, "legAngle"));
        }
        if (!this.get(map, "armAngle").isEmpty()) {
            walkAngle2 = Float.parseFloat(this.get(map, "armAngle"));
        }
        if (!this.get(map, "legAxis").isEmpty()) {
            legAxis = Integer.parseInt(this.get(map, "legAxis"));
        }
        if (!this.get(map, "armAxis").isEmpty()) {
            armAxis = Integer.parseInt(this.get(map, "armAxis"));
        }
        this.init(hl, hr, fl, fr, biwalkdur, walkAngle1, walkAngle2, legAxis, armAxis);
        return this;
    }

    public BiWalkAnimation init(Set<String> hl, Set<String> hr, Set<String> fl, Set<String> fr, int duration, float legAngle, float armAngle, int legAxis, int armAxis) {
        ArrayList set;
        AnimationComponent component3;
        AnimationComponent component2;
        AnimationComponent component1;
        String ident;
        duration += duration % 4;
        for (String s : hr) {
            ident = "hr";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = "hr1";
            component1.identifier = "hr1";
            component1.startKey = 0;
            component1.rotChange[legAxis] = legAngle;
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = "hr2";
            component2.identifier = "hr2";
            component2.startKey = duration / 4;
            component2.rotChange[legAxis] = -2.0f * legAngle;
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = "hr3";
            component3.identifier = "hr3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[legAxis] = legAngle;
            set = Lists.newArrayList();
            component1.limbBased = true;
            component2.limbBased = true;
            component3.limbBased = true;
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        for (String s : hl) {
            ident = "hl";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = "hl1";
            component1.identifier = "hl1";
            component1.startKey = 0;
            component1.rotChange[legAxis] = -legAngle;
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = "hl2";
            component2.identifier = "hl2";
            component2.startKey = duration / 4;
            component2.rotChange[legAxis] = 2.0f * legAngle;
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = "hl3";
            component3.identifier = "hl3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[legAxis] = -legAngle;
            set = Lists.newArrayList();
            component1.limbBased = true;
            component2.limbBased = true;
            component3.limbBased = true;
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        for (String s : fr) {
            ident = "fr";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = "fr1";
            component1.identifier = "fr1";
            component1.startKey = 0;
            component1.rotChange[armAxis] = armAngle;
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = "fr2";
            component2.identifier = "fr2";
            component2.startKey = duration / 4;
            component2.rotChange[armAxis] = -2.0f * armAngle;
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = "fr3";
            component3.identifier = "fr3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[armAxis] = armAngle;
            set = Lists.newArrayList();
            component1.limbBased = true;
            component2.limbBased = true;
            component3.limbBased = true;
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        for (String s : fl) {
            ident = "fl";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = "fl1";
            component1.identifier = "fl1";
            component1.startKey = 0;
            component1.rotChange[armAxis] = -armAngle;
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = "fl2";
            component2.identifier = "fl2";
            component2.startKey = duration / 4;
            component2.rotChange[armAxis] = 2.0f * armAngle;
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = "fl3";
            component3.identifier = "fl3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[armAxis] = -armAngle;
            set = Lists.newArrayList();
            component1.limbBased = true;
            component2.limbBased = true;
            component3.limbBased = true;
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        for (ArrayList set2 : this.sets.values()) {
            for (AnimationComponent c : set2) {
                c.limbBased = true;
            }
        }
        return this;
    }
}

