/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation.prefab;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.AnimationComponent;
import thut.core.client.render.animation.AnimationRegistry;
import thut.core.client.render.animation.AnimationXML;
import thut.core.common.ThutCore;

public class QuadWalkAnimation
extends Animation {
    public QuadWalkAnimation() {
        this.loops = true;
        this.name = "walking";
    }

    @Override
    public Animation init(AnimationXML.Phase map, AnimationRegistry.IPartRenamer renamer) {
        HashSet<String> hl = new HashSet<String>();
        HashSet<String> hr = new HashSet<String>();
        HashSet<String> fl = new HashSet<String>();
        HashSet<String> fr = new HashSet<String>();
        int quadwalkdur = 0;
        float walkAngle1 = 20.0f;
        float walkAngle2 = 20.0f;
        String[] lh = this.get(map, "leftHind").split(":");
        String[] rh = this.get(map, "rightHind").split(":");
        String[] lf = this.get(map, "leftFront").split(":");
        String[] rf = this.get(map, "rightFront").split(":");
        if (renamer != null) {
            renamer.convertToIdents(lh);
            renamer.convertToIdents(rh);
            renamer.convertToIdents(lf);
            renamer.convertToIdents(rf);
        }
        for (String s : lh) {
            if (s == null) continue;
            hl.add(ThutCore.trim(s));
        }
        for (String s : rh) {
            if (s == null) continue;
            hr.add(ThutCore.trim(s));
        }
        for (String s : rf) {
            if (s == null) continue;
            fr.add(ThutCore.trim(s));
        }
        for (String s : lf) {
            if (s == null) continue;
            fl.add(ThutCore.trim(s));
        }
        if (!this.get(map, "angle").isEmpty()) {
            walkAngle1 = Float.parseFloat(this.get(map, "angle"));
        }
        walkAngle2 = !this.get(map, "frontAngle").isEmpty() ? Float.parseFloat(this.get(map, "frontAngle")) : walkAngle1;
        quadwalkdur = Integer.parseInt(this.get(map, "duration"));
        this.init(hl, hr, fl, fr, quadwalkdur, walkAngle1, walkAngle2);
        return this;
    }

    public QuadWalkAnimation init(Set<String> hl, Set<String> hr, Set<String> fl, Set<String> fr, int duration, float legAngle, float armAngle) {
        ArrayList set;
        AnimationComponent component3;
        AnimationComponent component2;
        AnimationComponent component1;
        String ident;
        duration += duration % 4;
        for (String s : hr) {
            ident = "";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = "1";
            component1.identifier = "1";
            component1.startKey = 0;
            component1.rotChange[0] = legAngle;
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = "2";
            component2.identifier = "2";
            component2.startKey = duration / 4;
            component2.rotChange[0] = -2.0f * legAngle;
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = "3";
            component3.identifier = "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[0] = legAngle;
            set = Lists.newArrayList();
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        for (String s : hl) {
            ident = "";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = "1";
            component1.identifier = "1";
            component1.startKey = 0;
            component1.rotChange[0] = -legAngle;
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = "2";
            component2.identifier = "2";
            component2.startKey = duration / 4;
            component2.rotChange[0] = 2.0f * legAngle;
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = "3";
            component3.identifier = "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[0] = -legAngle;
            set = Lists.newArrayList();
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        for (String s : fr) {
            ident = "";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = "1";
            component1.identifier = "1";
            component1.startKey = 0;
            component1.rotChange[0] = armAngle;
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = "2";
            component2.identifier = "2";
            component2.startKey = duration / 4;
            component2.rotChange[0] = -2.0f * armAngle;
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = "3";
            component3.identifier = "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[0] = armAngle;
            set = Lists.newArrayList();
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        for (String s : fl) {
            ident = "";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = "1";
            component1.identifier = "1";
            component1.startKey = 0;
            component1.rotChange[0] = -armAngle;
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = "2";
            component2.identifier = "2";
            component2.startKey = duration / 4;
            component2.rotChange[0] = 2.0f * armAngle;
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = "3";
            component3.identifier = "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[0] = -armAngle;
            set = Lists.newArrayList();
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        for (ArrayList set2 : this.sets.values()) {
            for (AnimationComponent c : set2) {
                c.limbBased = true;
            }
        }
        return this;
    }
}

