/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Quaternion;
import thut.api.maths.Vector3;
import thut.api.maths.vecmath.Vector3f;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.AnimationXML;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.IModelRenderer;
import thut.core.client.render.model.parts.Material;
import thut.core.common.ThutCore;

public interface IModel {
    public static final ImmutableSet<String> emptyAnims = ImmutableSet.of();

    public void applyAnimation(Entity var1, IModelRenderer<?> var2, float var3, float var4);

    default public Set<String> getBuiltInAnimations() {
        return emptyAnims;
    }

    public HeadInfo getHeadInfo();

    public Set<String> getHeadParts();

    public Map<String, IExtendedModelPart> getParts();

    default public void setAnimationHolder(CapabilityAnimation.IAnimationHolder holder) {
        this.getParts().forEach((s, p) -> p.setAnimationHolder(holder));
    }

    default public void globalFix(MatrixStack mat, float dx, float dy, float dz) {
        mat.func_227863_a_(new Quaternion(90.0f, 0.0f, 180.0f, true));
        mat.func_227861_a_(0.0, 0.0, (double)(dy - 1.5f));
    }

    public boolean isValid();

    default public IModel init(IModelCallback callback) {
        if (this.isValid()) {
            callback.run(this);
        }
        return this;
    }

    default public boolean isLoaded() {
        return true;
    }

    public void preProcessAnimations(Collection<List<Animation>> var1);

    default public void setHeadInfo(HeadInfo in) {
    }

    default public void setOffset(Vector3 offset) {
    }

    default public void updateMaterial(AnimationXML.Mat mat) {
        mat.name = ThutCore.trim(mat.name);
        Material material = new Material(mat.name);
        material.diffuseColor = new Vector3f(1.0f, 1.0f, 1.0f);
        material.emissiveColor = new Vector3f(mat.light, mat.light, mat.light);
        material.emissiveMagnitude = Math.min(1.0f, (float)((double)material.emissiveColor.length() / Math.sqrt(3.0)) / 0.8f);
        material.specularColor = new Vector3f(1.0f, 1.0f, 1.0f);
        material.alpha = mat.alpha;
        material.flat = !mat.smooth;
        material.transluscent = mat.transluscent;
        for (IExtendedModelPart part : this.getParts().values()) {
            part.updateMaterial(mat, material);
        }
    }

    public static class HeadInfo {
        public float headYaw;
        public float headPitch;
        public int currentTick = 0;
        public int lastTick = 0;
        public float yawCapMax = 180.0f;
        public float yawCapMin = -180.0f;
        public float pitchCapMax = 40.0f;
        public float pitchCapMin = -40.0f;
        public int yawAxis = 1;
        public int pitchAxis = 0;
        public int yawDirection = 1;
        public int pitchDirection = 1;
    }

    public static interface IModelCallback {
        public void run(IModel var1);
    }
}

