/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import thut.api.ModelHolder;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.animation.IAnimationChanger;
import thut.core.client.render.model.IModel;
import thut.core.client.render.texturing.IPartTexturer;

public interface IModelRenderer<T extends MobEntity> {
    public static final String DEFAULTPHASE = "idle";
    public static final Vector3 DEFAULTSCALE = Vector3.getNewVector().set(1);

    default public void doRender(T entity, double d, double d1, double d2, float f, float partialTick) {
    }

    default public String getAnimation(Entity entityIn) {
        CapabilityAnimation.IAnimationHolder holder = this.getAnimationHolder();
        if (holder != null) {
            return holder.getAnimation(entityIn);
        }
        return DEFAULTPHASE;
    }

    public IAnimationChanger getAnimationChanger();

    public HashMap<String, List<Animation>> getAnimations();

    default public Vector3 getRotationOffset() {
        return Vector3.empty;
    }

    @Nullable
    default public Vector5 getRotations() {
        return null;
    }

    default public Vector3 getScale() {
        return DEFAULTSCALE;
    }

    public IPartTexturer getTexturer();

    public boolean hasAnimation(String var1, Entity var2);

    public void scaleEntity(MatrixStack var1, Entity var2, IModel var3, float var4);

    default public void setAnimation(Entity entity, float partialTick) {
        CapabilityAnimation.IAnimationHolder holder = this.getAnimationHolder();
        String phase = this.getAnimation(entity);
        List<Animation> anim = this.getAnimations(entity, phase);
        if (holder != null && anim != null && !anim.isEmpty()) {
            phase.toString();
            holder.setPendingAnimations(anim, phase);
        }
    }

    default public List<Animation> getAnimations(Entity entity, String phase) {
        return null;
    }

    public void setAnimationHolder(CapabilityAnimation.IAnimationHolder var1);

    public CapabilityAnimation.IAnimationHolder getAnimationHolder();

    public void setAnimationChanger(IAnimationChanger var1);

    public void setRotationOffset(Vector3 var1);

    public void setRotations(Vector5 var1);

    public void setScale(Vector3 var1);

    public void setTexturer(IPartTexturer var1);

    public void updateModel(HashMap<String, ArrayList<Vector5>> var1, ModelHolder var2);

    public static class Vector5 {
        public Vector4 rotations;
        public int time;

        public Vector5() {
            this.time = 0;
            this.rotations = new Vector4();
        }

        public Vector5(Vector4 rotation, int time) {
            this.rotations = rotation;
            this.time = time;
        }

        public String toString() {
            return "|r:" + this.rotations + "|t:" + this.time;
        }
    }
}

