/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model;

import thut.api.maths.vecmath.Matrix4f;
import thut.api.maths.vecmath.Vector3f;
import thut.core.client.render.model.Vector6f;

public class VectorMath {
    static final Vector3f X_AXIS = new Vector3f(1.0f, 0.0f, 0.0f);
    static final Vector3f Y_AXIS = new Vector3f(0.0f, 1.0f, 0.0f);
    static final Vector3f Z_AXIS = new Vector3f(0.0f, 0.0f, 1.0f);

    public static void cleanSmall(Matrix4f matrix) {
        if ((double)Math.abs(matrix.m00) < 1.0E-6) {
            matrix.m00 = 0.0f;
        }
        if ((double)Math.abs(matrix.m01) < 1.0E-6) {
            matrix.m01 = 0.0f;
        }
        if ((double)Math.abs(matrix.m02) < 1.0E-6) {
            matrix.m02 = 0.0f;
        }
        if ((double)Math.abs(matrix.m03) < 1.0E-6) {
            matrix.m03 = 0.0f;
        }
        if ((double)Math.abs(matrix.m10) < 1.0E-6) {
            matrix.m10 = 0.0f;
        }
        if ((double)Math.abs(matrix.m11) < 1.0E-6) {
            matrix.m11 = 0.0f;
        }
        if ((double)Math.abs(matrix.m12) < 1.0E-6) {
            matrix.m12 = 0.0f;
        }
        if ((double)Math.abs(matrix.m13) < 1.0E-6) {
            matrix.m13 = 0.0f;
        }
        if ((double)Math.abs(matrix.m20) < 1.0E-6) {
            matrix.m20 = 0.0f;
        }
        if ((double)Math.abs(matrix.m21) < 1.0E-6) {
            matrix.m21 = 0.0f;
        }
        if ((double)Math.abs(matrix.m22) < 1.0E-6) {
            matrix.m22 = 0.0f;
        }
        if ((double)Math.abs(matrix.m23) < 1.0E-6) {
            matrix.m23 = 0.0f;
        }
        if ((double)Math.abs(matrix.m30) < 1.0E-6) {
            matrix.m30 = 0.0f;
        }
        if ((double)Math.abs(matrix.m31) < 1.0E-6) {
            matrix.m31 = 0.0f;
        }
        if ((double)Math.abs(matrix.m32) < 1.0E-6) {
            matrix.m32 = 0.0f;
        }
        if ((double)Math.abs(matrix.m33) < 1.0E-6) {
            matrix.m33 = 0.0f;
        }
    }

    public static Matrix4f fromFloat(float val) {
        return VectorMath.fromVector6f(val, val, val, val, val, val);
    }

    public static Matrix4f fromFloatArray(float[] vals) {
        return VectorMath.fromVector6f(vals[0], vals[1], vals[2], vals[3], vals[4], vals[5]);
    }

    public static Matrix4f fromVector6f(float xl, float yl, float zl, float xr, float yr, float zr) {
        Vector3f loc = new Vector3f(xl, yl, zl);
        Matrix4f ret = new Matrix4f();
        VectorMath.translate(loc, ret);
        VectorMath.rotate(zr, Z_AXIS, ret);
        VectorMath.rotate(yr, Y_AXIS, ret);
        VectorMath.rotate(xr, X_AXIS, ret);
        VectorMath.cleanSmall(ret);
        return ret;
    }

    public static Matrix4f fromVector6f(Vector6f vector) {
        return VectorMath.fromVector6f(vector.vector1.x, vector.vector1.y, vector.vector1.z, vector.vector2.x, vector.vector2.y, vector.vector2.z);
    }

    public static Matrix4f rotate(float angle, Vector3f axis, Matrix4f matrix) {
        return VectorMath.rotate(angle, axis, matrix, matrix);
    }

    public static Matrix4f rotate(float angle, Vector3f axis, Matrix4f src, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        }
        float c = (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        float oneminusc = 1.0f - c;
        float xy = axis.x * axis.y;
        float yz = axis.y * axis.z;
        float xz = axis.x * axis.z;
        float xs = axis.x * s;
        float ys = axis.y * s;
        float zs = axis.z * s;
        float f00 = axis.x * axis.x * oneminusc + c;
        float f01 = xy * oneminusc + zs;
        float f02 = xz * oneminusc - ys;
        float f10 = xy * oneminusc - zs;
        float f11 = axis.y * axis.y * oneminusc + c;
        float f12 = yz * oneminusc + xs;
        float f20 = xz * oneminusc + ys;
        float f21 = yz * oneminusc - xs;
        float f22 = axis.z * axis.z * oneminusc + c;
        float t00 = src.m00 * f00 + src.m10 * f01 + src.m20 * f02;
        float t01 = src.m01 * f00 + src.m11 * f01 + src.m21 * f02;
        float t02 = src.m02 * f00 + src.m12 * f01 + src.m22 * f02;
        float t03 = src.m03 * f00 + src.m13 * f01 + src.m23 * f02;
        float t10 = src.m00 * f10 + src.m10 * f11 + src.m20 * f12;
        float t11 = src.m01 * f10 + src.m11 * f11 + src.m21 * f12;
        float t12 = src.m02 * f10 + src.m12 * f11 + src.m22 * f12;
        float t13 = src.m03 * f10 + src.m13 * f11 + src.m23 * f12;
        dest.m20 = src.m00 * f20 + src.m10 * f21 + src.m20 * f22;
        dest.m21 = src.m01 * f20 + src.m11 * f21 + src.m21 * f22;
        dest.m22 = src.m02 * f20 + src.m12 * f21 + src.m22 * f22;
        dest.m23 = src.m03 * f20 + src.m13 * f21 + src.m23 * f22;
        dest.m00 = t00;
        dest.m01 = t01;
        dest.m02 = t02;
        dest.m03 = t03;
        dest.m10 = t10;
        dest.m11 = t11;
        dest.m12 = t12;
        dest.m13 = t13;
        return dest;
    }

    public static Matrix4f translate(Vector3f vec, Matrix4f matrix) {
        return VectorMath.translate(vec, matrix, matrix);
    }

    public static Matrix4f translate(Vector3f vec, Matrix4f src, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        }
        dest.m30 += src.m00 * vec.x + src.m10 * vec.y + src.m20 * vec.z;
        dest.m31 += src.m01 * vec.x + src.m11 * vec.y + src.m21 * vec.z;
        dest.m32 += src.m02 * vec.x + src.m12 * vec.y + src.m22 * vec.z;
        dest.m33 += src.m03 * vec.x + src.m13 * vec.y + src.m23 * vec.z;
        return dest;
    }
}

