/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model.parts;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import thut.api.maths.vecmath.Vector3f;

public class Material {
    public final String name;
    private final String render_name;
    public String texture;
    public Vector3f diffuseColor;
    public Vector3f specularColor;
    public Vector3f emissiveColor;
    public ResourceLocation tex;
    public float emissiveMagnitude;
    public float ambientIntensity;
    public float shininess;
    public float alpha = 1.0f;
    public boolean transluscent = false;
    public boolean flat = true;
    private int fix_counter = 0;
    IVertexBuilder override_buff = null;
    IRenderTypeBuffer typeBuff = null;
    private final Map<ResourceLocation, RenderType> types = Maps.newHashMap();

    public Material(String name) {
        this.name = name;
        this.render_name = "thutcore:mat_" + name;
    }

    public Material(String name, String texture, Vector3f diffuse, Vector3f specular, Vector3f emissive, float ambient, float shiny) {
        this(name);
        this.texture = texture;
        this.diffuseColor = diffuse;
        this.specularColor = specular;
        this.emissiveColor = emissive;
        this.emissiveMagnitude = Math.min(emissive.x / 0.8f, 1.0f);
        this.ambientIntensity = ambient;
        this.shininess = shiny;
    }

    public void makeVertexBuilder(ResourceLocation texture, IRenderTypeBuffer buffer) {
        RenderType type = this.makeRenderType(texture);
        if (buffer instanceof IRenderTypeBuffer.Impl) {
            IRenderTypeBuffer.Impl impl = (IRenderTypeBuffer.Impl)buffer;
            IVertexBuilder buff = impl.getBuffer(type);
            if (buff == impl.field_228457_a_) {
                BufferBuilder builder = new BufferBuilder(256);
                impl.field_228458_b_.put(type, builder);
                builder.func_181668_a(type.func_228664_q_(), type.func_228663_p_());
                impl.field_228460_d_.add(builder);
                buff = builder;
            }
            this.override_buff = buff;
            this.typeBuff = buffer;
        }
    }

    private RenderType makeRenderType(ResourceLocation tex) {
        boolean transp;
        if (this.types.containsKey(tex) && this.fix_counter++ > 10) {
            return this.types.get(tex);
        }
        this.tex = tex;
        RenderType.State.Builder builder = RenderType.State.func_228694_a_();
        builder.func_228724_a_(new RenderState.TextureState(tex, false, false));
        builder.func_228726_a_(new RenderState.TransparencyState("material_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }, () -> RenderSystem.disableBlend()));
        if (this.emissiveMagnitude == 0.0f) {
            builder.func_228716_a_(new RenderState.DiffuseLightingState(true));
        }
        builder.func_228713_a_(new RenderState.AlphaState(0.003921569f));
        builder.func_228719_a_(new RenderState.LightmapState(true));
        builder.func_228722_a_(new RenderState.OverlayState(true));
        boolean bl = transp = this.alpha < 1.0f || this.transluscent;
        if (transp) {
            if (this.fix_counter < 2) {
                builder.func_228727_a_(new RenderState.WriteMaskState(true, true));
            } else {
                builder.func_228727_a_(new RenderState.WriteMaskState(true, false));
            }
            builder.func_228715_a_(new RenderState.DepthTestState("transp", 513));
        } else {
            builder.func_228714_a_(new RenderState.CullState(false));
        }
        if (!this.flat) {
            builder.func_228723_a_(new RenderState.ShadeModelState(true));
        }
        RenderType.State rendertype$state = builder.func_228728_a_(true);
        String id = this.render_name + tex;
        RenderType.Type type = RenderType.func_228633_a_((String)id, (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)rendertype$state);
        this.types.put(tex, (RenderType)type);
        return type;
    }

    public IVertexBuilder preRender(MatrixStack mat, IVertexBuilder buffer) {
        BufferBuilder builder;
        IVertexBuilder buff;
        IVertexBuilder iVertexBuilder = buff = this.override_buff == null ? buffer : this.override_buff;
        if (buff instanceof BufferBuilder && this.tex != null && !(builder = (BufferBuilder)buff).func_227834_j_()) {
            RenderType type = this.makeRenderType(this.tex);
            builder.func_181668_a(type.func_228664_q_(), type.func_228663_p_());
        }
        return buff;
    }

    public void postRender(MatrixStack mat) {
    }
}

