/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model.parts;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.model.parts.Material;
import thut.core.client.render.texturing.IPartTexturer;
import thut.core.client.render.texturing.TextureCoordinate;

public abstract class Mesh {
    protected final boolean hasTextures;
    public Vertex[] vertices;
    public Vertex[] normals;
    public TextureCoordinate[] textureCoordinates;
    public Integer[] order;
    public int[] rgbabro;
    Material material;
    public String name;
    private final double[] uvShift = new double[]{0.0, 0.0};
    final int GL_FORMAT;
    final Vertex[] normalList;
    private final Vector3f dummy3 = new Vector3f();
    private final Vector4f dummy4 = new Vector4f();

    public Mesh(Integer[] order, Vertex[] vert, Vertex[] norm, TextureCoordinate[] tex, int GL_FORMAT) {
        this.order = order;
        this.vertices = vert;
        this.normals = norm;
        this.textureCoordinates = tex;
        this.hasTextures = tex != null;
        this.GL_FORMAT = GL_FORMAT;
        this.normalList = new Vertex[this.order.length];
        int iter = GL_FORMAT == 4 ? 3 : 4;
        for (int i = 0; i < this.order.length; i += iter) {
            Vertex vertex = this.vertices[this.order[i]];
            thut.api.maths.vecmath.Vector3f v1 = new thut.api.maths.vecmath.Vector3f(vertex.x, vertex.y, vertex.z);
            vertex = this.vertices[this.order[i + 1]];
            thut.api.maths.vecmath.Vector3f v2 = new thut.api.maths.vecmath.Vector3f(vertex.x, vertex.y, vertex.z);
            vertex = this.vertices[this.order[i + 2]];
            thut.api.maths.vecmath.Vector3f v3 = new thut.api.maths.vecmath.Vector3f(vertex.x, vertex.y, vertex.z);
            thut.api.maths.vecmath.Vector3f a = new thut.api.maths.vecmath.Vector3f(v2);
            a.sub(v1);
            thut.api.maths.vecmath.Vector3f b = new thut.api.maths.vecmath.Vector3f(v3);
            b.sub(v1);
            thut.api.maths.vecmath.Vector3f c = new thut.api.maths.vecmath.Vector3f();
            c.cross(a, b);
            c.normalize();
            Vertex normal = new Vertex(c.x, c.y, c.z);
            if (Double.isNaN(normal.x)) {
                normal.x = 0.0f;
                normal.y = 0.0f;
                normal.z = 1.0f;
            }
            this.normalList[i] = normal;
            this.normalList[i + 1] = normal;
            this.normalList[i + 2] = normal;
            if (iter != 4) continue;
            this.normalList[i + 3] = normal;
        }
        this.material = new Material("auto:" + this.name);
    }

    protected void doRender(MatrixStack mat, IVertexBuilder buffer, IPartTexturer texturer) {
        TextureCoordinate textureCoordinate = new TextureCoordinate(0.0f, 0.0f);
        boolean flat = this.material.flat;
        int red = this.rgbabro[0];
        int green = this.rgbabro[1];
        int blue = this.rgbabro[2];
        int alpha = this.rgbabro[3];
        int lightmapUV = this.rgbabro[4];
        int overlayUV = this.rgbabro[5];
        alpha = (int)(this.material.alpha * (float)alpha);
        int n = 0;
        MatrixStack.Entry matrixstack$entry = mat.func_227866_c_();
        Matrix4f pos = matrixstack$entry.func_227870_a_();
        Matrix3f norms = matrixstack$entry.func_227872_b_();
        Vector4f dp = this.dummy4;
        Vector3f dn = this.dummy3;
        for (Integer i : this.order) {
            if (this.hasTextures) {
                textureCoordinate = this.textureCoordinates[i];
            }
            Vertex vertex = this.vertices[i];
            Vertex normal = this.normals[i];
            if (flat) {
                normal = this.normalList[n];
            }
            float x = vertex.x;
            float y = vertex.y;
            float z = vertex.z;
            float nx = normal.x;
            float ny = normal.y;
            float nz = normal.z;
            float u = textureCoordinate.u + (float)this.uvShift[0];
            float v = textureCoordinate.v + (float)this.uvShift[1];
            dp.func_195911_a(x, y, z, 1.0f);
            dp.func_229372_a_(pos);
            dn.func_195905_a(nx, ny, nz);
            dn.func_229188_a_(norms);
            buffer.func_225582_a_((double)dp.func_195910_a(), (double)dp.func_195913_b(), (double)dp.func_195914_c()).func_225586_a_(red, green, blue, alpha).func_225583_a_(u, v).func_227891_b_(overlayUV).func_227886_a_(lightmapUV).func_225584_a_(dn.func_195899_a(), dn.func_195900_b(), dn.func_195902_c()).func_181675_d();
            ++n;
        }
    }

    public void renderShape(MatrixStack mat, IVertexBuilder buffer, IPartTexturer texturer) {
        if (texturer != null) {
            boolean sameName = this.name.equals(this.material.name);
            texturer.shiftUVs(this.material.name, this.uvShift);
            if (texturer.isHidden(this.material.name)) {
                return;
            }
            if (!sameName && texturer.isHidden(this.name)) {
                return;
            }
            texturer.modifiyRGBA(this.material.name, this.rgbabro);
            if (!sameName) {
                texturer.modifiyRGBA(this.name, this.rgbabro);
            }
        }
        buffer = this.material.preRender(mat, buffer);
        if (this.material.emissiveMagnitude > 0.0f) {
            int j = (int)(this.material.emissiveMagnitude * 15.0f);
            this.rgbabro[4] = j << 20 | j << 4;
        }
        this.doRender(mat, buffer, texturer);
        this.material.postRender(mat);
    }

    public void setMaterial(Material material) {
        this.material = material;
        this.name = material.name;
    }
}

