/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.obj;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.AnimationComponent;
import thut.core.client.render.animation.AnimationHelper;
import thut.core.client.render.animation.IAnimationChanger;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.IModel;
import thut.core.client.render.model.IModelCustom;
import thut.core.client.render.model.IModelRenderer;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.model.parts.Material;
import thut.core.client.render.obj.ObjMesh;
import thut.core.client.render.obj.ObjPart;
import thut.core.client.render.texturing.IPartTexturer;
import thut.core.client.render.texturing.IRetexturableModel;
import thut.core.client.render.texturing.TextureCoordinate;
import thut.core.common.ThutCore;

public class ObjModel
implements IModelCustom,
IModel,
IRetexturableModel {
    public HashMap<String, IExtendedModelPart> parts = new HashMap();
    Map<String, Material> mats = Maps.newHashMap();
    Set<String> heads = Sets.newHashSet();
    final IModel.HeadInfo info = new IModel.HeadInfo();
    public String name;
    private boolean valid = false;
    private static final Pattern WHITE_SPACE = Pattern.compile("\\s+");

    public ObjModel() {
    }

    public ObjModel(ResourceLocation l) {
        this();
        this.loadModel(l);
    }

    @Override
    public void applyAnimation(Entity entity, IModelRenderer<?> renderer, float partialTicks, float limbSwing) {
    }

    @Override
    public IModel.HeadInfo getHeadInfo() {
        return this.info;
    }

    @Override
    public Set<String> getHeadParts() {
        return this.heads;
    }

    public HashMap<String, IExtendedModelPart> getParts() {
        return this.parts;
    }

    private boolean isHead(String partName) {
        return this.getHeadParts().contains(partName);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public void loadModel(ResourceLocation model) {
        block3: {
            this.valid = true;
            try {
                IResource res = Minecraft.func_71410_x().func_195551_G().func_199002_a(model);
                if (res == null) {
                    this.valid = false;
                    return;
                }
                this.makeObjects(res.func_199027_b());
                res.close();
            }
            catch (Exception e) {
                this.valid = false;
                if (e instanceof FileNotFoundException) break block3;
                ThutCore.LOGGER.error("error loading " + model, (Object)e.getMessage());
            }
        }
    }

    public HashMap<String, IExtendedModelPart> makeObjects(InputStream stream) throws Exception {
        String line;
        InputStreamReader isReader = new InputStreamReader(stream);
        BufferedReader reader = new BufferedReader(isReader);
        ArrayList vertices = Lists.newArrayList();
        ArrayList normals = Lists.newArrayList();
        ArrayList tex = Lists.newArrayList();
        ArrayList faces = Lists.newArrayList();
        String currentPart = "";
        while ((line = reader.readLine()) != null) {
            Object pos;
            float[] coords;
            if (line.startsWith("#") || line.trim().isEmpty()) continue;
            String[] fields = WHITE_SPACE.split(line, 2);
            String key = fields[0];
            String data = fields[1];
            String[] splitData = WHITE_SPACE.split(data);
            if (key.equalsIgnoreCase("o")) {
                if (!currentPart.isEmpty()) {
                    ArrayList vertices2 = Lists.newArrayList();
                    ArrayList normals2 = Lists.newArrayList();
                    ArrayList tex2 = Lists.newArrayList();
                    ArrayList order = Lists.newArrayList();
                    int i = 0;
                    Iterator iterator = faces.iterator();
                    while (iterator.hasNext()) {
                        int[][] facepair;
                        for (int[] element : facepair = (int[][])iterator.next()) {
                            Vertex v = (Vertex)vertices.get(element[0] - 1);
                            TextureCoordinate coord = (TextureCoordinate)tex.get(element[1] - 1);
                            Vertex norm = new Vertex(0.0f, 0.0f);
                            if (normals.size() > element[0] - 1) {
                                norm = (Vertex)normals.get(element[0] - 1);
                            }
                            vertices2.add(v);
                            normals2.add(norm);
                            tex2.add(coord);
                            order.add(i++);
                        }
                    }
                    ObjMesh mesh = new ObjMesh(order.toArray(new Integer[0]), vertices2.toArray(new Vertex[0]), normals2.toArray(new Vertex[0]), tex2.toArray(new TextureCoordinate[0]));
                    ObjPart part = new ObjPart(currentPart);
                    part.addShape(mesh);
                    this.parts.put(currentPart, part);
                }
                currentPart = data;
            }
            if (key.equalsIgnoreCase("v")) {
                coords = this.parseFloats(splitData);
                pos = new Vertex(coords[0], coords[1] + 1.5f, coords[2]);
                vertices.add(pos);
                continue;
            }
            if (key.equalsIgnoreCase("vn")) {
                coords = this.parseFloats(splitData);
                pos = new Vertex(coords[0], coords[1], coords[2]);
                normals.add(pos);
                continue;
            }
            if (key.equalsIgnoreCase("vt")) {
                coords = this.parseFloats(splitData);
                pos = new TextureCoordinate(coords[0], 1.0f - coords[1]);
                tex.add(pos);
                continue;
            }
            if (!key.equals("f")) continue;
            int[][] facepairs = new int[splitData.length][2];
            for (int i = 0; i < splitData.length; ++i) {
                String[] pts = splitData[i].split("/");
                facepairs[i][0] = Integer.parseInt(pts[0]);
                facepairs[i][1] = Integer.parseInt(pts[1]);
            }
            faces.add(facepairs);
        }
        return this.parts;
    }

    private float[] parseFloats(String[] data) {
        float[] ret = new float[data.length];
        for (int i = 0; i < data.length; ++i) {
            ret[i] = Float.parseFloat(data[i]);
        }
        return ret;
    }

    @Override
    public void preProcessAnimations(Collection<List<Animation>> animations) {
        for (List<Animation> list : animations) {
            for (Animation animation : list) {
                for (String s : animation.sets.keySet()) {
                    ArrayList<AnimationComponent> components = animation.sets.get(s);
                    for (AnimationComponent comp : components) {
                        double d0 = comp.posOffset[0] / 16.0;
                        double d1 = comp.posOffset[1] / 16.0;
                        double d2 = comp.posOffset[2] / 16.0;
                        comp.posOffset[0] = -d0;
                        comp.posOffset[1] = d2;
                        comp.posOffset[2] = -d1;
                        d0 = comp.posChange[0] / 16.0;
                        d1 = comp.posChange[1] / 16.0;
                        d2 = comp.posChange[2] / 16.0;
                        comp.posChange[0] = -d0;
                        comp.posChange[1] = d2;
                        comp.posChange[2] = -d1;
                    }
                }
            }
        }
    }

    @Override
    public void renderAll(MatrixStack mat, IVertexBuilder buffer) {
        for (IExtendedModelPart o : this.parts.values()) {
            if (o.getParent() != null) continue;
            o.renderAll(mat, buffer);
        }
    }

    @Override
    public void renderAllExcept(MatrixStack mat, IVertexBuilder buffer, String ... excludedGroupNames) {
        for (IExtendedModelPart o : this.parts.values()) {
            if (o.getParent() != null) continue;
            o.renderAllExcept(mat, buffer, excludedGroupNames);
        }
    }

    @Override
    public void renderOnly(MatrixStack mat, IVertexBuilder buffer, String ... groupNames) {
        for (IExtendedModelPart o : this.parts.values()) {
            if (o.getParent() != null) continue;
            o.renderOnly(mat, buffer, groupNames);
        }
    }

    @Override
    public void renderPart(MatrixStack mat, IVertexBuilder buffer, String partName) {
        for (IExtendedModelPart o : this.parts.values()) {
            if (o.getParent() != null) continue;
            o.renderPart(mat, buffer, partName);
        }
    }

    @Override
    public void setAnimationChanger(IAnimationChanger changer) {
        for (IExtendedModelPart part : this.parts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            ((IRetexturableModel)((Object)part)).setAnimationChanger(changer);
        }
    }

    @Override
    public void setTexturer(IPartTexturer texturer) {
        for (IExtendedModelPart part : this.parts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            ((IRetexturableModel)((Object)part)).setTexturer(texturer);
        }
    }

    protected void updateAnimation(Entity entity, IModelRenderer<?> renderer, String currentPhase, float partialTicks, float headYaw, float headPitch, float limbSwing, int brightness) {
        for (String partName : ((HashMap)this.getParts()).keySet()) {
            IExtendedModelPart part = (IExtendedModelPart)((HashMap)this.getParts()).get(partName);
            this.updateSubParts(entity, renderer, currentPhase, partialTicks, part, headYaw, headPitch, limbSwing, brightness);
        }
    }

    @Override
    public void globalFix(MatrixStack mat, float dx, float dy, float dz) {
        mat.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        mat.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        mat.func_227861_a_(0.0, -1.5, 0.0);
    }

    private void updateSubParts(Entity entity, IModelRenderer<?> renderer, String currentPhase, float partialTick, IExtendedModelPart parent, float headYaw, float headPitch, float limbSwing, int brightnessIn) {
        if (parent == null) {
            return;
        }
        IModel.HeadInfo info = this.getHeadInfo();
        parent.resetToInit();
        boolean anim = renderer.getAnimations().containsKey(currentPhase);
        if (!anim || AnimationHelper.doAnimation(renderer.getAnimations().get(currentPhase), entity, parent.getName(), parent, partialTick, limbSwing)) {
            // empty if block
        }
        if (info != null && this.isHead(parent.getName())) {
            float ang2 = -info.headPitch;
            float head = info.headYaw + 180.0f;
            float diff = 0.0f;
            if (info.yawDirection != -1) {
                head *= -1.0f;
            }
            diff = head % 360.0f;
            diff = (diff + 360.0f) % 360.0f;
            diff = (diff - 180.0f) % 360.0f;
            diff = Math.max(diff, info.yawCapMin);
            float ang = diff = Math.min(diff, info.yawCapMax);
            ang2 = Math.max(ang2, info.pitchCapMin);
            ang2 = Math.min(ang2, info.pitchCapMax);
            Vector4 dir = info.yawAxis == 0 ? new Vector4(info.yawDirection, 0.0, 0.0, ang) : (info.yawAxis == 2 ? new Vector4(0.0, 0.0, info.yawDirection, ang) : new Vector4(0.0, info.yawDirection, 0.0, ang));
            Vector4 dir2 = info.pitchAxis == 2 ? new Vector4(0.0, 0.0, info.yawDirection, ang2) : (info.pitchAxis == 1 ? new Vector4(0.0, info.yawDirection, 0.0, ang2) : new Vector4(info.yawDirection, 0.0, 0.0, ang2));
            Vector4 combined = new Vector4();
            combined.mul(dir.toQuaternion(), dir2.toQuaternion());
            parent.setPostRotations(combined);
        }
        for (String partName : parent.getSubParts().keySet()) {
            IExtendedModelPart part = (IExtendedModelPart)parent.getSubParts().get(partName);
            this.updateSubParts(entity, renderer, currentPhase, partialTick, part, headYaw, headPitch, limbSwing, brightnessIn);
        }
    }
}

