/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.particle;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import thut.api.maths.Vector3;
import thut.api.maths.vecmath.Vector3f;
import thut.api.particle.ParticleBase;
import thut.api.particle.ParticleNoGravity;
import thut.api.particle.ThutParticles;

@OnlyIn(value=Dist.CLIENT)
public class ParticleFactories {
    public static final RenderType TYPE = new RenderType();
    public static final IParticleFactory<ParticleBase> GENERICFACTORY = (type, world, x, y, z, vx, vy, vz) -> {
        type = ThutParticles.clone(type);
        type.setVelocity(Vector3.getNewVector().set(vx, vy, vz));
        type.setPosition(Vector3.getNewVector().set(x, y, z));
        return new ThutParticle((World)world, (ParticleBase)type);
    };

    public static class ThutParticle
    extends Particle {
        final ParticleBase particle;
        final World field_187122_b;

        protected ThutParticle(World worldIn, ParticleBase particleIn) {
            super((ClientWorld)worldIn, particleIn.position.x, particleIn.position.y, particleIn.position.z);
            this.particle = particleIn;
            this.field_187122_b = worldIn;
            if (this.particle instanceof ParticleNoGravity) {
                this.field_70545_g = 0.0f;
            }
            this.field_187129_i = this.particle.velocity.x;
            this.field_187130_j = this.particle.velocity.z;
            this.field_187131_k = this.particle.velocity.y;
            this.func_187114_a(this.particle.lifetime);
        }

        public int func_206254_h() {
            return this.particle.lifetime;
        }

        public IParticleRenderType func_217558_b() {
            return TYPE;
        }

        public boolean func_187113_k() {
            return this.particle.getDuration() >= 0;
        }

        public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
            Vector3d vec3d = renderInfo.func_216785_c();
            float x = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - vec3d.field_72450_a);
            float y = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - vec3d.field_72448_b);
            float z = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - vec3d.field_72449_c);
            Vector3f source = new Vector3f(x, y, z);
            this.particle.renderParticle(buffer, renderInfo, partialTicks, source);
        }

        public void func_189213_a() {
            this.field_70546_d = 0;
            super.func_189213_a();
            this.particle.setDuration(this.particle.getDuration() - 1);
            this.particle.setLastTick(this.field_187122_b.func_82737_E());
            if (this.particle.getDuration() < 0) {
                this.particle.kill();
                this.func_187112_i();
            }
        }
    }

    public static class RenderType
    implements IParticleRenderType {
        public void func_217600_a(BufferBuilder builder, TextureManager textures) {
            textures.func_110577_a(ParticleBase.TEXTUREMAP);
            builder.func_181668_a(7, DefaultVertexFormats.field_227852_q_);
        }

        public void func_217599_a(Tessellator tes) {
            tes.func_78381_a();
        }
    }
}

