/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.wrappers;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import thut.api.ModelHolder;
import thut.api.entity.IMobColourable;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.AnimationHelper;
import thut.core.client.render.animation.AnimationXML;
import thut.core.client.render.animation.IAnimationChanger;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.IModel;
import thut.core.client.render.model.IModelRenderer;
import thut.core.client.render.model.ModelFactory;
import thut.core.client.render.texturing.IRetexturableModel;
import thut.core.common.mobs.DefaultColourable;

public class ModelWrapper<T extends Entity>
extends EntityModel<T>
implements IModel {
    private static final IModel.HeadInfo DUMMY = new IModel.HeadInfo();
    public final ModelHolder model;
    public final IModelRenderer<?> renderer;
    public IModel imodel;
    private T entityIn;
    protected float rotationPointX = 0.0f;
    protected float rotationPointY = 0.0f;
    protected float rotationPointZ = 0.0f;
    protected float rotateAngleX = 0.0f;
    protected float rotateAngleY = 0.0f;
    protected float rotateAngleZ = 0.0f;
    protected float rotateAngle = 0.0f;
    private final int[] tmp = new int[4];
    private final IModelRenderer.Vector5 rots = new IModelRenderer.Vector5();

    public ModelWrapper(ModelHolder model, IModelRenderer<?> renderer) {
        this.model = model;
        this.renderer = renderer;
    }

    @Override
    public void applyAnimation(Entity entity, IModelRenderer<?> renderer, float partialTicks, float limbSwing) {
        if (!this.isLoaded()) {
            return;
        }
        this.imodel.applyAnimation(entity, renderer, partialTicks, limbSwing);
    }

    @Override
    public IModel.HeadInfo getHeadInfo() {
        if (!this.isLoaded()) {
            return DUMMY;
        }
        return this.imodel.getHeadInfo();
    }

    @Override
    public Set<String> getHeadParts() {
        if (!this.isLoaded()) {
            return Collections.emptySet();
        }
        return this.imodel.getHeadParts();
    }

    @Override
    public Map<String, IExtendedModelPart> getParts() {
        if (!this.isLoaded()) {
            return Collections.emptyMap();
        }
        return this.imodel.getParts();
    }

    @Override
    public boolean isValid() {
        if (this.imodel == null) {
            return true;
        }
        return this.imodel.isValid();
    }

    @Override
    public boolean isLoaded() {
        if (this.imodel == null) {
            return false;
        }
        return this.imodel.isLoaded();
    }

    @Override
    public void preProcessAnimations(Collection<List<Animation>> collection) {
        if (!this.isLoaded()) {
            return;
        }
        this.imodel.preProcessAnimations(collection);
    }

    private void initColours(IExtendedModelPart parent, T entity, int brightness, int overlay) {
        IAnimationChanger animChanger;
        int red = 255;
        int green = 255;
        int blue = 255;
        int alpha = 255;
        IMobColourable poke = (IMobColourable)entity.getCapability(DefaultColourable.CAPABILITY).orElse(null);
        if (poke != null) {
            red = poke.getRGBA()[0];
            green = poke.getRGBA()[1];
            blue = poke.getRGBA()[2];
            alpha = poke.getRGBA()[3];
        }
        if ((animChanger = this.renderer.getAnimationChanger()) != null && animChanger.modifyColourForPart(parent.getName(), (Entity)entity, this.tmp)) {
            red = this.tmp[0];
            green = this.tmp[1];
            blue = this.tmp[2];
            alpha = this.tmp[3];
        }
        parent.setRGBABrO(red, green, blue, alpha, brightness, overlay);
        for (String partName : parent.getSubParts().keySet()) {
            IExtendedModelPart part = (IExtendedModelPart)parent.getSubParts().get(partName);
            this.initColours(part, entity, brightness, overlay);
        }
    }

    public void func_225597_a_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.imodel == null) {
            this.imodel = ModelFactory.create(this.model);
        }
        if (!this.isLoaded()) {
            return;
        }
        this.entityIn = entityIn;
        IModel.HeadInfo info = this.imodel.getHeadInfo();
        if (info != null) {
            info.headPitch = headPitch;
            info.headYaw = netHeadYaw;
        }
        if (info != null) {
            info.currentTick = ((Entity)entityIn).field_70173_aa;
        }
        IAnimationChanger animChanger = this.renderer.getAnimationChanger();
        HashSet excluded = Sets.newHashSet();
        if (animChanger != null) {
            for (String partName : this.imodel.getParts().keySet()) {
                if (animChanger.isPartHidden(partName, (Entity)entityIn, false)) {
                    excluded.add(partName);
                }
                if (this.renderer.getTexturer() == null) continue;
                this.renderer.getTexturer().bindObject(entityIn);
            }
        }
        if (info != null) {
            info.lastTick = ((Entity)entityIn).field_70173_aa;
        }
    }

    public void func_225598_a_(MatrixStack mat, IVertexBuilder buffer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.imodel == null) {
            this.imodel = ModelFactory.create(this.model);
        }
        if (!this.isLoaded()) {
            return;
        }
        mat.func_227860_a_();
        this.transformGlobal(mat, buffer, this.renderer.getAnimation((Entity)this.entityIn), (Entity)this.entityIn, Minecraft.func_71410_x().func_184121_ak());
        IAnimationChanger animChanger = this.renderer.getAnimationChanger();
        HashSet excluded = Sets.newHashSet();
        if (animChanger != null) {
            for (String partName : this.imodel.getParts().keySet()) {
                if (animChanger.isPartHidden(partName, (Entity)this.entityIn, false)) {
                    excluded.add(partName);
                }
                if (this.renderer.getTexturer() == null) continue;
                this.renderer.getTexturer().bindObject(this.entityIn);
            }
        }
        for (String partName : this.imodel.getParts().keySet()) {
            IExtendedModelPart part = this.imodel.getParts().get(partName);
            if (part == null) continue;
            try {
                if (part instanceof IRetexturableModel) {
                    ((IRetexturableModel)((Object)part)).setTexturer(this.renderer.getTexturer());
                }
                if (part.getParent() != null) continue;
                mat.func_227860_a_();
                this.initColours(part, this.entityIn, packedLightIn, packedOverlayIn);
                part.renderAllExcept(mat, buffer, this.renderer, excluded.toArray(new String[excluded.size()]));
                mat.func_227865_b_();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        mat.func_227865_b_();
    }

    protected void rotate(MatrixStack mat) {
        Vector3f axis = new Vector3f(this.rotateAngleX, this.rotateAngleY, this.rotateAngleZ);
        mat.func_227863_a_(new Quaternion(axis, this.rotateAngle, true));
    }

    public void func_212843_a_(T entityIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        if (this.imodel == null) {
            this.imodel = ModelFactory.create(this.model);
        }
        if (!this.isLoaded()) {
            return;
        }
        this.renderer.setAnimationHolder(AnimationHelper.getHolder(entityIn));
        if (this.renderer.getAnimationChanger() != null) {
            this.renderer.setAnimation((Entity)entityIn, partialTickTime);
        }
        this.applyAnimation((Entity)entityIn, this.renderer, partialTickTime, limbSwing);
    }

    @Override
    public void setOffset(Vector3 point) {
        this.setRotationPoint((float)point.x, (float)point.y, (float)point.z);
    }

    public void setRotationAngles(Vector4 rotations) {
        this.rotateAngle = rotations.w;
        this.rotateAngleX = rotations.x;
        this.rotateAngleY = rotations.y;
        this.rotateAngleZ = rotations.z;
    }

    public void setRotationPoint(float par1, float par2, float par3) {
        this.rotationPointX = par1;
        this.rotationPointY = par2;
        this.rotationPointZ = par3;
    }

    protected void transformGlobal(MatrixStack mat, IVertexBuilder buffer, String currentPhase, Entity entity, float partialTick) {
        IModelRenderer.Vector5 rotations = this.renderer.getRotations();
        if (rotations == null) {
            rotations = this.rots;
        }
        this.setRotationAngles(rotations.rotations);
        this.setOffset(this.renderer.getRotationOffset());
        this.rotate(mat);
        this.imodel.globalFix(mat, this.rotationPointX, this.rotationPointY, this.rotationPointZ);
        this.translate(mat);
        this.renderer.scaleEntity(mat, entity, this, partialTick);
    }

    private void translate(MatrixStack mat) {
        mat.func_227861_a_((double)this.rotationPointX, (double)this.rotationPointY, (double)this.rotationPointZ);
    }

    @Override
    public void updateMaterial(AnimationXML.Mat mat) {
        this.imodel.updateMaterial(mat);
        IModel.super.updateMaterial(mat);
    }
}

