/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import thut.core.common.ThutCore;
import thut.core.common.config.Configure;

public class Config {
    private static ForgeConfigSpec[] initConfigSpecs(IConfigHolder holder) {
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
        ArrayList commonList = Lists.newArrayList();
        ArrayList clientList = Lists.newArrayList();
        ArrayList serverList = Lists.newArrayList();
        block5: for (Field field : holder.getClass().getDeclaredFields()) {
            Configure conf = field.getAnnotation(Configure.class);
            if (conf == null) continue;
            switch (conf.type()) {
                case CLIENT: {
                    clientList.add(field);
                    field.setAccessible(true);
                    continue block5;
                }
                case COMMON: {
                    commonList.add(field);
                    field.setAccessible(true);
                    continue block5;
                }
                case SERVER: {
                    serverList.add(field);
                    field.setAccessible(true);
                    continue block5;
                }
            }
        }
        Comparator comp = (o1, o2) -> {
            Configure conf1 = o1.getAnnotation(Configure.class);
            Configure conf2 = o2.getAnnotation(Configure.class);
            int diff = conf1.category().compareTo(conf2.category());
            if (diff == 0) {
                diff = o1.getName().compareTo(o2.getName());
            }
            return diff;
        };
        Collections.sort(commonList, comp);
        Collections.sort(clientList, comp);
        Collections.sort(serverList, comp);
        Config.build(COMMON_BUILDER, commonList, holder, ModConfig.Type.COMMON);
        Config.build(SERVER_BUILDER, serverList, holder, ModConfig.Type.SERVER);
        Config.build(CLIENT_BUILDER, clientList, holder, ModConfig.Type.CLIENT);
        ForgeConfigSpec COMMON_CONFIG_SPEC = commonList.isEmpty() ? null : COMMON_BUILDER.pop().build();
        ForgeConfigSpec CLIENT_CONFIG_SPEC = clientList.isEmpty() ? null : CLIENT_BUILDER.pop().build();
        ForgeConfigSpec SERVER_CONFIG_SPEC = serverList.isEmpty() ? null : SERVER_BUILDER.pop().build();
        return new ForgeConfigSpec[]{COMMON_CONFIG_SPEC, CLIENT_CONFIG_SPEC, SERVER_CONFIG_SPEC};
    }

    private static void build(ForgeConfigSpec.Builder builder, List<Field> fields, IConfigHolder holder, ModConfig.Type type) {
        String cat = "";
        for (Field field : fields) {
            try {
                Configure conf = field.getAnnotation(Configure.class);
                if (!cat.equals(conf.category())) {
                    if (!cat.isEmpty()) {
                        builder.pop();
                    }
                    cat = conf.category();
                    builder.push(cat);
                    builder.translation(ModLoadingContext.get().getActiveNamespace() + ".config." + cat);
                }
                if (!conf.comment().isEmpty()) {
                    builder.comment(conf.comment());
                } else {
                    builder.translation(ModLoadingContext.get().getActiveNamespace() + ".config." + field.getName() + ".tooltip");
                }
                Object o = field.get(holder);
                holder.init(type, field, builder.define(field.getName(), o));
            }
            catch (Exception e) {
                ThutCore.LOGGER.error("Error getting field " + field, (Throwable)e);
            }
        }
    }

    private static void loadConfig(IConfigHolder holder, ForgeConfigSpec spec, Path path) {
        ThutCore.LOGGER.debug("Loading config file {}", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    public static void setupConfigs(IConfigHolder holder, String subfolder, String prefix) {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register((Object)holder);
        ForgeConfigSpec[] specs = Config.initConfigSpecs(holder);
        ForgeConfigSpec COMMON_CONFIG_SPEC = specs[0];
        ForgeConfigSpec CLIENT_CONFIG_SPEC = specs[1];
        ForgeConfigSpec SERVER_CONFIG__SPEC = specs[2];
        File commonfile = new File(subfolder, prefix + "-common.toml");
        File clientfile = new File(subfolder, prefix + "-client.toml");
        File serverfile = new File(prefix + "-server.toml");
        Path common = FMLPaths.CONFIGDIR.get().resolve(subfolder).resolve(prefix + "-common.toml");
        Path client = FMLPaths.CONFIGDIR.get().resolve(subfolder).resolve(prefix + "-client.toml");
        Path server = FMLPaths.CONFIGDIR.get().resolve(prefix + "-server.toml");
        if (COMMON_CONFIG_SPEC != null || CLIENT_CONFIG_SPEC != null) {
            common.toFile().getParentFile().mkdirs();
        }
        if (COMMON_CONFIG_SPEC != null) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, COMMON_CONFIG_SPEC, commonfile.toString());
        }
        if (CLIENT_CONFIG_SPEC != null) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CLIENT_CONFIG_SPEC, clientfile.toString());
        }
        if (SERVER_CONFIG__SPEC != null) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_CONFIG__SPEC, serverfile.toString());
        }
        if (COMMON_CONFIG_SPEC != null) {
            Config.loadConfig(holder, COMMON_CONFIG_SPEC, common);
        }
        if (CLIENT_CONFIG_SPEC != null) {
            Config.loadConfig(holder, CLIENT_CONFIG_SPEC, client);
        }
        if (SERVER_CONFIG__SPEC != null) {
            Config.loadConfig(holder, SERVER_CONFIG__SPEC, server);
        }
        holder.onUpdated();
    }

    public static interface IConfigHolder {
        public void init(ModConfig.Type var1, Field var2, ForgeConfigSpec.ConfigValue<?> var3);

        public void onUpdated();

        public void read(ModConfig var1);

        public void write();
    }

    public static abstract class ConfigData
    implements IConfigHolder {
        public final String MODID;
        private ModConfig COMMON_CONFIG;
        private ModConfig SERVER_CONFIG;
        private ModConfig CLIENT_CONFIG;
        public Map<Field, ForgeConfigSpec.ConfigValue<?>> commonValues = Maps.newHashMap();
        public Map<Field, ForgeConfigSpec.ConfigValue<?>> clientValues = Maps.newHashMap();
        public Map<Field, ForgeConfigSpec.ConfigValue<?>> serverValues = Maps.newHashMap();

        public ConfigData(String MODID) {
            this.MODID = MODID;
        }

        @Override
        public void init(ModConfig.Type type, Field field, ForgeConfigSpec.ConfigValue<?> val) {
            switch (type) {
                case CLIENT: {
                    this.clientValues.put(field, val);
                    break;
                }
                case COMMON: {
                    this.commonValues.put(field, val);
                    break;
                }
                case SERVER: {
                    this.serverValues.put(field, val);
                    break;
                }
            }
        }

        @SubscribeEvent
        public void onFileChange(ModConfig.Reloading configEvent) {
            ThutCore.LOGGER.debug("{} config belongs to us!", (Object)configEvent.getConfig().getFileName());
            if (configEvent.getConfig().getConfigData() instanceof CommentedFileConfig) {
                ((CommentedFileConfig)configEvent.getConfig().getConfigData()).load();
            }
            this.read(configEvent.getConfig());
        }

        @SubscribeEvent
        public void onLoad(ModConfig.Loading configEvent) {
            ThutCore.LOGGER.info("Loaded {} config file {}", (Object)this.MODID, (Object)configEvent.getConfig().getFileName());
            this.read(configEvent.getConfig());
        }

        @Override
        public void read(ModConfig modConfig) {
            Map<Field, ForgeConfigSpec.ConfigValue<?>> values;
            ModConfig.Type type = modConfig.getType();
            switch (type) {
                case CLIENT: {
                    values = this.clientValues;
                    this.CLIENT_CONFIG = modConfig;
                    break;
                }
                case COMMON: {
                    values = this.commonValues;
                    this.COMMON_CONFIG = modConfig;
                    break;
                }
                case SERVER: {
                    values = this.serverValues;
                    this.SERVER_CONFIG = modConfig;
                    break;
                }
                default: {
                    return;
                }
            }
            if (this.read(modConfig, values)) {
                this.onUpdated();
            }
        }

        private boolean read(ModConfig config, Map<Field, ForgeConfigSpec.ConfigValue<?>> values) {
            ThutCore.LOGGER.info("Reading {}", (Object)config.getFileName());
            boolean changed = false;
            for (Field f : values.keySet()) {
                try {
                    f.setAccessible(true);
                    Object ours = f.get(this);
                    Object o = values.get(f).get();
                    if (ours.equals(o)) continue;
                    ThutCore.LOGGER.info("Set {} to {}", (Object)f.getName(), o);
                    f.set(this, o);
                    changed = true;
                }
                catch (Exception e) {
                    ThutCore.LOGGER.error("Error updating config value for " + f, (Throwable)e);
                }
            }
            return changed;
        }

        public void updateField(Field field, Object update) throws Exception {
            field.getAnnotation(Configure.class);
            if (field.getType() == Long.TYPE || field.getType() == Long.class) {
                field.set(this, Long.parseLong((String)update));
            } else if (field.getType() == String.class) {
                field.set(this, update);
            } else if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                field.set(this, Integer.parseInt((String)update));
            } else if (field.getType() == Float.TYPE || field.getType() == Float.class) {
                field.set(this, Float.valueOf(Float.parseFloat((String)update)));
            } else if (field.getType() == Double.TYPE || field.getType() == Double.class) {
                field.set(this, Double.parseDouble((String)update));
            } else if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                field.set(this, Boolean.parseBoolean((String)update));
            } else {
                Object o = field.get(this);
                if (o instanceof String[]) {
                    String[] vars = update instanceof String ? ((String)update).split("``") : (String[])update;
                    field.set(this, vars);
                } else if (o instanceof List && !((List)o).isEmpty() && ((List)o).get(0) instanceof String) {
                    List list = (List)o;
                    String[] vars = update instanceof String ? ((String)update).split("``") : (String[])update;
                    list.clear();
                    for (String s : vars) {
                        list.add(s);
                    }
                } else if (o instanceof int[]) {
                    String[] vars = update instanceof String ? ((String)update).split("``") : (update instanceof String[] ? (String[])update : null);
                    int[] toSet = null;
                    if (vars == null) {
                        toSet = (int[])update;
                    } else {
                        toSet = new int[vars.length];
                        for (int i = 0; i < vars.length; ++i) {
                            toSet[i] = Integer.parseInt(vars[i].trim());
                        }
                    }
                    field.set(this, toSet);
                } else {
                    System.err.println("Unknown Type " + field.getType() + " " + field.getName() + " " + o.getClass());
                }
            }
            this.onUpdated();
            this.write();
        }

        @Override
        public void write() {
            this.write(this.CLIENT_CONFIG, this.clientValues);
            this.write(this.COMMON_CONFIG, this.commonValues);
            this.write(this.SERVER_CONFIG, this.serverValues);
        }

        private boolean write(ModConfig config, Map<Field, ForgeConfigSpec.ConfigValue<?>> values) {
            boolean ret = false;
            for (Field f : values.keySet()) {
                try {
                    Object ours = f.get(this);
                    Object val = values.get(f).get();
                    if (ours.equals(val)) continue;
                    config.getConfigData().set(values.get(f).getPath(), ours);
                    ret = true;
                }
                catch (Exception e) {
                    ThutCore.LOGGER.error("Error saving config value for " + f, (Throwable)e);
                }
            }
            return ret;
        }
    }
}

