/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.genetics;

import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import thut.api.entity.genetics.Alleles;
import thut.api.entity.genetics.IMobGenetics;
import thut.core.common.ThutCore;

public class DefaultGeneStorage
implements Capability.IStorage<IMobGenetics> {
    public void readNBT(Capability<IMobGenetics> capability, IMobGenetics instance, Direction side, INBT nbt) {
        ListNBT list = (ListNBT)nbt;
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            Alleles alleles = new Alleles();
            ResourceLocation key = new ResourceLocation(tag.func_74779_i("K"));
            try {
                alleles.load(tag.func_74775_l("V"));
                instance.getAlleles().put(key, alleles);
                continue;
            }
            catch (Exception e) {
                ThutCore.LOGGER.error("Error loading gene for key: " + key, (Throwable)e);
            }
        }
    }

    public INBT writeNBT(Capability<IMobGenetics> capability, IMobGenetics instance, Direction side) {
        ListNBT genes = new ListNBT();
        for (Map.Entry<ResourceLocation, Alleles> entry : instance.getAlleles().entrySet()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("K", entry.getKey().toString());
            tag.func_218657_a("V", (INBT)entry.getValue().save());
            genes.add((Object)tag);
        }
        return genes;
    }
}

