/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.handlers;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import thut.api.boom.ExplosionCustom;
import thut.api.entity.blockentity.BlockEntityUpdater;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.maths.Cruncher;
import thut.api.terrain.TerrainSegment;
import thut.core.common.config.Config;
import thut.core.common.config.Configure;
import thut.core.common.terrain.ConfigTerrainBuilder;
import thut.core.common.terrain.ConfigTerrainChecker;

public class ConfigHandler
extends Config.ConfigData {
    private static final String BOOMS = "explosions";
    private static final String BIOMES = "biomes";
    private static final String BLOCKENTITY = "blockentity";
    private static final String MISC = "misc";
    private static final String CLIENT = "client";
    @Configure(category="explosions")
    public int maxMsPerTick = 25;
    @Configure(category="explosions")
    public int explosionRadius = 127;
    @Configure(category="explosions")
    public double minBlastEffect = 0.25;
    @Configure(category="explosions")
    public boolean affectAir = true;
    @Configure(category="explosions")
    public boolean generateCache = true;
    @Configure(category="biomes")
    public boolean resetAllTerrain = false;
    @Configure(category="biomes")
    public List<String> customBiomeMappings = Lists.newArrayList();
    @Configure(category="blockentity")
    public List<String> teblacklist = Lists.newArrayList();
    @Configure(category="blockentity")
    public List<String> blockblacklist = Lists.newArrayList((Object[])new String[]{"minecraft:bedrock"});
    @Configure(category="blockentity")
    public boolean autoBlacklistErroredTEs = true;
    @Configure(category="misc")
    public boolean debug = true;
    @Configure(category="client")
    public boolean asyncModelLoads = true;

    public ConfigHandler() {
        super("thutcore");
    }

    @Override
    public void onUpdated() {
        ExplosionCustom.MAX_RADIUS = this.explosionRadius;
        ExplosionCustom.AFFECTINAIR = this.affectAir;
        ExplosionCustom.MAXPERTICK = this.maxMsPerTick;
        ExplosionCustom.MINBLASTDAMAGE = (float)this.minBlastEffect;
        TerrainSegment.noLoad = this.resetAllTerrain;
        IBlockEntity.TEBLACKLIST.clear();
        BlockEntityUpdater.autoBlacklist = this.autoBlacklistErroredTEs;
        for (String s : this.teblacklist) {
            if (!s.contains(":")) {
                s = "minecraft:" + s;
            }
            IBlockEntity.TEBLACKLIST.add(s);
            IBlockEntity.TEBLACKLIST.add(s.toLowerCase(Locale.ENGLISH));
        }
        for (String s : this.blockblacklist) {
            IBlockEntity.BLOCKBLACKLIST.add(new ResourceLocation(s));
        }
        TerrainSegment.biomeCheckers.removeIf(t -> t instanceof ConfigTerrainChecker);
        ConfigTerrainBuilder.process(this.customBiomeMappings);
        if (this.generateCache) {
            Cruncher.init();
        }
    }
}

