/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.handlers;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import thut.core.common.ThutCore;

public class PlayerDataHandler {
    private static Set<Class<? extends PlayerData>> dataMap = Sets.newHashSet();
    private static Set<String> dataIds = Sets.newHashSet();
    private static PlayerDataHandler INSTANCESERVER;
    private static PlayerDataHandler INSTANCECLIENT;
    private final Map<String, PlayerDataManager> data = Maps.newHashMap();

    public static void clear() {
        if (INSTANCECLIENT != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCECLIENT);
        }
        if (INSTANCESERVER != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCESERVER);
        }
        INSTANCESERVER = null;
        INSTANCECLIENT = null;
    }

    public static Set<String> getDataIDs() {
        if (dataIds.size() != dataMap.size()) {
            for (Class<? extends PlayerData> type : dataMap) {
                try {
                    PlayerData toAdd = type.newInstance();
                    dataIds.add(toAdd.getIdentifier());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
        return dataIds;
    }

    public static File getFileForUUID(String uuid, String fileName) {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        Path path = Paths.get(server.func_71238_n().toURI());
        if (!server.func_71262_S()) {
            path = path.resolve("saves");
        }
        path = path.resolve(server.func_240793_aU_().func_76065_j());
        path = path.resolve("thutcore").resolve("uuid");
        File dir = path.toFile();
        File file = (path = path.resolve(fileName + ".dat")).toFile();
        if (!file.exists()) {
            dir.mkdirs();
        }
        return file;
    }

    public static PlayerDataHandler getInstance() {
        if (ThutCore.proxy.isClientSide()) {
            return INSTANCECLIENT != null ? INSTANCECLIENT : (INSTANCECLIENT = new PlayerDataHandler());
        }
        return INSTANCESERVER != null ? INSTANCESERVER : (INSTANCESERVER = new PlayerDataHandler());
    }

    public static void register(Class<? extends PlayerData> data) {
        dataMap.add(data);
    }

    public static void saveCustomData(PlayerEntity player) {
        PlayerDataHandler.saveCustomData(player.func_189512_bd());
    }

    public static void saveCustomData(String cachedUniqueIdString) {
        PlayerDataHandler.getInstance().save(cachedUniqueIdString, "misc");
    }

    public PlayerDataHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void cleanupOfflineData(WorldEvent.Save event) {
        HashSet toUnload = Sets.newHashSet();
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        for (String uuid : this.data.keySet()) {
            ServerPlayerEntity player = server.func_184103_al().func_177451_a(UUID.fromString(uuid));
            if (player != null) continue;
            toUnload.add(uuid);
        }
        for (String s : toUnload) {
            this.save(s);
            this.data.remove(s);
        }
    }

    public PlayerDataManager getPlayerData(PlayerEntity player) {
        return this.getPlayerData(player.func_189512_bd());
    }

    public PlayerDataManager getPlayerData(String uuid) {
        PlayerDataManager manager = this.data.get(uuid);
        if (manager == null) {
            manager = this.load(uuid);
        }
        return manager;
    }

    public PlayerDataManager getPlayerData(UUID uniqueID) {
        return this.getPlayerData(uniqueID.toString());
    }

    public PlayerDataManager load(String uuid) {
        PlayerDataManager manager = new PlayerDataManager(uuid);
        if (this == INSTANCESERVER) {
            for (PlayerData data : manager.data.values()) {
                String fileName = data.dataFileName();
                File file = null;
                try {
                    file = PlayerDataHandler.getFileForUUID(uuid, fileName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (file == null || !file.exists()) continue;
                try {
                    FileInputStream fileinputstream = new FileInputStream(file);
                    CompoundNBT CompoundNBT2 = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                    fileinputstream.close();
                    data.readFromNBT(CompoundNBT2.func_74775_l("Data"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.data.put(uuid, manager);
        return manager;
    }

    public void save(String uuid) {
        PlayerDataManager manager = this.data.get(uuid);
        if (manager != null && this == INSTANCESERVER) {
            for (PlayerData data : manager.data.values()) {
                String fileName = data.dataFileName();
                File file = PlayerDataHandler.getFileForUUID(uuid, fileName);
                if (file == null) continue;
                CompoundNBT CompoundNBT2 = new CompoundNBT();
                data.writeToNBT(CompoundNBT2);
                CompoundNBT CompoundNBT1 = new CompoundNBT();
                CompoundNBT1.func_218657_a("Data", (INBT)CompoundNBT2);
                try {
                    FileOutputStream fileoutputstream = new FileOutputStream(file);
                    CompressedStreamTools.func_74799_a((CompoundNBT)CompoundNBT1, (OutputStream)fileoutputstream);
                    fileoutputstream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void save(String uuid, String dataType) {
        PlayerDataManager manager = this.data.get(uuid);
        if (manager != null && this == INSTANCESERVER) {
            for (PlayerData data : manager.data.values()) {
                String fileName;
                File file;
                if (!data.getIdentifier().equals(dataType) || (file = PlayerDataHandler.getFileForUUID(uuid, fileName = data.dataFileName())) == null) continue;
                CompoundNBT CompoundNBT2 = new CompoundNBT();
                data.writeToNBT(CompoundNBT2);
                CompoundNBT CompoundNBT1 = new CompoundNBT();
                CompoundNBT1.func_218657_a("Data", (INBT)CompoundNBT2);
                try {
                    FileOutputStream fileoutputstream = new FileOutputStream(file);
                    CompressedStreamTools.func_74799_a((CompoundNBT)CompoundNBT1, (OutputStream)fileoutputstream);
                    fileoutputstream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class PlayerDataManager {
        public Map<Class<? extends PlayerData>, PlayerData> data = Maps.newHashMap();
        Map<String, PlayerData> idMap = Maps.newHashMap();
        final String uuid;

        public PlayerDataManager(String uuid) {
            this.uuid = uuid;
            for (Class type : dataMap) {
                try {
                    PlayerData toAdd = (PlayerData)type.newInstance();
                    this.data.put(type, toAdd);
                    this.idMap.put(toAdd.getIdentifier(), toAdd);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }

        public <T extends PlayerData> T getData(Class<T> type) {
            return (T)this.data.get(type);
        }

        public PlayerData getData(String dataType) {
            return this.idMap.get(dataType);
        }
    }

    public static abstract class PlayerData
    implements IPlayerData {
        @Override
        public void readSync(ByteBuf data) {
        }

        @Override
        public void writeSync(ByteBuf data) {
        }
    }

    private static interface IPlayerData {
        public String dataFileName();

        public String getIdentifier();

        public void readFromNBT(CompoundNBT var1);

        public void readSync(ByteBuf var1);

        public boolean shouldSync();

        public void writeSync(ByteBuf var1);

        public void writeToNBT(CompoundNBT var1);

        default public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        }

        default public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        }

        default public boolean canTick() {
            return false;
        }
    }
}

