/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.network;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import thut.core.common.ThutCore;
import thut.core.common.network.NBTPacket;
import thut.core.common.network.PacketAssembly;

public class EntityUpdate
extends NBTPacket {
    public static final PacketAssembly<EntityUpdate> ASSEMBLER = PacketAssembly.registerAssembler(EntityUpdate.class, EntityUpdate::new, ThutCore.packets);

    public static void sendEntityUpdate(Entity entity) {
        if (entity.func_130014_f_().field_72995_K) {
            ThutCore.LOGGER.error("Packet sent on wrong side!", (Throwable)new IllegalArgumentException());
            return;
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("id", entity.func_145782_y());
        CompoundNBT mobtag = new CompoundNBT();
        entity.func_189511_e(mobtag);
        tag.func_218657_a("tag", (INBT)mobtag);
        EntityUpdate message = new EntityUpdate(tag);
        ASSEMBLER.sendToTracking(message, entity);
    }

    public EntityUpdate() {
    }

    public EntityUpdate(CompoundNBT tag) {
        super(tag);
    }

    public EntityUpdate(PacketBuffer buffer) {
        super(buffer);
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150786_a(this.getTag());
    }

    @Override
    protected void onCompleteClient() {
        PlayerEntity player = ThutCore.proxy.getPlayer();
        int id = this.getTag().func_74762_e("id");
        Entity mob = player.func_130014_f_().func_73045_a(id);
        if (mob != null) {
            mob.func_70020_e(this.getTag().func_74775_l("tag"));
        }
    }
}

