/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.network;

import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import thut.core.common.network.Packet;
import thut.core.common.network.PacketAssembly;

public abstract class NBTPacket
extends Packet {
    protected CompoundNBT tag = new CompoundNBT();
    final PacketAssembly<?> assembler = PacketAssembly.ASSEMBLERS.get(this.getClass());

    public NBTPacket() {
    }

    public NBTPacket(CompoundNBT tag) {
        this();
        this.tag = tag;
    }

    public NBTPacket(PacketBuffer buffer) {
        this();
        this.tag = buffer.func_150793_b();
        this.assembler.onRead(this.getTag());
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150786_a(this.getTag());
    }

    public void setTag(CompoundNBT tag) {
        this.tag = tag;
    }

    @Override
    public final void handleServer(ServerPlayerEntity player) {
        CompoundNBT complete = this.assembler.onRead(this.getTag());
        if (complete != null) {
            this.tag = complete;
            if (complete != null) {
                this.onCompleteServer(player);
            }
        }
    }

    @Override
    public final void handleClient() {
        CompoundNBT complete = this.assembler.onRead(this.getTag());
        if (complete != null) {
            this.tag = complete;
            this.onCompleteClient();
        }
    }

    protected void onCompleteClient() {
    }

    protected void onCompleteServer(ServerPlayerEntity player) {
    }

    public CompoundNBT getTag() {
        return this.tag;
    }
}

