/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.network.NetworkEvent;
import thut.api.ThutCaps;
import thut.api.terrain.CapabilityTerrain;
import thut.core.common.ThutCore;
import thut.core.common.network.Packet;

public class TerrainUpdate
extends Packet {
    CompoundNBT tag;

    public static void sendTerrainToClient(World world, ChunkPos pos, ServerPlayerEntity player) {
        CapabilityTerrain.ITerrainProvider provider = (CapabilityTerrain.ITerrainProvider)world.func_212866_a_(pos.field_77276_a, pos.field_77275_b).getCapability(ThutCaps.TERRAIN_CAP, null).orElse(null);
        CompoundNBT terrainData = (CompoundNBT)ThutCaps.TERRAIN_CAP.writeNBT((Object)provider, null);
        terrainData.func_74768_a("c_x", pos.field_77276_a);
        terrainData.func_74768_a("c_z", pos.field_77275_b);
        TerrainUpdate message = new TerrainUpdate(terrainData);
        ThutCore.packets.sendTo(message, player);
    }

    public TerrainUpdate(CompoundNBT tag) {
        super(null);
        this.tag = tag;
    }

    public TerrainUpdate(PacketBuffer buffer) {
        super(buffer);
        this.tag = buffer.func_150793_b();
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player = ThutCore.proxy.getPlayer();
            CompoundNBT nbt = this.tag;
            Chunk chunk = player.func_130014_f_().func_212866_a_(nbt.func_74762_e("c_x"), nbt.func_74762_e("c_z"));
            CapabilityTerrain.ITerrainProvider terrain = (CapabilityTerrain.ITerrainProvider)chunk.getCapability(ThutCaps.TERRAIN_CAP, null).orElse(null);
            ThutCaps.TERRAIN_CAP.readNBT((Object)terrain, null, (INBT)nbt);
        });
        ctx.get().setPacketHandled(true);
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150786_a(this.tag);
    }
}

