/*
 * Decompiled with CFR 0.152.
 */
package thut.core.proxy;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import thut.api.maths.Vector3;
import thut.api.particle.ThutParticles;
import thut.api.terrain.BiomeDatabase;
import thut.api.terrain.TerrainManager;
import thut.api.terrain.TerrainSegment;
import thut.core.client.gui.ConfigGui;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.particle.ParticleFactories;
import thut.core.common.ThutCore;
import thut.core.proxy.CommonProxy;

public class ClientProxy
extends CommonProxy {
    private boolean initParticles = false;

    public static void line(IVertexBuilder builder, Matrix4f positionMatrix, float dx1, float dy1, float dz1, float dx2, float dy2, float dz2, float r, float g, float b, float a) {
        builder.func_227888_a_(positionMatrix, dx1, dy1, dz1).func_227885_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(positionMatrix, dx2, dy2, dz2).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void line(IVertexBuilder builder, Matrix4f positionMatrix, Vector3f start, Vector3f end, float r, float g, float b, float a) {
        ClientProxy.line(builder, positionMatrix, start.func_195899_a(), start.func_195900_b(), start.func_195902_c(), end.func_195899_a(), end.func_195900_b(), end.func_195902_c(), r, g, b, a);
    }

    @Override
    public PlayerEntity getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public boolean isClientSide() {
        return EffectiveSide.get() == LogicalSide.CLIENT;
    }

    @Override
    public boolean isServerSide() {
        return EffectiveSide.get() == LogicalSide.SERVER;
    }

    @Override
    public void loaded(FMLLoadCompleteEvent event) {
        super.loaded(event);
    }

    @Override
    public void setupClient(FMLClientSetupEvent event) {
        super.setupClient(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModList.get().getModContainerById("thutcore").ifPresent(c -> c.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, parent) -> new ConfigGui(ThutCore.conf, (Screen)parent)));
    }

    @Override
    public void setup(FMLCommonSetupEvent event) {
        super.setup(event);
        CapabilityAnimation.setup();
    }

    @SubscribeEvent
    public void startup(WorldEvent.Load event) {
        if (this.initParticles) {
            return;
        }
        this.initParticles = true;
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ThutParticles.AURORA, ParticleFactories.GENERICFACTORY);
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ThutParticles.MISC, ParticleFactories.GENERICFACTORY);
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ThutParticles.STRING, ParticleFactories.GENERICFACTORY);
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ThutParticles.LEAF, ParticleFactories.GENERICFACTORY);
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ThutParticles.POWDER, ParticleFactories.GENERICFACTORY);
    }

    @SubscribeEvent
    public void textOverlay(RenderGameOverlayEvent.Text event) {
        boolean debug = Minecraft.func_71410_x().field_71474_y.field_74330_P;
        if (!debug) {
            return;
        }
        TerrainSegment t = TerrainManager.getInstance().getTerrainForEntity((Entity)Minecraft.func_71410_x().field_71439_g);
        Vector3 v = Vector3.getNewVector().set(Minecraft.func_71410_x().field_71439_g);
        int num = t.getBiome(v);
        String msg = "Sub-Biome: " + I18n.func_135052_a((String)BiomeDatabase.getUnlocalizedNameFromType(num), (Object[])new Object[0]);
        event.getLeft().add("");
        event.getLeft().add(msg);
    }
}

